/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Vector3;

public class Ray
extends Geom {
    private static final long serialVersionUID = -3409642543120515638L;
    private float length;

    public Ray(Space space, float length) {
        super(space, 5, true);
        assert (length > 0.0f) : "length must be greater than 0";
        this.length = length;
        if (space != null) {
            space.add(this);
        }
    }

    private Ray() {
        super(5, true);
    }

    public final float getLength() {
        return this.length;
    }

    public final void setLength(float length) {
        this.length = length;
        Space.onGeomMoved(this);
    }

    public void computeAABB() {
        Vector3 e = new Vector3(this.getPosition());
        e.m[0] = e.m[0] + this.getRotation().m[2] * this.length;
        e.m[1] = e.m[1] + this.getRotation().m[6] * this.length;
        e.m[2] = e.m[2] + this.getRotation().m[10] * this.length;
        if (Float.isNaN(e.m[0])) {
            e.m[0] = this.getPosition().m[0];
        }
        if (Float.isNaN(e.m[1])) {
            e.m[1] = this.getPosition().m[1];
        }
        if (Float.isNaN(e.m[2])) {
            e.m[2] = this.getPosition().m[2];
        }
        float[] aabb = this.getAABB().getValues();
        if (this.getPosition().getX() < e.getX()) {
            aabb[0] = this.getPosition().getX();
            aabb[1] = e.getX();
        } else {
            aabb[0] = e.getX();
            aabb[1] = this.getPosition().getX();
        }
        if (this.getPosition().getX() < e.getX()) {
            aabb[2] = this.getPosition().getX();
            aabb[3] = e.getY();
        } else {
            aabb[2] = e.getY();
            aabb[3] = this.getPosition().getY();
        }
        if (this.getPosition().getZ() < e.getZ()) {
            aabb[4] = this.getPosition().getZ();
            aabb[5] = e.getZ();
        } else {
            aabb[4] = e.getZ();
            aabb[5] = this.getPosition().getZ();
        }
    }

    public Ray cloneState(ClonedReferences util) {
        Ray clone = new Ray();
        this.clonePartialGeom(clone, util);
        clone.length = this.length;
        return clone;
    }
}

