/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointLimitMotor;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class JointAMotor
extends Joint {
    private static final long serialVersionUID = 4099538059695749627L;
    int num;
    int mode;
    int[] rel = new int[3];
    Vector3[] axis = new Vector3[3];
    JointLimitMotor[] limot = new JointLimitMotor[3];
    Vector3 angle = new Vector3();
    Vector3 reference1 = new Vector3();
    Vector3 reference2 = new Vector3();
    public static final int MODE_USER = 1;
    public static final int MODE_EULER = 0;

    public JointAMotor(World world) {
        super(world);
        JointAMotor j = this;
        int i = 0;
        while (i < 3) {
            this.axis[i] = new Vector3();
            ++i;
        }
        j.num = 0;
        j.mode = 1;
        i = 0;
        while (i < 3) {
            j.rel[i] = 0;
            j.axis[i].setZero();
            j.limot[i] = new JointLimitMotor(world);
            j.angle.m[i] = 0.0f;
            ++i;
        }
        j.reference1.setZero();
        j.reference2.setZero();
    }

    void amotorComputeGlobalAxes(Vector3[] ax) {
        JointAMotor joint = this;
        if (joint.mode == 0) {
            MathUtils.dMULTIPLY0_331((Real)ax[0], joint.getBody(0).getRotation(), (Real)joint.axis[0]);
            if (joint.getBody(1) != null) {
                MathUtils.dMULTIPLY0_331((Real)ax[2], joint.getBody(1).getRotation(), (Real)joint.axis[2]);
            } else {
                ax[2].m[0] = joint.axis[2].m[0];
                ax[2].m[1] = joint.axis[2].m[1];
                ax[2].m[2] = joint.axis[2].m[2];
            }
            ax[2].cross(ax[0], ax[1]);
            ax[1].normalize();
        } else {
            int i = 0;
            while (i < joint.num) {
                if (joint.rel[i] == 1) {
                    MathUtils.dMULTIPLY0_331((Real)ax[i], joint.getBody(0).getRotation(), (Real)joint.axis[i]);
                } else if (joint.rel[i] == 2) {
                    if (joint.getBody(1) != null) {
                        MathUtils.dMULTIPLY0_331((Real)ax[i], joint.getBody(1).getRotation(), (Real)joint.axis[i]);
                    }
                } else {
                    ax[i].m[0] = joint.axis[i].m[0];
                    ax[i].m[1] = joint.axis[i].m[1];
                    ax[i].m[2] = joint.axis[i].m[2];
                }
                ++i;
            }
        }
    }

    void amotorComputeEulerAngles(Vector3[] ax) {
        JointAMotor joint = this;
        Vector3 ref1 = new Vector3();
        Vector3 ref2 = new Vector3();
        MathUtils.dMULTIPLY0_331((Real)ref1, joint.getBody(0).getRotation(), (Real)joint.reference1);
        if (joint.getBody(1) != null) {
            MathUtils.dMULTIPLY0_331((Real)ref2, joint.getBody(1).getRotation(), (Real)joint.reference2);
        } else {
            ref2.m[0] = joint.reference2.m[0];
            ref2.m[1] = joint.reference2.m[1];
            ref2.m[2] = joint.reference2.m[2];
        }
        Vector3 q = new Vector3();
        ax[0].cross(ref1, q);
        joint.angle.m[0] = (float)(-Math.atan2(ax[2].dot(q), ax[2].dot(ref1)));
        ax[0].cross(ax[1], q);
        joint.angle.m[1] = (float)(-Math.atan2(ax[2].dot(ax[0]), ax[2].dot(q)));
        ax[1].cross(ax[2], q);
        joint.angle.m[2] = (float)(-Math.atan2(ref2.dot(ax[1]), ref2.dot(q)));
    }

    void amotorSetEulerReferenceVectors() {
        JointAMotor j = this;
        if (j.getBody(0) != null && j.getBody(1) != null) {
            Vector3 r = new Vector3();
            MathUtils.dMULTIPLY0_331((Real)r, j.getBody(1).getRotation(), (Real)j.axis[2]);
            MathUtils.dMULTIPLY1_331(j.reference1, j.getBody(0).getRotation(), r);
            MathUtils.dMULTIPLY0_331((Real)r, j.getBody(0).getRotation(), (Real)j.axis[0]);
            MathUtils.dMULTIPLY1_331(j.reference2, j.getBody(1).getRotation(), r);
        } else {
            Vector3 r = new Vector3();
            r.m[0] = j.axis[2].m[0];
            r.m[1] = j.axis[2].m[1];
            r.m[2] = j.axis[2].m[2];
            r.m[3] = j.axis[2].m[3];
            MathUtils.dMULTIPLY1_331(j.reference1, j.getBody(0).getRotation(), r);
            MathUtils.dMULTIPLY0_331((Real)r, j.getBody(0).getRotation(), (Real)j.axis[0]);
            j.reference2.m[0] = j.reference2.m[0] + r.m[0];
            j.reference2.m[1] = j.reference2.m[1] + r.m[1];
            j.reference2.m[2] = j.reference2.m[2] + r.m[2];
            j.reference2.m[3] = j.reference2.m[3] + r.m[3];
        }
    }

    public void getInfo1(Joint.Info1 info) {
        info.m = 0;
        info.nub = 0;
        if (this.mode == 0) {
            Vector3[] ax = new Vector3[3];
            int i = 0;
            while (i < 3) {
                ax[i] = new Vector3();
                ++i;
            }
            this.amotorComputeGlobalAxes(ax);
            this.amotorComputeEulerAngles(ax);
        }
        int i = 0;
        while (i < this.num) {
            if (this.limot[i].testRotationalLimit(this.angle.m[i]) || this.limot[i].getMaxForce() > 0.0f) {
                ++info.m;
            }
            ++i;
        }
    }

    public void getInfo2(Joint.Info2 info) {
        JointAMotor joint = this;
        Vector3[] ax = new Vector3[3];
        int i = 0;
        while (i < 3) {
            ax[i] = new Vector3();
            ++i;
        }
        this.amotorComputeGlobalAxes(ax);
        Vector3[] axptr = new Vector3[]{ax[0], ax[1], ax[2]};
        Vector3 ax0_cross_ax1 = new Vector3();
        Vector3 ax1_cross_ax2 = new Vector3();
        if (joint.mode == 0) {
            ax[0].cross(ax[2], ax0_cross_ax1);
            axptr[2] = ax0_cross_ax1;
            ax[1].cross(ax[2], ax1_cross_ax2);
            axptr[0] = ax1_cross_ax2;
        }
        int row = 0;
        i = 0;
        while (i < joint.num) {
            if (joint.limot[i].addLimot(joint, info, row, axptr[i], true)) {
                ++row;
            }
            ++i;
        }
    }

    public SimState cloneState(ClonedReferences util) {
        return null;
    }

    public void dJointSetAMotorNumAxes(int num) {
        JointAMotor joint = this;
        assert (num >= 0 && num <= 3);
        if (joint.mode == 0) {
            joint.num = 3;
        } else {
            if (num < 0) {
                num = 0;
            }
            if (num > 3) {
                num = 3;
            }
            joint.num = num;
        }
    }

    public void dJointSetAMotorAxis(int anum, int rel, float x, float y, float z) {
        JointAMotor joint = this;
        assert (anum >= 0 && anum <= 2 && rel >= 0 && rel <= 2);
        assert (joint.getBody(1) != null || !joint.getFlag(2) || rel != 1) : "no first body, can't set axis rel=1";
        assert (joint.getBody(1) != null || joint.getFlag(2) || rel != 2) : "no second body, can't set axis rel=2";
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        if (joint.getBody(1) == null && rel == 2) {
            rel = 1;
        }
        joint.rel[anum] = rel;
        Vector3 r = new Vector3();
        r.m[0] = x;
        r.m[1] = y;
        r.m[2] = z;
        r.m[3] = 0.0f;
        if (rel > 0) {
            if (rel == 1) {
                MathUtils.dMULTIPLY1_331(joint.axis[anum], joint.getBody(0).getRotation(), r);
            } else if (joint.getBody(1) != null) {
                MathUtils.dMULTIPLY1_331(joint.axis[anum], joint.getBody(1).getRotation(), r);
            } else {
                joint.axis[anum].m[0] = r.m[0];
                joint.axis[anum].m[1] = r.m[1];
                joint.axis[anum].m[2] = r.m[2];
                joint.axis[anum].m[3] = r.m[3];
            }
        } else {
            joint.axis[anum].m[0] = r.m[0];
            joint.axis[anum].m[1] = r.m[1];
            joint.axis[anum].m[2] = r.m[2];
        }
        joint.axis[anum].normalize();
        if (joint.mode == 0) {
            this.amotorSetEulerReferenceVectors();
        }
    }

    public void dJointSetAMotorAngle(int anum, float angle) {
        JointAMotor joint = this;
        assert (anum >= 0 && anum < 3);
        if (joint.mode == 1) {
            if (anum < 0) {
                anum = 0;
            }
            if (anum > 3) {
                anum = 3;
            }
            joint.angle.m[anum] = angle;
        }
    }

    public void dJointSetAMotorMode(int mode) {
        JointAMotor joint = this;
        joint.mode = mode;
        if (joint.mode == 0) {
            joint.num = 3;
            this.amotorSetEulerReferenceVectors();
        }
    }

    public int dJointGetAMotorNumAxes() {
        JointAMotor joint = this;
        return joint.num;
    }

    public void dJointGetAMotorAxis(int anum, Vector3 result) {
        JointAMotor joint = this;
        assert (anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        if (joint.rel[anum] > 0) {
            if (joint.rel[anum] == 1) {
                MathUtils.dMULTIPLY0_331((Real)result, joint.getBody(0).getRotation(), (Real)joint.axis[anum]);
            } else if (joint.getBody(1) != null) {
                MathUtils.dMULTIPLY0_331((Real)result, joint.getBody(1).getRotation(), (Real)joint.axis[anum]);
            } else {
                result.m[0] = joint.axis[anum].m[0];
                result.m[1] = joint.axis[anum].m[1];
                result.m[2] = joint.axis[anum].m[2];
                result.m[3] = joint.axis[anum].m[3];
            }
        } else {
            result.m[0] = joint.axis[anum].m[0];
            result.m[1] = joint.axis[anum].m[1];
            result.m[2] = joint.axis[anum].m[2];
        }
    }

    public int dJointGetAMotorAxisRel(int anum) {
        JointAMotor joint = this;
        assert (anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 2) {
            anum = 2;
        }
        return joint.rel[anum];
    }

    public float dJointGetAMotorAngle(int anum) {
        JointAMotor joint = this;
        assert (anum >= 0 && anum < 3);
        if (anum < 0) {
            anum = 0;
        }
        if (anum > 3) {
            anum = 3;
        }
        return joint.angle.m[anum];
    }

    public void dJointAddAMotorTorques(float torque1, float torque2, float torque3) {
        JointAMotor joint = this;
        Vector3[] axes = new Vector3[3];
        if (joint.num == 0) {
            return;
        }
        assert (!joint.getFlag(2)) : "dJointAddAMotorTorques not yet implemented for reverse AMotor joints";
        this.amotorComputeGlobalAxes(axes);
        axes[0].m[0] = axes[0].m[0] * torque1;
        axes[0].m[1] = axes[0].m[1] * torque1;
        axes[0].m[2] = axes[0].m[2] * torque1;
        if (joint.num >= 2) {
            axes[0].m[0] = axes[0].m[0] + axes[1].m[0] * torque2;
            axes[0].m[1] = axes[0].m[1] + axes[1].m[1] * torque2;
            axes[0].m[2] = axes[0].m[2] + axes[1].m[2] * torque2;
            if (joint.num >= 3) {
                axes[0].m[0] = axes[0].m[0] + axes[2].m[0] * torque3;
                axes[0].m[1] = axes[0].m[1] + axes[2].m[1] * torque3;
                axes[0].m[2] = axes[0].m[2] + axes[2].m[2] * torque3;
            }
        }
        if (joint.getBody(0) != null) {
            joint.getBody(0).addTorque(axes[0].m[0], axes[0].m[1], axes[0].m[2]);
        }
        if (joint.getBody(1) != null) {
            joint.getBody(1).addTorque(-axes[0].m[0], -axes[0].m[1], -axes[0].m[2]);
        }
    }

    public JointLimitMotor getLimitMotor(int axis) {
        return this.limot[axis];
    }
}

