/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointUtils;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class JointFixed
extends Joint {
    private static final long serialVersionUID = -8637975879567712085L;
    private final Vector3 offset = new Vector3();
    private final Quaternion qrel = new Quaternion();

    public JointFixed(World world) {
        super(world);
    }

    public JointFixed() {
    }

    public final void setInitialRotation(Quaternion rot) {
        this.qrel.set(rot);
    }

    public final void setInitialRotation(Matrix3 rot) {
        this.qrel.set(rot);
    }

    public final Quaternion getInitialRotation() {
        return this.qrel;
    }

    public final void setOffset(float x, float y, float z) {
        this.offset.set(x, y, z);
    }

    public final void setOffset(Vector3 offset) {
        this.offset.set(offset);
    }

    public final Vector3 getOffset() {
        return this.offset;
    }

    public void getInfo1(Joint.Info1 info) {
        info.m = 6;
        info.nub = 6;
    }

    public void getInfo2(Joint.Info2 info) {
        int s = info.rowskip;
        JointUtils.setFixedOrientation(this, info, this.qrel, 3);
        info.J1l.setValue(0, 1.0f);
        info.J1l.setValue(s + 1, 1.0f);
        info.J1l.setValue(2 * s + 2, 1.0f);
        Vector3 ofs = new Vector3();
        MathUtils.dMULTIPLY0_331((Real)ofs, this.getBody(0).getRotation(), (Real)this.offset);
        if (this.getBody(1) != null) {
            MathUtils.dCROSSMAT_PLUS_MINUS(info.J1a, new RealPointer(ofs), s);
            info.J2l.setValue(0, -1.0f);
            info.J2l.setValue(s + 1, -1.0f);
            info.J2l.setValue(2 * s + 2, -1.0f);
        }
        float k = info.fps * info.erp;
        if (this.getBody(1) != null) {
            int j = 0;
            while (j < 3) {
                info.c.setValue(j, k * (this.getBody((int)1).getPosition().m[j] - this.getBody((int)0).getPosition().m[j] + ofs.m[j]));
                ++j;
            }
        } else {
            int j = 0;
            while (j < 3) {
                info.c.setValue(j, k * (this.offset.m[j] - this.getBody((int)0).getPosition().m[j]));
                ++j;
            }
        }
    }

    public final void setFixed() {
        if (this.getBody(0) != null) {
            if (this.getBody(1) != null) {
                this.getBody(0).getQuaternion().mul(this.getBody(1).getQuaternion(), this.qrel);
                Real ofs = new Real(4);
                int i = 0;
                while (i < 4) {
                    ofs.m[i] = this.getBody((int)0).getPosition().m[i];
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    int n = i;
                    ofs.m[n] = ofs.m[n] - this.getBody((int)1).getPosition().m[i];
                    ++i;
                }
                MathUtils.dMULTIPLY1_331(this.offset, this.getBody(0).getRotation(), ofs);
            } else {
                this.qrel.m[0] = this.getBody((int)0).getQuaternion().m[0];
                int i = 1;
                while (i < 4) {
                    this.qrel.m[i] = -this.getBody((int)0).getQuaternion().m[i];
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    this.offset.m[i] = this.getBody((int)0).getPosition().m[i];
                    ++i;
                }
            }
        }
    }

    public JointFixed cloneState(ClonedReferences util) {
        JointFixed clone = new JointFixed();
        this.partialCloneJoint(clone, util);
        clone.offset.set(this.offset);
        clone.qrel.set(this.qrel);
        return clone;
    }
}

