/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class JointLimitMotor
implements SimState {
    private static final long serialVersionUID = -4108019893668692267L;
    private float vel;
    private float fmax;
    private float lowStop;
    private float highStop;
    private float fudge_factor;
    private float normal_cfm;
    private float stop_erp;
    private float stop_cfm;
    private float bounce;
    private int limit;
    private float limit_err;

    public JointLimitMotor(World world) {
        this.vel = 0.0f;
        this.fmax = 0.0f;
        this.lowStop = Float.NEGATIVE_INFINITY;
        this.highStop = Float.POSITIVE_INFINITY;
        this.fudge_factor = 1.0f;
        this.normal_cfm = world.getGlobalCFM();
        this.stop_erp = world.getGlobalERP();
        this.stop_cfm = world.getGlobalCFM();
        this.bounce = 0.0f;
        this.limit = 0;
        this.limit_err = 0.0f;
    }

    private JointLimitMotor() {
    }

    public final void setVelocity(float velocity) {
        this.vel = velocity;
    }

    public final float getVelocity() {
        return this.vel;
    }

    public final void setMaxForce(float maxForce) {
        this.fmax = maxForce;
    }

    public final float getMaxForce() {
        return this.fmax;
    }

    public final void setLowStop(float lowStop) {
        this.lowStop = lowStop;
    }

    public final float getLowStop() {
        return this.lowStop;
    }

    public final void setHighStop(float hiStop) {
        this.highStop = hiStop;
    }

    public final float getHighStop() {
        return this.highStop;
    }

    public final void setFudgeFactor(float fudgeFactor) {
        this.fudge_factor = fudgeFactor;
    }

    public final float getFudgeFactor() {
        return this.fudge_factor;
    }

    public final void setNormalCFM(float normalCFM) {
        this.normal_cfm = normalCFM;
    }

    public final float getNormalCFM() {
        return this.normal_cfm;
    }

    public final void setStopERP(float stopERP) {
        this.stop_erp = stopERP;
    }

    public final float getStopERP() {
        return this.stop_erp;
    }

    public final void setStopCFM(float stopCFM) {
        this.stop_cfm = stopCFM;
    }

    public final float getStopCFM() {
        return this.stop_cfm;
    }

    public final void setBounce(float bounce) {
        this.bounce = bounce;
    }

    public final float getBounce() {
        return this.bounce;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimitError(float limitErr) {
        this.limit_err = limitErr;
    }

    public final float getLimitError() {
        return this.limit_err;
    }

    public boolean testRotationalLimit(float angle) {
        if (angle <= this.lowStop) {
            this.limit = 1;
            this.limit_err = angle - this.lowStop;
            return true;
        }
        if (angle >= this.highStop) {
            this.limit = 2;
            this.limit_err = angle - this.highStop;
            return true;
        }
        this.limit = 0;
        return false;
    }

    public boolean addLimot(Joint joint, Joint.Info2 info, int row, Vector3 ax1, boolean rotational) {
        boolean powered;
        int srow = row * info.rowskip;
        boolean bl = powered = this.fmax > 0.0f;
        if (powered || this.limit > 0) {
            RealPointer J1 = rotational ? info.J1a : info.J1l;
            RealPointer J2 = rotational ? info.J2a : info.J2l;
            J1.setValue(srow + 0, ax1.m[0]);
            J1.setValue(srow + 1, ax1.m[1]);
            J1.setValue(srow + 2, ax1.m[2]);
            if (joint.getBody(1) != null) {
                J2.setValue(srow + 0, -ax1.m[0]);
                J2.setValue(srow + 1, -ax1.m[1]);
                J2.setValue(srow + 2, -ax1.m[2]);
            }
            if (this.limit != 0 && this.lowStop == this.highStop) {
                powered = false;
            }
            if (powered) {
                info.cfm.setValue(row, this.normal_cfm);
                if (this.limit == 0) {
                    info.c.setValue(row, this.vel);
                    info.lo.setValue(row, -this.fmax);
                    info.hi.setValue(row, this.fmax);
                } else {
                    float fm = this.fmax;
                    if (this.vel > 0.0f) {
                        fm = -fm;
                    }
                    if (this.limit == 1 && this.vel > 0.0f || this.limit == 2 && this.vel < 0.0f) {
                        fm *= this.fudge_factor;
                    }
                    if (rotational) {
                        joint.getBody(0).addTorque(-fm * ax1.m[0], -fm * ax1.m[1], -fm * ax1.m[2]);
                        if (joint.getBody(1) != null) {
                            joint.getBody(1).addTorque(fm * ax1.m[0], fm * ax1.m[1], fm * ax1.m[2]);
                        }
                    } else {
                        joint.getBody(0).addForce(-fm * ax1.m[0], -fm * ax1.m[1], -fm * ax1.m[2]);
                        if (joint.getBody(1) != null) {
                            joint.getBody(1).addForce(fm * ax1.m[0], fm * ax1.m[1], fm * ax1.m[2]);
                            Vector3 c = new Vector3();
                            c.m[0] = 0.5f * (joint.getBody(1).getPosRot().getPosition().getX() - joint.getBody(0).getPosRot().getPosition().getX());
                            c.m[1] = 0.5f * (joint.getBody(1).getPosRot().getPosition().getY() - joint.getBody(0).getPosRot().getPosition().getY());
                            c.m[2] = 0.5f * (joint.getBody(1).getPosRot().getPosition().getZ() - joint.getBody(0).getPosRot().getPosition().getZ());
                            Vector3 ltd = c.cross(ax1);
                            info.J1a.setValue(srow + 0, ltd.m[0]);
                            info.J1a.setValue(srow + 1, ltd.m[1]);
                            info.J1a.setValue(srow + 2, ltd.m[2]);
                            info.J2a.setValue(srow + 0, ltd.m[0]);
                            info.J2a.setValue(srow + 1, ltd.m[1]);
                            info.J2a.setValue(srow + 2, ltd.m[2]);
                            joint.getBody(0).addTorque(-fm * ltd.m[0], -fm * ltd.m[1], -fm * ltd.m[2]);
                            joint.getBody(1).addTorque(-fm * ltd.m[0], -fm * ltd.m[1], -fm * ltd.m[2]);
                        }
                    }
                }
            }
            if (this.limit != 0) {
                float k = info.fps * this.stop_erp;
                info.c.setValue(row, -k * this.limit_err);
                info.cfm.setValue(row, this.stop_cfm);
                if (this.lowStop == this.highStop) {
                    info.lo.setValue(row, Float.NEGATIVE_INFINITY);
                    info.hi.setValue(row, Float.POSITIVE_INFINITY);
                } else {
                    if (this.limit == 1) {
                        info.lo.setValue(row, 0.0f);
                        info.hi.setValue(row, Float.POSITIVE_INFINITY);
                    } else {
                        info.lo.setValue(row, Float.NEGATIVE_INFINITY);
                        info.hi.setValue(row, 0.0f);
                    }
                    if (this.bounce > 0.0f) {
                        float newc;
                        float vel;
                        if (rotational) {
                            vel = joint.getBody(0).getAngularVel().dot(ax1);
                            if (joint.getBody(1) != null) {
                                vel -= joint.getBody(1).getAngularVel().dot(ax1);
                            }
                        } else {
                            vel = joint.getBody(0).getLinearVel().dot(ax1);
                            if (joint.getBody(1) != null) {
                                vel -= joint.getBody(1).getLinearVel().dot(ax1);
                            }
                        }
                        if (this.limit == 1) {
                            float newc2;
                            if (vel < 0.0f && (newc2 = -this.bounce * vel) > info.c.getValue(row)) {
                                info.c.setValue(row, newc2);
                            }
                        } else if (vel > 0.0f && (newc = this.bounce * vel) < info.c.getValue(row)) {
                            info.c.setValue(row, newc);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public SimState cloneState(ClonedReferences util) {
        JointLimitMotor clone = new JointLimitMotor();
        util.addClone(this, clone);
        clone.vel = this.vel;
        clone.fmax = this.fmax;
        clone.lowStop = this.lowStop;
        clone.highStop = this.highStop;
        clone.fudge_factor = this.fudge_factor;
        clone.normal_cfm = this.normal_cfm;
        clone.stop_erp = this.stop_erp;
        clone.stop_cfm = this.stop_cfm;
        clone.bounce = this.bounce;
        clone.limit = this.limit;
        clone.limit_err = this.limit_err;
        return clone;
    }
}

