/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointLimitMotor;
import net.java.dev.joode.joint.JointUtils;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class JointSlider
extends Joint {
    private static final long serialVersionUID = -1240210914669738245L;
    private final Vector3 axis1 = new Vector3();
    private final Quaternion qrel = new Quaternion();
    private final Vector3 offset = new Vector3();
    private JointLimitMotor limot;

    public JointSlider(World world, JointLimitMotor limot) {
        super(world);
        this.limot = limot;
    }

    public JointSlider(World world) {
        super(world);
        this.limot = new JointLimitMotor(world);
    }

    private JointSlider() {
    }

    public final void setAxis1(float x, float y, float z) {
        this.axis1.set(x, y, z);
    }

    public final void setAxis1(Vector3 axis) {
        this.axis1.set(axis);
    }

    public final Vector3 getAxis1() {
        return this.axis1;
    }

    public final void setInitialRotation(Quaternion rot) {
        this.qrel.set(rot);
    }

    public final void setInitialRotation(Matrix3 rot) {
        this.qrel.set(rot);
    }

    public final Quaternion getInitialRotation() {
        return this.qrel;
    }

    public final void setOffset(float x, float y, float z) {
        this.offset.set(x, y, z);
    }

    public final void setOffset(Vector3 offset) {
        this.offset.set(offset);
    }

    public final Vector3 getOffset() {
        return this.offset;
    }

    public final void setLimitMotor(JointLimitMotor limot) {
        this.limot = limot;
    }

    public final JointLimitMotor getLimitMotor() {
        return this.limot;
    }

    public void getInfo1(Joint.Info1 info) {
        info.nub = 5;
        info.m = this.limot.getMaxForce() > 0.0f ? 6 : 5;
        this.limot.setLimit(0);
        if ((this.limot.getLowStop() > Float.NEGATIVE_INFINITY || this.limot.getHighStop() < Float.POSITIVE_INFINITY) && this.limot.getLowStop() <= this.limot.getHighStop()) {
            float pos = this.getPosition();
            if (pos <= this.limot.getLowStop()) {
                this.limot.setLimit(1);
                this.limot.setLimitError(pos - this.limot.getLowStop());
                info.m = 6;
            } else if (pos >= this.limot.getHighStop()) {
                this.limot.setLimit(2);
                this.limot.setLimitError(pos - this.limot.getHighStop());
                info.m = 6;
            }
        }
    }

    public void getInfo2(Joint.Info2 info) {
        int i;
        RealPointer R2;
        RealPointer pos2;
        int s = info.rowskip;
        int s3 = 3 * s;
        int s4 = 4 * s;
        Vector3 c = new Vector3();
        RealPointer pos1 = new RealPointer(this.getBody(0).getPosition());
        RealPointer R1 = new RealPointer(this.getBody(0).getRotation());
        if (this.getBody(1) != null) {
            pos2 = new RealPointer(this.getBody(1).getPosition());
            R2 = new RealPointer(this.getBody(1).getRotation());
            i = 0;
            while (i < 3) {
                c.m[i] = pos2.getValue(i) - pos1.getValue(i);
                ++i;
            }
        } else {
            pos2 = null;
            R2 = null;
        }
        JointUtils.setFixedOrientation(this, info, this.qrel, 0);
        Vector3 ax1 = new Vector3();
        Vector3 p = new Vector3();
        Vector3 q = new Vector3();
        MathUtils.dMULTIPLY0_331(new RealPointer(ax1), R1, new RealPointer(this.axis1));
        ax1.constructPlaneSpace(p, q);
        if (this.getBody(1) != null) {
            Vector3 tmp = new Vector3();
            i = 0;
            while (i < 3) {
                info.J2a.setValue(s3 + i, tmp.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2a.setValue(s3 + i, tmp.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2a.setValue(s4 + i, tmp.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2a.setValue(s4 + i, tmp.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2l.setValue(s3 + i, -p.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2l.setValue(s4 + i, -q.m[i]);
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            info.J1l.setValue(s3 + i, p.m[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            info.J1l.setValue(s4 + i, q.m[i]);
            ++i;
        }
        float k = info.fps * info.erp;
        if (this.getBody(1) != null) {
            Vector3 ofs = new Vector3();
            MathUtils.dMULTIPLY0_331(new RealPointer(ofs), R2, new RealPointer(this.offset));
            i = 0;
            while (i < 3) {
                int n = i;
                c.m[n] = c.m[n] + ofs.m[i];
                ++i;
            }
            info.c.setValue(3, k * p.dot(c));
            info.c.setValue(4, k * q.dot(c));
        } else {
            Vector3 ofs = new Vector3();
            i = 0;
            while (i < 3) {
                ofs.m[i] = this.offset.m[i] - pos1.getValue(i);
                ++i;
            }
            info.c.setValue(3, k * p.dot(ofs));
            info.c.setValue(4, k * q.dot(ofs));
        }
        this.limot.addLimot(this, info, 5, ax1, false);
    }

    public final void setAxis(float x, float y, float z) {
        JointSlider joint = this;
        JointUtils.setAxes(this, x, y, z, this.axis1, null);
        if (joint.getBody(1) != null) {
            this.getBody(0).getQuaternion().mul(this.getBody(1).getQuaternion(), this.qrel);
            Vector3 c = new Vector3();
            int i = 0;
            while (i < 3) {
                c.m[i] = joint.getBody((int)0).getPosition().m[i] - joint.getBody((int)1).getPosition().m[i];
                ++i;
            }
            MathUtils.dMULTIPLY1_331(joint.offset, joint.getBody(1).getRotation(), c);
        } else {
            joint.qrel.m[0] = joint.getBody((int)0).getQuaternion().m[0];
            int i = 1;
            while (i < 4) {
                joint.qrel.m[i] = -joint.getBody((int)0).getQuaternion().m[i];
                ++i;
            }
            i = 0;
            while (i < 3) {
                joint.offset.m[i] = joint.getBody((int)0).getPosition().m[i];
                ++i;
            }
        }
    }

    private float getPosition() {
        Vector3 ax1 = new Vector3();
        MathUtils.dMULTIPLY0_331((Real)ax1, this.getBody(0).getPosRot().getRotation(), (Real)this.axis1);
        Vector3 q = new Vector3();
        if (this.getBody(1) != null) {
            MathUtils.dMULTIPLY0_331((Real)q, this.getBody(1).getPosRot().getRotation(), (Real)this.offset);
            int i = 0;
            while (i < 3) {
                q.m[i] = this.getBody((int)0).getPosRot().getPosition().m[i] - q.m[i] - this.getBody((int)1).getPosRot().getPosition().m[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < 3) {
                q.m[i] = this.getBody((int)0).getPosRot().getPosition().m[i] - this.offset.m[i];
                ++i;
            }
        }
        return ax1.dot(q);
    }

    public JointSlider cloneState(ClonedReferences util) {
        JointSlider clone = new JointSlider();
        this.partialCloneJoint(clone, util);
        clone.axis1.set(this.axis1);
        clone.offset.set(this.offset);
        clone.qrel.set(this.qrel);
        clone.limot = (JointLimitMotor)util.getClone(this.limot);
        return clone;
    }
}

