/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.JOODELog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleSpace
extends Space {
    protected final ArrayList<Geom> clean = new ArrayList();
    protected final ArrayList<Geom> dirty = new ArrayList();

    public AbstractSimpleSpace(Space parent, int type) {
        super(parent, type);
    }

    @Override
    public Iterator<Geom> getGeomIterator() {
        if (!this.dirty.isEmpty()) {
            JOODELog.error("dirty not empty when calling iterator!!");
        }
        return this.clean.iterator();
    }

    @Override
    public int getNumGeoms() {
        return this.clean.size() + this.dirty.size();
    }

    @Override
    public void getGeoms(List<Geom> geoms) {
        geoms.addAll(this.clean);
        geoms.addAll(this.dirty);
    }

    @Override
    public void remove(Geom g) {
        if (g.getParentSpace() != this) {
            throw new IllegalArgumentException("geom is not a member of this space");
        }
        g.setParentSpace(null);
        if (this.clean.remove(g)) {
            AbstractSimpleSpace.onGeomMoved(this);
        } else if (this.dirty.remove(g)) {
            AbstractSimpleSpace.onGeomMoved(this);
        }
        this.notifyGeomRemoved(g);
    }

    @Override
    public boolean isEmpty() {
        if (!this.dirty.isEmpty()) {
            JOODELog.error("dirty not empty when asking if empty!!");
        }
        return this.clean.isEmpty();
    }

    @Override
    public void add(Geom g) {
        if (g.getParentSpace() != null) {
            throw new IllegalArgumentException("geom is a member of a space already");
        }
        g.setParentSpace(this);
        this.dirty.add(g);
        g.setFlag(GEOM_DIRTY | GEOM_AABB_BAD, true);
        AbstractSimpleSpace.onGeomMoved(this);
        this.notifyGeomAdded(g);
    }

    @Override
    void dirty(Geom g) {
        if (this.clean.remove(g)) {
            this.dirty.add(g);
            AbstractSimpleSpace.onGeomMoved(this);
        }
    }

    @Override
    public void cleanGeoms() {
        int i = 0;
        while (i < this.dirty.size()) {
            Geom g = this.dirty.get(i);
            if (g instanceof Space) {
                ((Space)g).cleanGeoms();
            }
            g.recomputeAABB();
            this.clean.add(g);
            ++i;
        }
        this.dirty.clear();
    }
}

