/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.space.octtree.OctTree;
import net.java.dev.joode.util.JOODELog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OctTreeSpace
extends Space {
    private static final long serialVersionUID = -6505584930710482247L;
    public static final HashSet<Geom> tmp = new HashSet();
    ArrayList<Geom> dirty;
    OctTree clean = new OctTree();

    public OctTreeSpace(Space parent) {
        super(parent, 13);
        this.dirty = new ArrayList();
        if (parent != null) {
            parent.add(this);
        }
    }

    private OctTreeSpace() {
        this.dirty = new ArrayList();
    }

    @Override
    protected boolean isEmpty() {
        if (!this.dirty.isEmpty()) {
            JOODELog.error("dirty not empty when asking if empty!!");
        }
        return this.clean.getNumGeoms() == 0;
    }

    @Override
    public Iterator<Geom> getGeomIterator() {
        if (!this.dirty.isEmpty()) {
            JOODELog.error("dirty not empty when calling iterator!!");
        }
        return this.clean.iterator();
    }

    @Override
    public int getNumGeoms() {
        return this.clean.getNumGeoms() + this.dirty.size();
    }

    @Override
    public void getGeoms(List<Geom> geoms) {
        geoms.addAll(this.dirty);
        this.clean.getGeoms(tmp);
        geoms.addAll(tmp);
        tmp.clear();
    }

    @Override
    public void cleanGeoms() {
        for (Geom g : this.dirty) {
            if (g instanceof Space) {
                ((Space)g).cleanGeoms();
            }
            g.recomputeAABB();
            g.setFlag(GEOM_DIRTY | GEOM_AABB_BAD, false);
            this.clean.add(g);
        }
        this.dirty.clear();
    }

    @Override
    public void computeAABB() {
        this.getAABB().set(this.clean.getAABB());
    }

    @Override
    public void collideAll(Object data, NearCallback callback) {
        this.cleanGeoms();
        this.clean.collide(data, callback);
    }

    @Override
    public void collide(Object data, Geom geom, boolean spaceIsFirst, NearCallback callback) {
        this.cleanGeoms();
        if (geom instanceof Space) {
            ((Space)geom).cleanGeoms();
        }
        geom.recomputeAABB();
        this.clean.collide2(data, geom, spaceIsFirst, callback);
    }

    @Override
    public void add(Geom g) {
        if (g.getParentSpace() != null) {
            throw new IllegalArgumentException("geom is a member of a space allready");
        }
        g.setParentSpace(this);
        this.dirty.add(g);
        g.setFlag(GEOM_DIRTY | GEOM_AABB_BAD, true);
        OctTreeSpace.onGeomMoved(this);
        this.notifyGeomAdded(g);
    }

    @Override
    public void remove(Geom g) {
        if (g.getParentSpace() != this) {
            throw new IllegalArgumentException("geom is not a member of this space");
        }
        g.setParentSpace(null);
        if (this.clean.remove(g)) {
            OctTreeSpace.onGeomMoved(this);
        } else if (this.dirty.contains(g)) {
            this.dirty.remove(g);
            OctTreeSpace.onGeomMoved(this);
        }
        this.notifyGeomRemoved(g);
    }

    @Override
    public OctTreeSpace cloneState(ClonedReferences util) {
        OctTreeSpace clone = new OctTreeSpace();
        this.clonePartialSpace(clone, util);
        int i = 0;
        while (i < this.dirty.size()) {
            clone.dirty.add((Geom)util.getClone(this.dirty.get(i)));
            ++i;
        }
        clone.clean = (OctTree)util.getClone(this.clean);
        return clone;
    }
}

