/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space.octtree;

import java.util.LinkedHashSet;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.octtree.OctTreeNode;
import net.java.dev.joode.util.AABB3f;

public class OctTree
extends OctTreeNode {
    private static final long serialVersionUID = -1343624737495586308L;

    public OctTree() {
        super(OctTreeNode.SplitType.X, new AABB3f(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f));
    }

    private OctTreeNode makeNode() {
        OctTreeNode otn = new OctTreeNode(this.type, this.aabb);
        otn.right = this.right;
        otn.left = this.left;
        otn.geoms = this.geoms;
        otn.numGeoms = this.numGeoms;
        otn.splitPos = this.splitPos;
        otn.splitted = this.splitted;
        this.geoms = new LinkedHashSet();
        return otn;
    }

    public void add(Geom g) {
        AABB3f aabb2;
        OctTreeNode otn;
        boolean b = false;
        if (g.getAABB().getMinX() < this.aabb.getMinX()) {
            this.right = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMinX(this.aabb.getMinX() - (this.aabb.getMaxX() - this.aabb.getMinX()));
            aabb2.setMaxX(this.aabb.getMinX());
            this.aabb.setMinX(aabb2.getMinX());
            this.left = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxX() + this.aabb.getMinX()) / 2.0f;
            this.type = OctTreeNode.SplitType.X;
            b = true;
        }
        if (g.getAABB().getMaxX() > this.aabb.getMaxX()) {
            this.left = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMaxX(this.aabb.getMaxX() + (this.aabb.getMaxX() - this.aabb.getMinX()));
            aabb2.setMinX(this.aabb.getMaxX());
            this.aabb.setMaxX(aabb2.getMaxX());
            this.right = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxX() + this.aabb.getMinX()) / 2.0f;
            this.type = OctTreeNode.SplitType.X;
            b = true;
        }
        if (g.getAABB().getMinY() < this.aabb.getMinY()) {
            this.right = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMinY(this.aabb.getMinY() - (this.aabb.getMaxY() - this.aabb.getMinY()));
            aabb2.setMaxY(this.aabb.getMinY());
            this.aabb.setMinY(aabb2.getMinY());
            this.left = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxY() + this.aabb.getMinY()) / 2.0f;
            this.type = OctTreeNode.SplitType.Y;
            b = true;
        }
        if (g.getAABB().getMaxY() > this.aabb.getMaxY()) {
            this.left = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMaxY(this.aabb.getMaxY() + (this.aabb.getMaxY() - this.aabb.getMinY()));
            aabb2.setMinY(this.aabb.getMaxY());
            this.aabb.setMaxY(aabb2.getMaxY());
            this.right = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxY() + this.aabb.getMinY()) / 2.0f;
            this.type = OctTreeNode.SplitType.Y;
            b = true;
        }
        if (g.getAABB().getMinZ() < this.aabb.getMinZ()) {
            this.right = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMinZ(this.aabb.getMinZ() - (this.aabb.getMaxZ() - this.aabb.getMinZ()));
            aabb2.setMaxZ(this.aabb.getMinZ());
            this.aabb.setMinZ(aabb2.getMinZ());
            this.left = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxZ() + this.aabb.getMinZ()) / 2.0f;
            this.type = OctTreeNode.SplitType.Z;
            b = true;
        }
        if (g.getAABB().getMaxZ() > this.aabb.getMaxZ()) {
            this.left = otn = this.makeNode();
            aabb2 = new AABB3f(this.aabb);
            aabb2.setMaxZ(this.aabb.getMaxZ() + (this.aabb.getMaxZ() - this.aabb.getMinZ()));
            aabb2.setMinZ(this.aabb.getMaxZ());
            this.aabb.setMaxZ(aabb2.getMaxZ());
            this.right = new OctTreeNode(this.type, aabb2);
            this.splitPos = (this.aabb.getMaxZ() + this.aabb.getMinZ()) / 2.0f;
            this.type = OctTreeNode.SplitType.Z;
            b = true;
        }
        if (b) {
            this.add(g);
        } else {
            super.add(g);
        }
    }
}

