/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper.lcp;

import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;

public class BaraffLCP {
    private int n;
    private Matrix A;
    private Real f;
    private Real a;
    private IntList c;
    private IntList nc;
    private Real hi;
    private Real lo;
    private int j;
    private int old_j;
    private float s;
    public static final BaraffLCP INSTANCE = new BaraffLCP();
    public static float TOLERANCE = 1.0E-4f;

    public void computeForces(int n, RealPointer A, RealPointer f, RealPointer b, RealPointer a, int nub, RealPointer lo, RealPointer hi, IntPointer findex) {
        this.n = n;
        this.c = new IntList();
        this.nc = new IntList();
        this.A = Matrix.pool.aquire(n, n);
        this.a = Real.pool.aquire(n);
        this.f = Real.pool.aquire(n);
        this.hi = Real.pool.aquire(n);
        this.lo = Real.pool.aquire(n);
        int i = 0;
        while (i < n) {
            this.a.m[i] = -b.getValue(i);
            if (i < nub) {
                this.hi.m[i] = Float.POSITIVE_INFINITY;
                this.lo.m[i] = Float.NEGATIVE_INFINITY;
            } else {
                this.hi.m[i] = hi.getValue(i);
                this.lo.m[i] = lo.getValue(i);
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = i;
            while (j < n) {
                this.A.set(i, j, A.getValue(i * n + j));
                this.A.set(j, i, A.getValue(i * n + j));
                ++j;
            }
            ++i;
        }
        int d = 0;
        while (d < n) {
            this.driveInToRange(d);
            ++d;
        }
        i = 0;
        while (i < n) {
            f.setValue(i, this.f.m[i]);
            a.setValue(i, this.a.m[i]);
            ++i;
        }
        Matrix.pool.release(this.A);
        Real.pool.release(this.a);
        Real.pool.release(this.f);
        Real.pool.release(this.hi);
        Real.pool.release(this.lo);
    }

    private void driveInToRange(int d) {
        if (BaraffLCP.isZero(this.a.m[d]) && BaraffLCP.isGreaterThan(this.f.m[d], this.lo.m[d]) && BaraffLCP.isLessThan(this.f.m[d], this.hi.m[d])) {
            this.c.add(d);
            this.a.m[d] = 0.0f;
            this.f.m[d] = Math.max(this.f.m[d], this.lo.m[d]);
            this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
            return;
        }
        if (BaraffLCP.isGreaterThanZero(this.a.m[d]) && BaraffLCP.isZero(this.f.m[d])) {
            this.nc.add(d);
            this.f.m[d] = 0.0f;
            return;
        }
        this.j = -1;
        boolean solved = false;
        boolean retried = false;
        while (!solved) {
            int index;
            int i;
            Real df = this.fdirection(d);
            Real da = this.A.mul(df);
            this.maxstep(d, df, da);
            this.old_j = this.j;
            df.scale(this.s);
            da.scale(this.s);
            this.f.add(df);
            this.a.add(da);
            if (this.c.contains(this.j)) {
                this.c.remove(this.j);
                this.nc.add(this.j);
            } else if (this.nc.contains(this.j)) {
                this.nc.remove(this.j);
                this.c.add(this.j);
            } else if (this.j == d) {
                if (BaraffLCP.isZero(this.a.m[d]) && BaraffLCP.isGreaterThan(this.f.m[d], this.lo.m[d]) && BaraffLCP.isLessThan(this.f.m[d], this.hi.m[d])) {
                    this.c.add(d);
                    solved = true;
                } else if (BaraffLCP.isGreaterThan(this.a.m[d], 0.0f) && BaraffLCP.isZero(this.f.m[d])) {
                    this.nc.add(d);
                    solved = true;
                } else if (retried) {
                    i = 0;
                    while (i < d) {
                        JOODELog.debug("a.m[", i, "] = ", Float.valueOf(this.a.m[i]));
                        JOODELog.debug("f.m[", i, "] = ", Float.valueOf(this.f.m[i]));
                        ++i;
                    }
                    JOODELog.debug("a.m[d] = ", Float.valueOf(this.a.m[d]));
                    JOODELog.debug("f.m[d] = ", Float.valueOf(this.f.m[d]));
                    JOODELog.debug("hi.m[d] = ", Float.valueOf(this.hi.m[d]));
                    JOODELog.debug("lo.m[d] = ", Float.valueOf(this.lo.m[d]));
                    JOODELog.debug("new constraint cannot be solved, ignoring");
                    solved = true;
                } else {
                    retried = true;
                }
            }
            i = 0;
            while (i < this.c.size) {
                index = this.c.get(i);
                this.a.m[index] = 0.0f;
                this.f.m[index] = Math.max(this.f.m[index], this.lo.m[index]);
                this.f.m[index] = Math.min(this.f.m[index], this.hi.m[index]);
                ++i;
            }
            i = 0;
            while (i < this.nc.size) {
                index = this.nc.get(i);
                this.a.m[index] = Math.max(this.a.m[index], 0.0f);
                this.f.m[index] = 0.0f;
                ++i;
            }
        }
    }

    private Real fdirection(int d) {
        Real df = Real.pool.aquire(this.n);
        df.m[d] = 1.0f;
        Matrix m = Matrix.pool.aquire(this.c.size(), this.c.size());
        Real v = Real.pool.aquire(this.c.size());
        int i = 0;
        while (i < this.c.size()) {
            int j = 0;
            while (j < this.c.size()) {
                m.set(i, j, this.A.get(this.c.get(i), this.c.get(j)));
                ++j;
            }
            v.m[i] = -this.A.get(d, this.c.get(i));
            ++i;
        }
        BaraffLCP.solve(m, v);
        i = 0;
        while (i < this.c.size()) {
            df.m[this.c.get((int)i)] = v.m[i];
            ++i;
        }
        Matrix.pool.release(m);
        Real.pool.release(v);
        return df;
    }

    private boolean maxstep(int d, Real df, Real da) {
        float s1;
        int i;
        this.s = Float.POSITIVE_INFINITY;
        boolean ret = true;
        this.j = -1;
        if (this.f.m[d] < this.lo.m[d]) {
            this.s = this.lo.m[d] - this.f.m[d];
            if (this.a.m[d] + da.m[d] * this.s >= 0.0f) {
                this.j = d;
            }
        } else if (this.f.m[d] > this.hi.m[d]) {
            df.scale(-1.0f);
            da.scale(-1.0f);
            this.s = this.f.m[d] - this.hi.m[d];
            if (this.a.m[d] + da.m[d] * this.s <= 0.0f) {
                this.j = d;
            }
        } else if (this.a.m[d] < 0.0f) {
            if (da.m[d] < 0.0f && this.a.m[d] / da.m[d] < this.f.m[d] - this.lo.m[d]) {
                df.scale(-1.0f);
                da.scale(-1.0f);
                this.s = -this.a.m[d] / da.m[d];
                this.j = d;
            } else {
                if (da.m[d] > 0.0f) {
                    this.s = -this.a.m[d] / da.m[d];
                    this.j = d;
                }
                if (this.s > this.hi.m[d] - this.f.m[d]) {
                    this.s = this.hi.m[d] - this.f.m[d];
                    this.j = d;
                }
            }
        } else if (da.m[d] < 0.0f && -this.a.m[d] / da.m[d] < this.hi.m[d] - this.f.m[d]) {
            this.s = -this.a.m[d] / da.m[d];
            this.j = d;
        } else {
            df.scale(-1.0f);
            da.scale(-1.0f);
            if (da.m[d] < 0.0f) {
                this.s = -this.a.m[d] / da.m[d];
                this.j = d;
            }
            if (this.s > this.f.m[d] - this.lo.m[d]) {
                this.s = this.f.m[d] - this.lo.m[d];
                this.j = d;
            }
        }
        int k = 0;
        while (k < this.c.size()) {
            i = this.c.get(k);
            if (df.m[i] < 0.0f) {
                s1 = -(this.f.m[i] - this.lo.m[i]) / df.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (df.m[i] > 0.0f && (s1 = (this.hi.m[i] - this.f.m[i]) / df.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        k = 0;
        while (k < this.nc.size()) {
            i = this.nc.get(k);
            if (this.a.m[i] > 0.0f && da.m[i] < 0.0f) {
                s1 = -this.a.m[i] / da.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (this.a.m[i] < 0.0f && da.m[i] > 0.0f && (s1 = -this.a.m[i] / da.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        return ret;
    }

    private static boolean isZero(float f) {
        return f < TOLERANCE && f > -TOLERANCE;
    }

    private static boolean isGreaterThanZero(float f) {
        return f >= TOLERANCE;
    }

    private static boolean isGreaterThan(float val, float lower) {
        return val > lower - TOLERANCE;
    }

    private static boolean isLessThan(float val, float higher) {
        return val < higher - TOLERANCE;
    }

    private static void solve(Matrix m, Real v) {
        int i = 0;
        while (i < m.getColumns()) {
            int k;
            int j;
            if (BaraffLCP.isZero(m.get(i, i))) {
                j = i + 1;
                while (j < m.getRows()) {
                    if (!BaraffLCP.isZero(m.get(i, j))) {
                        float tmp;
                        k = i;
                        while (k < m.getColumns()) {
                            tmp = m.get(k, i);
                            m.set(k, i, m.get(k, j));
                            m.set(k, j, tmp);
                            ++k;
                        }
                        tmp = v.m[i];
                        v.m[i] = v.m[j];
                        v.m[j] = tmp;
                        j = m.getRows();
                    }
                    ++j;
                }
            }
            if (!BaraffLCP.isZero(m.get(i, i))) {
                j = i + 1;
                while (j < m.getRows()) {
                    float s = m.get(i, j) / m.get(i, i);
                    k = i;
                    while (k < m.getColumns()) {
                        m.set(k, j, m.get(k, j) - s * m.get(k, i));
                        ++k;
                    }
                    int n = j++;
                    v.m[n] = v.m[n] - s * v.m[i];
                }
                float s = 1.0f / m.get(i, i);
                int k2 = i;
                while (k2 < m.getColumns()) {
                    m.set(k2, i, m.get(k2, i) * s);
                    ++k2;
                }
                int n = i;
                v.m[n] = v.m[n] * s;
            }
            ++i;
        }
        i = m.getColumns() - 1;
        while (i > 0) {
            if (BaraffLCP.isZero(m.get(i, i)) && !BaraffLCP.isZero(v.m[i])) {
                JOODELog.debug("No solution for equation system exists!");
            }
            int j = 0;
            while (j < i) {
                int n = j;
                v.m[n] = v.m[n] - v.m[i] * m.get(i, j);
                ++j;
            }
            --i;
        }
    }

    public static void main(String[] args) {
        int r = 4;
        int c = 4;
        Matrix m = new Matrix(c, r);
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                if (Math.random() < 0.7) {
                    m.set(j, i, 0.0f);
                } else {
                    m.set(j, i, (float)Math.random() * 10.0f);
                }
                ++j;
            }
            ++i;
        }
        Real v = Real.pool.aquire(c);
        int i2 = 0;
        while (i2 < c) {
            v.m[i2] = (float)Math.random() * 10.0f;
            ++i2;
        }
        JOODELog.debug(m, "\n", v, "\n");
        Real t = m.mul(v);
        JOODELog.debug(t);
        BaraffLCP.solve(m, t);
        JOODELog.debug(t);
        Real.pool.release(v);
    }

    class IntList {
        private int[] list;
        private int size;

        public IntList() {
            this.list = new int[BaraffLCP.this.n];
            this.size = 0;
        }

        public void add(int i) {
            this.list[this.size] = i;
            ++this.size;
        }

        public boolean contains(int i) {
            int j = 0;
            while (j < this.size) {
                if (this.list[j] == i) {
                    return true;
                }
                ++j;
            }
            return false;
        }

        public boolean remove(int i) {
            boolean found = false;
            int j = 0;
            while (j < this.size) {
                if (found) {
                    this.list[j - 1] = this.list[j];
                } else if (this.list[j] == i) {
                    found = true;
                }
                ++j;
            }
            if (found) {
                --this.size;
            }
            return found;
        }

        public int size() {
            return this.size;
        }

        public int get(int i) {
            if (i >= this.size) {
                throw new IllegalArgumentException("element out of reach!");
            }
            return this.list[i];
        }
    }
}

