/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper.lcp;

import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;

public class BaraffLCPFixedStatic {
    private int n;
    private Matrix A;
    private Real f;
    private Real a;
    private IntList cNormal;
    private IntList ncNormal;
    private IntList cStatic;
    private IntList ncStatic;
    private IntList ignoreList;
    private Real hi;
    private Real lo;
    private int j;
    private float s;
    public static final BaraffLCPFixedStatic INSTANCE = new BaraffLCPFixedStatic();
    public static float TOLERANCE = 1.0E-4f;

    public void computeForces(int n, RealPointer A, RealPointer f, RealPointer b, RealPointer a, int nub, RealPointer lo, RealPointer hi, IntPointer findex) {
        int i;
        this.n = n;
        this.cNormal = new IntList();
        this.ncNormal = new IntList();
        this.cStatic = new IntList();
        this.ncStatic = new IntList();
        this.ignoreList = new IntList();
        this.A = Matrix.pool.aquire(n, n);
        this.a = Real.pool.aquire(n);
        this.f = Real.pool.aquire(n);
        this.hi = Real.pool.aquire(n);
        this.lo = Real.pool.aquire(n);
        int i2 = 0;
        while (i2 < n) {
            this.a.m[i2] = -b.getValue(i2);
            if (i2 < nub) {
                this.hi.m[i2] = Float.POSITIVE_INFINITY;
                this.lo.m[i2] = Float.NEGATIVE_INFINITY;
            } else {
                this.hi.m[i2] = hi.getValue(i2);
                this.lo.m[i2] = lo.getValue(i2);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            int j = i2;
            while (j < n) {
                this.A.set(i2, j, A.getValue(i2 * n + j));
                this.A.set(j, i2, A.getValue(i2 * n + j));
                ++j;
            }
            ++i2;
        }
        int d = 0;
        while (d < n) {
            if (!this.driveInToRange(d)) {
                this.ignoreList.add(d);
            }
            ++d;
        }
        int lastIgnoreSize = this.ignoreList.size;
        while (this.ignoreList.size > 0) {
            i = this.ignoreList.size() - 1;
            while (i >= 0) {
                int d2 = this.ignoreList.get(i);
                this.ignoreList.remove(d2);
                if (!this.driveInToRange(d2)) {
                    this.ignoreList.add(d2);
                }
                --i;
            }
            if (this.ignoreList.size() == lastIgnoreSize) {
                JOODELog.error("could not satisfy all constraints");
                break;
            }
            lastIgnoreSize = this.ignoreList.size;
        }
        i = 0;
        while (i < n) {
            f.setValue(i, this.f.m[i]);
            a.setValue(i, this.a.m[i]);
            ++i;
        }
        Matrix.pool.release(this.A);
        Real.pool.release(this.a);
        Real.pool.release(this.f);
        Real.pool.release(this.hi);
        Real.pool.release(this.lo);
    }

    private boolean driveInToRange(int d) {
        if (this.isNormal(d)) {
            if (BaraffLCPFixedStatic.isZero(this.a.m[d]) && BaraffLCPFixedStatic.isLessThan(this.f.m[d], this.hi.m[d])) {
                this.cNormal.add(d);
                this.a.m[d] = 0.0f;
                this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                return true;
            }
            if (BaraffLCPFixedStatic.isGreaterThanZero(this.a.m[d]) && BaraffLCPFixedStatic.isZero(this.f.m[d])) {
                this.ncNormal.add(d);
                this.f.m[d] = 0.0f;
                return true;
            }
        } else {
            if (BaraffLCPFixedStatic.isZero(this.a.m[d]) && BaraffLCPFixedStatic.isGreaterThan(this.f.m[d], this.lo.m[d]) && BaraffLCPFixedStatic.isLessThan(this.f.m[d], this.hi.m[d])) {
                this.cNormal.add(d);
                this.a.m[d] = 0.0f;
                this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                this.f.m[d] = Math.max(this.f.m[d], this.lo.m[d]);
                return true;
            }
            if (BaraffLCPFixedStatic.isLessThan(this.a.m[d], 0.0f) && BaraffLCPFixedStatic.isEqual(this.f.m[d], this.hi.m[d])) {
                this.ncNormal.add(d);
                this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                return true;
            }
            if (BaraffLCPFixedStatic.isGreaterThan(this.a.m[d], 0.0f) && BaraffLCPFixedStatic.isEqual(this.f.m[d], this.lo.m[d])) {
                this.ncNormal.add(d);
                this.f.m[d] = Math.max(this.f.m[d], this.lo.m[d]);
                return true;
            }
        }
        this.j = -1;
        int old_j = -1;
        boolean solved = false;
        boolean retried = false;
        while (!solved) {
            int index;
            Real df = this.fdirection(d);
            Real da = this.A.mul(df);
            int i = 0;
            while (i < this.cNormal.size()) {
                assert (BaraffLCPFixedStatic.isZero(da.m[this.cNormal.get(i)])) : da.m[this.cNormal.get(i)];
                da.m[this.cNormal.get((int)i)] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.cStatic.size()) {
                if (i != d) {
                    da.m[this.cStatic.get((int)i)] = 0.0f;
                }
                ++i;
            }
            this.maxstep(d, df, da);
            df.scale(this.s);
            da.scale(this.s);
            this.f.add(df);
            this.a.add(da);
            if (this.cNormal.contains(this.j)) {
                this.cNormal.remove(this.j);
                if (this.j == old_j) {
                    return false;
                }
                this.ncNormal.add(this.j);
                old_j = this.j;
            } else if (this.ncNormal.contains(this.j)) {
                this.ncNormal.remove(this.j);
                if (this.j == old_j) {
                    return false;
                }
                this.cNormal.add(this.j);
                old_j = this.j;
            } else if (this.cStatic.contains(this.j)) {
                this.cStatic.remove(this.j);
                if (this.j == old_j) {
                    return false;
                }
                this.ncStatic.add(this.j);
                old_j = this.j;
            } else if (this.ncStatic.contains(this.j)) {
                this.ncStatic.remove(this.j);
                if (this.j == old_j) {
                    return false;
                }
                this.cStatic.add(this.j);
                old_j = this.j;
            } else if (this.j == d) {
                boolean addedToSet = true;
                if (this.isNormal(d)) {
                    if (BaraffLCPFixedStatic.isZero(this.a.m[d]) && BaraffLCPFixedStatic.isLessThan(this.f.m[d], this.hi.m[d])) {
                        this.cNormal.add(d);
                        this.a.m[d] = 0.0f;
                        this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                    } else if (BaraffLCPFixedStatic.isGreaterThanZero(this.a.m[d]) && BaraffLCPFixedStatic.isZero(this.f.m[d])) {
                        this.ncNormal.add(d);
                        this.f.m[d] = 0.0f;
                    } else {
                        addedToSet = false;
                    }
                } else if (BaraffLCPFixedStatic.isZero(this.a.m[d]) && BaraffLCPFixedStatic.isGreaterThan(this.f.m[d], this.lo.m[d]) && BaraffLCPFixedStatic.isLessThan(this.f.m[d], this.hi.m[d])) {
                    this.cStatic.add(d);
                    this.a.m[d] = 0.0f;
                    this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                    this.f.m[d] = Math.max(this.f.m[d], this.lo.m[d]);
                } else if (BaraffLCPFixedStatic.isLessThan(this.a.m[d], 0.0f) && BaraffLCPFixedStatic.isEqual(this.f.m[d], this.hi.m[d])) {
                    this.ncStatic.add(d);
                    this.f.m[d] = Math.min(this.f.m[d], this.hi.m[d]);
                } else if (BaraffLCPFixedStatic.isGreaterThan(this.a.m[d], 0.0f) && BaraffLCPFixedStatic.isEqual(this.f.m[d], this.lo.m[d])) {
                    this.ncStatic.add(d);
                    this.f.m[d] = Math.max(this.f.m[d], this.lo.m[d]);
                } else {
                    addedToSet = false;
                }
                if (!addedToSet) {
                    if (retried) {
                        return false;
                    }
                    retried = true;
                } else {
                    solved = true;
                    old_j = this.j;
                }
            } else {
                JOODELog.debug("d = ", d);
                JOODELog.debug("j = ", this.j);
                throw new IllegalStateException();
            }
            i = 0;
            while (i < this.cNormal.size) {
                index = this.cNormal.get(i);
                this.a.m[index] = 0.0f;
                this.f.m[index] = Math.max(this.f.m[index], 0.0f);
                this.f.m[index] = Math.min(this.f.m[index], this.hi.m[index]);
                ++i;
            }
            i = 0;
            while (i < this.ncNormal.size) {
                index = this.ncNormal.get(i);
                this.a.m[index] = Math.max(this.a.m[index], 0.0f);
                this.f.m[index] = 0.0f;
                ++i;
            }
        }
        return true;
    }

    private Real fdirection(int d) {
        Real df = Real.pool.aquire(this.n);
        Matrix m = Matrix.pool.aquire(this.cNormal.size() + this.cStatic.size(), this.cNormal.size() + this.cStatic.size());
        Real v = Real.pool.aquire(this.cNormal.size() + this.cStatic.size());
        int i = 0;
        while (i < this.cNormal.size() + this.cStatic.size()) {
            int j = 0;
            while (j < this.cNormal.size() + this.cStatic.size()) {
                m.set(i, j, this.A.get(i < this.cNormal.size() ? this.cNormal.get(i) : this.cStatic.get(i - this.cNormal.size()), j < this.cNormal.size() ? this.cNormal.get(j) : this.cStatic.get(j - this.cNormal.size())));
                ++j;
            }
            v.m[i] = -this.A.get(d, i < this.cNormal.size() ? this.cNormal.get(i) : this.cStatic.get(i - this.cNormal.size()));
            ++i;
        }
        BaraffLCPFixedStatic.solve(m, v);
        i = 0;
        while (i < this.cNormal.size()) {
            df.m[this.cNormal.get((int)i)] = v.m[i];
            ++i;
        }
        i = 0;
        while (i < this.cStatic.size()) {
            df.m[this.cStatic.get((int)i)] = v.m[i + this.cNormal.size()];
            ++i;
        }
        Matrix.pool.release(m);
        Real.pool.release(v);
        int sign = this.isNormal(d) ? (BaraffLCPFixedStatic.isLessThan(this.a.m[d], 0.0f) ? 1 : -1) : (BaraffLCPFixedStatic.isLessThan(this.f.m[d], this.lo.m[d]) ? 1 : (BaraffLCPFixedStatic.isGreaterThan(this.f.m[d], this.hi.m[d]) ? -1 : (this.a.m[d] < 0.0f ? 1 : -1)));
        df.m[d] = 1.0f;
        df.scale(sign);
        return df;
    }

    private void maxstep(int d, Real df, Real da) {
        float s1;
        int i;
        float as;
        float s12;
        this.s = Float.POSITIVE_INFINITY;
        this.j = d;
        if (this.f.m[d] < this.lo.m[d] && df.m[d] > 0.0f && (s12 = this.lo.m[d] - this.f.m[d]) < this.s) {
            this.s = s12;
        }
        if (this.f.m[d] > this.hi.m[d] && df.m[d] < 0.0f && (s12 = this.f.m[d] - this.hi.m[d]) < this.s) {
            this.s = s12;
        }
        if (this.f.m[d] > this.lo.m[d] && df.m[d] < 0.0f && (s12 = this.f.m[d] - this.lo.m[d]) < this.s) {
            this.s = s12;
        }
        if (this.f.m[d] < this.hi.m[d] && df.m[d] > 0.0f && (s12 = this.hi.m[d] - this.f.m[d]) < this.s) {
            this.s = s12;
        }
        if (this.a.m[d] < 0.0f && da.m[d] > 0.0f) {
            as = -this.a.m[d] / da.m[d];
            if (as < this.s) {
                this.s = as;
            }
        } else if (this.a.m[d] > 0.0f && da.m[d] < 0.0f && (as = -this.a.m[d] / da.m[d]) < this.s) {
            this.s = as;
        }
        int k = 0;
        while (k < this.cNormal.size()) {
            i = this.cNormal.get(k);
            if (df.m[i] < 0.0f) {
                s1 = -this.f.m[i] / df.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (df.m[i] > 0.0f && (s1 = (this.hi.m[i] - this.f.m[i]) / df.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        k = 0;
        while (k < this.ncNormal.size()) {
            i = this.ncNormal.get(k);
            if (this.a.m[i] > 0.0f && da.m[i] < 0.0f) {
                s1 = -this.a.m[i] / da.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (this.a.m[i] < 0.0f && da.m[i] > 0.0f && (s1 = -this.a.m[i] / da.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        k = 0;
        while (k < this.cStatic.size()) {
            i = this.cStatic.get(k);
            if (df.m[i] < 0.0f) {
                s1 = -(this.f.m[i] - this.lo.m[i]) / df.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (df.m[i] > 0.0f && (s1 = (this.hi.m[i] - this.f.m[i]) / df.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        k = 0;
        while (k < this.ncStatic.size()) {
            i = this.ncStatic.get(k);
            if (this.a.m[i] > 0.0f && da.m[i] < 0.0f) {
                s1 = -this.a.m[i] / da.m[i];
                if (s1 < this.s) {
                    this.s = s1;
                    this.j = i;
                }
            } else if (this.a.m[i] < 0.0f && da.m[i] > 0.0f && (s1 = -this.a.m[i] / da.m[i]) < this.s) {
                this.s = s1;
                this.j = i;
            }
            ++k;
        }
        if (this.s == Float.POSITIVE_INFINITY) {
            JOODELog.error("+veI");
            this.s = 0.0f;
        }
    }

    private static boolean isZero(float f) {
        return f < TOLERANCE && f > -TOLERANCE;
    }

    private static boolean isEqual(float val, float other) {
        return val - TOLERANCE < other && val + TOLERANCE > other;
    }

    private boolean isNormal(int constraintIndex) {
        return BaraffLCPFixedStatic.isZero(this.lo.m[constraintIndex]);
    }

    private static boolean isGreaterThanZero(float f) {
        return f >= TOLERANCE;
    }

    private static boolean isGreaterThan(float val, float lower) {
        return val > lower - TOLERANCE;
    }

    private static boolean isLessThan(float val, float higher) {
        return val < higher - TOLERANCE;
    }

    private static void solve(Matrix m, Real v) {
        int i = 0;
        while (i < m.getColumns()) {
            int k;
            int j;
            if (BaraffLCPFixedStatic.isZero(m.get(i, i))) {
                j = i + 1;
                while (j < m.getRows()) {
                    if (!BaraffLCPFixedStatic.isZero(m.get(i, j))) {
                        float tmp;
                        k = i;
                        while (k < m.getColumns()) {
                            tmp = m.get(k, i);
                            m.set(k, i, m.get(k, j));
                            m.set(k, j, tmp);
                            ++k;
                        }
                        tmp = v.m[i];
                        v.m[i] = v.m[j];
                        v.m[j] = tmp;
                        j = m.getRows();
                    }
                    ++j;
                }
            }
            if (!BaraffLCPFixedStatic.isZero(m.get(i, i))) {
                j = i + 1;
                while (j < m.getRows()) {
                    float s = m.get(i, j) / m.get(i, i);
                    k = i;
                    while (k < m.getColumns()) {
                        m.set(k, j, m.get(k, j) - s * m.get(k, i));
                        ++k;
                    }
                    int n = j++;
                    v.m[n] = v.m[n] - s * v.m[i];
                }
                float s = 1.0f / m.get(i, i);
                int k2 = i;
                while (k2 < m.getColumns()) {
                    m.set(k2, i, m.get(k2, i) * s);
                    ++k2;
                }
                int n = i;
                v.m[n] = v.m[n] * s;
            }
            ++i;
        }
        i = m.getColumns() - 1;
        while (i > 0) {
            if (BaraffLCPFixedStatic.isZero(m.get(i, i)) && !BaraffLCPFixedStatic.isZero(v.m[i])) {
                JOODELog.debug("No solution for equation system exists!");
            }
            int j = 0;
            while (j < i) {
                int n = j;
                v.m[n] = v.m[n] - v.m[i] * m.get(i, j);
                ++j;
            }
            --i;
        }
    }

    public static void main(String[] args) {
        int r = 4;
        int c = 4;
        Matrix m = new Matrix(c, r);
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                if (Math.random() < 0.7) {
                    m.set(j, i, 0.0f);
                } else {
                    m.set(j, i, (float)Math.random() * 10.0f);
                }
                ++j;
            }
            ++i;
        }
        Real v = Real.pool.aquire(c);
        int i2 = 0;
        while (i2 < c) {
            v.m[i2] = (float)Math.random() * 10.0f;
            ++i2;
        }
        JOODELog.debug(m, "\n", v, "\n");
        Real t = m.mul(v);
        JOODELog.debug(t);
        BaraffLCPFixedStatic.solve(m, t);
        JOODELog.debug(t);
        Real.pool.release(v);
    }

    class IntList {
        private int[] list;
        private int size;

        public IntList() {
            this.list = new int[BaraffLCPFixedStatic.this.n];
            this.size = 0;
        }

        public void add(int i) {
            this.list[this.size++] = i;
        }

        public boolean contains(int i) {
            int j = 0;
            while (j < this.size) {
                if (this.list[j] == i) {
                    return true;
                }
                ++j;
            }
            return false;
        }

        public boolean remove(int i) {
            boolean found = false;
            int j = 0;
            while (j < this.size) {
                if (found) {
                    this.list[j - 1] = this.list[j];
                } else if (this.list[j] == i) {
                    found = true;
                }
                ++j;
            }
            if (found) {
                --this.size;
            }
            return found;
        }

        public int size() {
            return this.size;
        }

        public int get(int i) {
            if (i >= this.size) {
                throw new IllegalArgumentException("element out of reach!");
            }
            return this.list[i];
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < this.size) {
                ret.append(this.get(i)).append(", ");
                ++i;
            }
            return ret.toString();
        }
    }
}

