/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.java.dev.joode.util.AABB3f;
import net.java.dev.joode.util.RadixSortToken;
import net.java.dev.joode.util.Vector3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AABBSet {
    private static final int GIM_MIN_SORTED_BIPARTITE_PRUNING_BOXES = 600;
    private final AABB3f[] boxes;
    private AABB3f globalBounds = null;
    private int[] maxCoords;
    private RadixSortToken[] sortedMinCoords;

    public AABBSet(int length) {
        this.boxes = new AABB3f[length];
        int i = 0;
        while (i < length) {
            this.boxes[i] = new AABB3f();
            ++i;
        }
        if (length >= 600) {
            this.maxCoords = new int[length];
            this.sortedMinCoords = new RadixSortToken[length];
            i = 0;
            while (i < length) {
                this.sortedMinCoords[i] = new RadixSortToken();
                ++i;
            }
        }
    }

    public final void compute(int i, Vector3 p0, Vector3 p1, Vector3 p2) {
        this.boxes[i].compute(p0, p1, p2);
        this.globalBounds = null;
    }

    public final AABB3f getGlobalBounds() {
        if (this.globalBounds == null) {
            this.updateGlobalBounds();
        }
        return this.globalBounds;
    }

    private final void updateGlobalBounds() {
        this.globalBounds = new AABB3f();
        if (this.boxes.length > 0) {
            this.globalBounds.set(this.boxes[0]);
            int i = 1;
            while (i < this.boxes.length) {
                this.globalBounds.merge(this.boxes[i]);
                ++i;
            }
        }
    }

    public final Collection<ElementPair> findIntersections(AABBSet set2) {
        return this.sortedMinCoords == null || set2.sortedMinCoords == null ? this.findIntersectionsByBruteForce(set2) : this.findIntersectionsBySort(set2);
    }

    public final Collection<Integer> findIntersections(AABB3f aabb) {
        return this.sortedMinCoords == null ? this.findIntersectionsByBruteForce(aabb) : this.findIntersectionsBySort(aabb);
    }

    private final Collection<Integer> findIntersectionsByBruteForce(AABB3f aabb) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        int i = 0;
        while (i < this.boxes.length) {
            if (aabb.intersects(this.boxes[i])) {
                out.add(i);
            }
            ++i;
        }
        return out;
    }

    private final Collection<Integer> findIntersectionsBySort(AABB3f aabb) {
        return this.findIntersectionsByBruteForce(aabb);
    }

    private final Collection<ElementPair> findIntersectionsByBruteForce(AABBSet set2) {
        if (!this.globalBounds.intersects(set2.globalBounds)) {
            return Collections.EMPTY_LIST;
        }
        AABB3f globalIntersection = this.globalBounds.intersection(set2.globalBounds, new AABB3f());
        int classifiedCount = 0;
        int[] classified = new int[this.boxes.length];
        int i = 0;
        while (i < this.boxes.length) {
            if (globalIntersection.intersects(this.boxes[i])) {
                classified[classifiedCount++] = i;
            }
            ++i;
        }
        if (classifiedCount == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ElementPair> intersections = new ArrayList<ElementPair>();
        int i2 = 0;
        while (i2 < set2.boxes.length) {
            AABB3f box2 = set2.boxes[i2];
            if (globalIntersection.intersects(box2)) {
                int j = 0;
                while (j < classifiedCount) {
                    int k = classified[j];
                    if (box2.intersects(this.boxes[k])) {
                        intersections.add(new ElementPair(k, i2));
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return intersections;
    }

    private final Collection<ElementPair> findIntersectionsBySort(AABBSet set2) {
        return this.findIntersectionsByBruteForce(set2);
    }

    public static class ElementPair {
        private final int index1;
        private final int index2;

        public final int getIndex1() {
            return this.index1;
        }

        public final int getIndex2() {
            return this.index2;
        }

        public ElementPair(int index1, int index2) {
            this.index1 = index1;
            this.index2 = index2;
        }
    }
}

