/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.ArrayList;
import net.java.dev.joode.util.RK4;
import net.java.dev.joode.util.SubVector;
import net.java.dev.joode.util.Vector;

public class CompositeVectorRegular
implements Vector {
    int vectorSize = -1;
    ArrayList<Vector> vectors = new ArrayList();

    public void addVector(Vector v) {
        if (this.vectorSize == -1) {
            this.vectorSize = v.size();
        }
        assert (this.vectorSize == v.size()) : "vector is of a differnt size to vectors allready added";
        this.vectors.add(v);
    }

    public void set(int index, float val) {
        this.vectors.get(index / this.vectorSize).set(index % this.vectorSize, val);
    }

    public float get(int index) {
        return this.vectors.get(index / this.vectorSize).get(index % this.vectorSize);
    }

    public Vector getVector(int i) {
        return this.vectors.get(i);
    }

    public int size() {
        return this.vectors.size() * this.vectorSize;
    }

    public int getNumVectors() {
        return this.vectors.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < this.size()) {
            buf.append(this.get(i)).append(", ");
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public static class CompositeDifferential
    implements RK4.Differential {
        int size;
        ArrayList<RK4.Differential> differentialComponents = new ArrayList();
        SubVector stateSubview = new SubVector();
        SubVector passbackSubview = new SubVector();

        public void evaluate(Vector state, float t, float t_start, float t_end, Vector passback) {
            this.stateSubview.base = state;
            this.passbackSubview.base = passback;
            int start = 0;
            int i = 0;
            while (i < this.differentialComponents.size()) {
                RK4.Differential component = this.differentialComponents.get(i);
                int end = start + component.size();
                this.stateSubview.start = start;
                this.stateSubview.end = end;
                this.passbackSubview.start = start;
                this.passbackSubview.end = end;
                component.evaluate(this.stateSubview, t, t_start, t_end, this.passbackSubview);
                start = end;
                ++i;
            }
        }

        public int size() {
            return this.size;
        }

        public void addComponent(RK4.Differential differential) {
            this.size += differential.size();
            this.differentialComponents.add(differential);
        }

        public RK4.Differential getDifferential(int i) {
            return this.differentialComponents.get(i);
        }

        public int getNumDifferentials() {
            return this.differentialComponents.size();
        }
    }
}

