/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

public class FastMath {
    public static final float PI = (float)Math.PI;
    public static final float halfPI = 1.5707964f;
    public static final int MAX_EXPANSIONS = 100;
    static final int[] factorial = new int[100];
    static final float[] factorial_recip = new float[100];
    static final float[] recip = new float[100];
    static final double[] factorial_recip_double = new double[100];
    static final double[] recip__double = new double[100];
    private static float precision;

    static {
        FastMath.setPrecision(0.001f);
        FastMath.calcFactorial();
        int i = 0;
        while (i < recip.length) {
            FastMath.recip[i] = 1.0f / (float)i;
            ++i;
        }
        i = 0;
        while (i < recip.length) {
            FastMath.recip__double[i] = 1.0 / (double)i;
            ++i;
        }
    }

    public static void setPrecision(float precision) {
        FastMath.precision = precision;
    }

    public static float getPrecision() {
        return precision;
    }

    private static void calcFactorial() {
        int runningFactorial = 1;
        FastMath.factorial[0] = 1;
        FastMath.factorial_recip[0] = 1.0f;
        int i = 1;
        while (i < 100) {
            FastMath.factorial[i] = runningFactorial *= i;
            FastMath.factorial_recip[i] = 1.0f / (float)factorial[i];
            FastMath.factorial_recip_double[i] = 1.0 / (double)factorial[i];
            ++i;
        }
    }

    public static int factorial(int x) {
        return factorial[x];
    }

    public static float sin(float x) {
        while (x > (float)Math.PI) {
            x = (float)((double)x - Math.PI * 2);
        }
        while (x < (float)(-Math.PI)) {
            x = (float)((double)x + Math.PI * 2);
        }
        if (x > 1.5707964f) {
            return FastMath.cos(x - 1.5707964f);
        }
        if (x < -1.5707964f) {
            return -FastMath.cos(x + 1.5707964f);
        }
        float term = x;
        float termABS = Math.abs(term);
        float pow = x;
        int n = 1;
        int sign = 1;
        float val = term;
        while (termABS > precision) {
            float oldTermABS = termABS;
            term = (float)(sign = sign == 1 ? -1 : 1) * (pow *= x * x) * factorial_recip[n += 2];
            if (oldTermABS < (termABS = Math.abs(term))) break;
            val += term;
        }
        return val;
    }

    public static float cos(float x) {
        while (x > (float)Math.PI) {
            x = (float)((double)x - Math.PI * 2);
        }
        while (x < (float)(-Math.PI)) {
            x = (float)((double)x + Math.PI * 2);
        }
        if (x > 1.5707964f) {
            return -FastMath.sin(x - 1.5707964f);
        }
        if (x < -1.5707964f) {
            return FastMath.sin(x + 1.5707964f);
        }
        float pow = x * x;
        int n = 2;
        int sign = -1;
        float term = -pow * factorial_recip[2];
        float termABS = Math.abs(term);
        float val = 1.0f + term;
        while (termABS > precision) {
            float oldTermABS = termABS;
            term = (float)(sign = sign == 1 ? -1 : 1) * (pow *= x * x) * factorial_recip[n += 2];
            if (oldTermABS < (termABS = Math.abs(term))) break;
            val += term;
        }
        return val;
    }

    public static float acos(float x) {
        return 1.5707964f - FastMath.asin(x);
    }

    public static float asin(float x) {
        float oldPrecision = precision;
        precision *= 0.5f;
        float result = 2.0f * FastMath.atan((float)((double)x / (1.0 + Math.sqrt(1.0f - x * x))));
        precision = oldPrecision;
        return result;
    }

    public static float atan(float x) {
        float term;
        float pow = x;
        int n = 1;
        float val = term = x;
        if (x > 0.0f) {
            float termABS = term;
            while (termABS > precision) {
                float oldTermABS = termABS;
                if (oldTermABS < (termABS = (term = (n += 2) < 100 ? pow * recip[n] : (pow *= x * x) / (float)n))) break;
                val -= term;
                oldTermABS = termABS;
                if (!(oldTermABS < (termABS = (term = (n += 2) < 100 ? pow * recip[n] : (pow *= x * x) / (float)n)))) {
                    val += term;
                    continue;
                }
                break;
            }
        } else {
            float termABS = -term;
            while (termABS > precision) {
                float oldTermABS = termABS;
                if (oldTermABS < (termABS = -(term = (n += 2) < 100 ? pow * recip[n] : (pow *= x * x) / (float)n))) break;
                val -= term;
                oldTermABS = termABS;
                if (!(oldTermABS < (termABS = -(term = (n += 2) < 100 ? pow * recip[n] : (pow *= x * x) / (float)n)))) {
                    val += term;
                    continue;
                }
                break;
            }
        }
        return val;
    }

    public static double atan(double x) {
        double term;
        double pow = x;
        int n = 1;
        double val = term = x;
        if (x > 0.0) {
            double termABS = term;
            while (termABS > (double)precision) {
                double oldTermABS = termABS;
                if (oldTermABS < (termABS = (term = (n += 2) < 100 ? pow * recip__double[n] : (pow *= x * x) / (double)n))) break;
                val -= term;
                oldTermABS = termABS;
                if (!(oldTermABS < (termABS = (term = (n += 2) < 100 ? pow * recip__double[n] : (pow *= x * x) / (double)n)))) {
                    val += term;
                    continue;
                }
                break;
            }
        } else {
            double termABS = -term;
            while (termABS > (double)precision) {
                double oldTermABS = termABS;
                if (oldTermABS < (termABS = -(term = (n += 2) < 100 ? pow * recip__double[n] : (pow *= x * x) / (double)n))) break;
                val -= term;
                oldTermABS = termABS;
                if (!(oldTermABS < (termABS = -(term = (n += 2) < 100 ? pow * recip__double[n] : (pow *= x * x) / (double)n)))) {
                    val += term;
                    continue;
                }
                break;
            }
        }
        return val;
    }
}

