/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Pool2D;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class Matrix
extends Real {
    public static final Pool2D<Matrix> pool = new Pool2D<Matrix>(){

        @Override
        protected Matrix constuct(int i, int j) {
            return new Matrix(i, j);
        }

        @Override
        protected int getFirstIndex(Matrix matrix) {
            return matrix.getColumns();
        }

        @Override
        protected int getSecondIndex(Matrix matrix) {
            return matrix.getRows();
        }

        @Override
        protected void reset(Matrix matrix) {
            matrix.setIdentity();
        }
    };
    private final int columns;
    private final int rows;

    public Matrix(int columns, int rows) {
        super(columns * rows);
        this.columns = columns;
        this.rows = rows;
        this.setIdentity();
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public float get(int column, int row) {
        return this.m[row * this.columns + column];
    }

    public void set(int column, int row, float value) {
        this.m[row * this.columns + column] = value;
    }

    public Real getColumn(int i) {
        return this.getColumn(i, new Vector3());
    }

    public Real getColumn(int i, Real passback) {
        assert (passback.size() == this.rows);
        int j = 0;
        while (j < this.rows) {
            passback.m[j] = this.m[j * this.rows + i];
            ++j;
        }
        return passback;
    }

    public void setColumn(int i, Real v) {
        assert (v.size() >= this.rows);
        int j = 0;
        while (j < this.rows) {
            this.m[j * this.rows + i] = v.m[j];
            ++j;
        }
    }

    public void getRow(int i, Real v) {
        assert (v.size() >= this.columns);
        int j = 0;
        while (j < this.columns) {
            v.m[j] = this.m[i * this.rows + j];
            ++j;
        }
    }

    public void setRow(int i, Real v) {
        assert (v.size() >= this.columns);
        int j = 0;
        while (j < this.columns) {
            this.m[i * this.rows + j] = v.m[j];
            ++j;
        }
    }

    public void setIdentity() {
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                this.m[i * this.columns + j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
    }

    public Real mul(Real c) {
        assert (c.size() == this.columns) : "can't multiply Matrix with Vector - different sizes";
        Real out = new Real(this.rows);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                int n = i;
                out.m[n] = out.m[n] + this.m[i * this.columns + j] * c.m[j];
                ++j;
            }
            ++i;
        }
        return out;
    }

    public Real mulInc(Real c, Real a) {
        assert (c.size() == this.columns) : "can't multiply Matrix with Vector - different sizes";
        assert (a.size() == this.rows) : "can't multiply Matrix with Vector - different sizes";
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                int n = i;
                a.m[n] = a.m[n] + this.get(j, i) * c.m[j];
                ++j;
            }
            ++i;
        }
        return a;
    }

    public Real transposeMul(Real c) {
        return this.transposeMul(c, new Real(c.size()));
    }

    public Real transposeMul(Real c, Real a) {
        assert (c.size() == this.rows) : "can't multiply Matrix with Vector - different sizes";
        assert (a.size() == this.columns) : "can't multiply Matrix with Vector - different sizes";
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                int n = i;
                a.m[n] = a.m[n] + this.get(i, j) * c.m[j];
                ++j;
            }
            ++i;
        }
        return a;
    }

    public void transpose() {
        int i = 0;
        while (i < this.rows) {
            int j = i - 1;
            while (j >= 0) {
                float tmp = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, tmp);
                --j;
            }
            ++i;
        }
    }

    public Matrix mul(Matrix C) {
        Matrix result = new Matrix(this.columns, C.rows);
        int p = this.columns;
        int r = result.rows;
        int q = this.rows;
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < r) {
                float sum = 0.0f;
                int k = 0;
                while (k < q) {
                    sum += this.get(i, k) * C.get(k, j);
                    ++k;
                }
                result.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void mul(Matrix C, Matrix A) {
        int p = this.columns;
        int r = A.rows;
        int q = this.rows;
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < r) {
                float sum = 0.0f;
                int k = 0;
                while (k < q) {
                    sum += this.get(i, k) * C.get(k, j);
                    ++k;
                }
                A.set(i, j, sum);
                ++j;
            }
            ++i;
        }
    }

    public Matrix mulTranspose(Matrix C) {
        Matrix result = new Matrix(this.columns, C.columns);
        int p = this.columns;
        int r = result.rows;
        int q = this.rows;
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < r) {
                float sum = 0.0f;
                int k = 0;
                while (k < q) {
                    sum += this.get(i, k) * C.get(j, k);
                    ++k;
                }
                result.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void mulTranspose(Matrix C, Matrix A) {
        int p = this.columns;
        int r = A.rows;
        int q = this.rows;
        int i = 0;
        while (i < p) {
            int j = 0;
            while (j < r) {
                float sum = 0.0f;
                int k = 0;
                while (k < q) {
                    sum += this.get(i, k) * C.get(j, k);
                    ++k;
                }
                A.set(i, j, sum);
                ++j;
            }
            ++i;
        }
    }

    public void transposeMul(Matrix C, Matrix A) {
        int i = 0;
        while (i < this.columns) {
            int j = 0;
            while (j < A.rows) {
                float sum = 0.0f;
                int k = 0;
                while (k < this.rows) {
                    sum += this.get(k, j) * C.get(k, i);
                    ++k;
                }
                A.set(i, j, sum);
                ++j;
            }
            ++i;
        }
    }

    public static boolean epsilonEquals(Matrix a, Matrix b, float e) {
        int i = 0;
        while (i < a.m.length) {
            if (!Matrix.epsilonEquals(a.m[i], b.m[i], e)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("[\n");
        String element = null;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                if (j > 0) {
                    int z = 0;
                    while (z < 14 - element.length()) {
                        out.append(" ");
                        ++z;
                    }
                }
                element = Float.toString(this.get(j, i));
                out.append(element);
                ++j;
            }
            out.append("\n");
            ++i;
        }
        out.append("]");
        return out.toString();
    }

    public static boolean solve(Matrix A, Real b, Real passback) {
        int N = b.size();
        Real tmp = Real.pool.aquire(N);
        Real maxRow = Real.pool.aquire(N);
        int p = 0;
        while (p < N) {
            int max = p;
            int i = p + 1;
            while (i < N) {
                if (Math.abs(A.get(p, i)) > Math.abs(A.get(p, max))) {
                    max = i;
                }
                ++i;
            }
            A.getRow(max, maxRow);
            A.getRow(p, tmp);
            A.setRow(p, maxRow);
            A.setRow(max, tmp);
            float t = b.m[p];
            b.m[p] = b.m[max];
            b.m[max] = t;
            if ((double)A.get(p, p) == 0.0) {
                Real.pool.release(tmp);
                Real.pool.release(maxRow);
                return false;
            }
            int i2 = p + 1;
            while (i2 < N) {
                float alpha = A.get(p, i2) / A.get(p, p);
                int n = i2;
                b.m[n] = b.m[n] - alpha * b.m[p];
                int j = p;
                while (j < N) {
                    A.set(j, i2, A.get(j, i2) - alpha * A.get(j, p));
                    ++j;
                }
                ++i2;
            }
            ++p;
        }
        int i = N - 1;
        while (i >= 0) {
            float sum = 0.0f;
            int j = i + 1;
            while (j < N) {
                sum += A.get(j, i) * passback.m[j];
                ++j;
            }
            passback.m[i] = (b.m[i] - sum) / A.get(i, i);
            --i;
        }
        Real.pool.release(tmp);
        Real.pool.release(maxRow);
        return true;
    }
}

