/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.KahanSum;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector;

public class RK4 {
    public static float safteyFactor = 0.9f;
    public static float maxIncreaseFactor = 5.0f;
    public static float maxDecreaseFactor = 0.2f;
    public static float minSubStepsize = 1.0E-5f;

    public static void intergrate(Vector initialStates, Differential evaluator, float t_start, float t_end, Vector passback) {
        float h = t_end - t_start;
        Real initial = Real.pool.aquire(initialStates.size());
        Real in = Real.pool.aquire(initialStates.size());
        int i = 0;
        while (i < initialStates.size()) {
            initial.set(i, initialStates.get(i));
            ++i;
        }
        Real k1 = Real.pool.aquire(initialStates.size());
        Real k2 = Real.pool.aquire(initialStates.size());
        Real k3 = Real.pool.aquire(initialStates.size());
        Real k4 = Real.pool.aquire(initialStates.size());
        in.set(initial);
        evaluator.evaluate(in, t_start, t_start, t_end, k1);
        k1.scale(h);
        in.set(k1);
        in.scale(0.5f);
        in.add(initial);
        evaluator.evaluate(in, t_start + h / 2.0f, t_start, t_end, k2);
        k2.scale(h);
        in.set(k2);
        in.scale(0.5f);
        in.add(initial);
        evaluator.evaluate(in, t_start + h / 2.0f, t_start, t_end, k3);
        k3.scale(h);
        in.set(k3);
        in.add(initial);
        evaluator.evaluate(in, t_end, t_start, t_end, k4);
        k4.scale(h);
        k1.scale(0.16666667f);
        k2.scale(0.33333334f);
        k3.scale(0.33333334f);
        k4.scale(0.16666667f);
        initial.add(k1);
        initial.add(k2);
        initial.add(k3);
        initial.add(k4);
        int i2 = 0;
        while (i2 < initialStates.size()) {
            passback.set(i2, initial.get(i2));
            ++i2;
        }
        Real.pool.release(k1);
        Real.pool.release(k2);
        Real.pool.release(k3);
        Real.pool.release(k4);
        Real.pool.release(initial);
        Real.pool.release(in);
    }

    public static float intergrateAapative(Vector initialState, Differential evaluator, float t_start, float t_end, float accuracy, float subStepSize, Vector passback) {
        float errorRate = accuracy / (t_end - t_start);
        Real initial = Real.pool.aquire(initialState.size());
        Real end1 = Real.pool.aquire(initialState.size());
        Real end2 = Real.pool.aquire(initialState.size());
        Real mid = Real.pool.aquire(initialState.size());
        initial.set(initialState);
        KahanSum t_sub_start = new KahanSum(t_start);
        while (t_sub_start.val() < t_end) {
            float t_sub_end = Math.min(t_end, t_sub_start.val() + subStepSize);
            float t_sub_mid = (t_sub_start.val() + t_sub_end) / 2.0f;
            float h = subStepSize;
            float required_accuracy = errorRate * h;
            RK4.intergrate(initial, evaluator, t_sub_start.val(), t_sub_end, end1);
            RK4.intergrate(initial, evaluator, t_sub_start.val(), t_sub_mid, mid);
            RK4.intergrate(mid, evaluator, t_sub_mid, t_sub_end, end2);
            float error = 0.0f;
            int i = 0;
            while (i < end1.size()) {
                error = Math.max(Math.abs(end1.get(i) - end2.get(i)), error);
                ++i;
            }
            JOODELog.debug("t_sub_start = ", Float.valueOf(t_sub_start.val()));
            JOODELog.debug("h = ", Float.valueOf(h));
            JOODELog.debug("error = ", Float.valueOf(error));
            JOODELog.debug("end1 = ", end1);
            JOODELog.debug("end2 = ", end2);
            subStepSize = error == 0.0f ? (subStepSize *= maxIncreaseFactor) : h * safteyFactor * (float)Math.pow(error / required_accuracy, -0.25);
            subStepSize = Math.min(subStepSize, h * maxIncreaseFactor);
            subStepSize = Math.max(subStepSize, h * maxDecreaseFactor);
            subStepSize = Math.max(subStepSize, minSubStepsize);
            if (error > required_accuracy && h != minSubStepsize) {
                assert (subStepSize < h);
                continue;
            }
            t_sub_start.add(h);
            initial.set(end2);
        }
        int i = 0;
        while (i < end2.size()) {
            passback.set(i, initial.get(i));
            ++i;
        }
        Real.pool.release(initial);
        Real.pool.release(end1);
        Real.pool.release(end2);
        Real.pool.release(mid);
        return subStepSize;
    }

    public static void intergrateAapative(Vector initialState, Differential evaluator, float t_start, float t_end, float accuracy, Vector passback) {
        Real initial = Real.pool.aquire(initialState.size());
        Real end1 = Real.pool.aquire(initialState.size());
        Real end2 = Real.pool.aquire(initialState.size());
        Real mid = Real.pool.aquire(initialState.size());
        float t_mid = (t_start + t_end) / 2.0f;
        initial.set(initialState);
        RK4.intergrate(initial, evaluator, t_start, t_end, end1);
        RK4.intergrate(initial, evaluator, t_start, t_mid, mid);
        RK4.intergrate(mid, evaluator, t_mid, t_end, end2);
        float error = 0.0f;
        int i = 0;
        while (i < end1.size()) {
            error = Math.max(Math.abs(end1.get(i) - end2.get(i)), error);
            ++i;
        }
        if (error < accuracy) {
            i = 0;
            while (i < end2.size()) {
                passback.set(i, end2.get(i));
                ++i;
            }
        } else {
            float stepsize = t_end - t_start;
            float maximumStepsize = stepsize * (float)Math.pow(error / accuracy, -0.25);
            int numberOfSteps = (int)Math.ceil(stepsize / maximumStepsize);
            float actualStepSize = stepsize / (float)numberOfSteps;
            int i2 = 0;
            while (i2 < passback.size()) {
                passback.set(i2, initial.get(i2));
                ++i2;
            }
            float t_e = 0.0f;
            float t_s = t_start;
            int i3 = 0;
            while (i3 < numberOfSteps) {
                t_e = t_s + actualStepSize;
                RK4.intergrate(passback, evaluator, t_s, t_e, passback);
                t_s += actualStepSize;
                if (i3 / numberOfSteps == 2) {
                    mid.set(passback);
                }
                ++i3;
            }
            if (!Real.epsilonEquals(t_e, t_end, 1.0E-4f)) {
                JOODELog.error("error, adaptive step did not correctly step to the end");
            }
        }
        Real.pool.release(initial);
        Real.pool.release(end1);
        Real.pool.release(end2);
        Real.pool.release(mid);
    }

    public static interface Differential {
        public void evaluate(Vector var1, float var2, float var3, float var4, Vector var5);

        public int size();
    }
}

