/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.curves;

import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierCurve2 {
    private final Point3f[] points = new Point3f[3];

    public final Point3f[] getBasePoints() {
        return this.points;
    }

    public final Point3f getBasePoint(int i) {
        return this.points[i];
    }

    public final <P extends Tuple3f> P getPoint(float i, P p) {
        if (i < 0.0f || i > 1.0f) {
            throw new IllegalArgumentException("i must be in range [0..1]");
        }
        p.setX(FastMath.pow2(1.0f - i) * this.points[0].getX() + 2.0f * i * (1.0f - i) * this.points[1].getX() + FastMath.pow2(i) * this.points[2].getX());
        p.setY(FastMath.pow2(1.0f - i) * this.points[0].getY() + 2.0f * i * (1.0f - i) * this.points[1].getY() + FastMath.pow2(i) * this.points[2].getY());
        p.setZ(FastMath.pow2(1.0f - i) * this.points[0].getZ() + 2.0f * i * (1.0f - i) * this.points[1].getZ() + FastMath.pow2(i) * this.points[2].getZ());
        return p;
    }

    public final Point3f getPoint(float i) {
        return this.getPoint(i, new Point3f());
    }

    public final Tuple3f[] getPoints(Tuple3f[] result) {
        int i = 0;
        while (i < result.length) {
            if (result[i] == null) {
                result[i] = new Point3f();
            }
            this.getPoint((float)i / (float)(result.length - 1), result[i]);
            ++i;
        }
        return result;
    }

    public final Point3f[] getPoints(Point3f[] result) {
        return (Point3f[])this.getPoints((Tuple3f[])result);
    }

    public final Point3f[] getPoints(int numPoints) {
        return this.getPoints(new Point3f[numPoints]);
    }

    public BezierCurve2(Tuple3f startPoint, Tuple3f midPoint, Tuple3f endPoint) {
        this.points[0] = new Point3f(startPoint);
        this.points[1] = new Point3f(midPoint);
        this.points[2] = new Point3f(endPoint);
    }

    public BezierCurve2(Point3f[] points) {
        System.arraycopy(points, 0, this.points, 0, 3);
    }
}

