/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.decomposition;

import org.openmali.FastMath;
import org.openmali.vecmath2.MatrixMxNf;

public class QRDecomposition {
    private final MatrixMxNf QR;
    private final int m;
    private final int n;
    private final float[] Rdiag;

    public QRDecomposition(MatrixMxNf A) {
        this.QR = new MatrixMxNf(A);
        this.m = A.getNumRows();
        this.n = A.getNumCols();
        this.Rdiag = new float[this.n];
        int k = 0;
        while (k < this.n) {
            float nrm = 0.0f;
            int i = k;
            while (i < this.m) {
                nrm = FastMath.hypot(nrm, this.QR.get(i, k));
                ++i;
            }
            if (nrm != 0.0f) {
                if (this.QR.get(k, k) < 0.0f) {
                    nrm = -nrm;
                }
                i = k;
                while (i < this.m) {
                    this.QR.div(i, k, nrm);
                    ++i;
                }
                this.QR.add(k, k, 1.0f);
                int j = k + 1;
                while (j < this.n) {
                    float s = 0.0f;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.QR.get(i2, k) * this.QR.get(i2, j);
                        ++i2;
                    }
                    s = -s / this.QR.get(k, k);
                    i2 = k;
                    while (i2 < this.m) {
                        this.QR.add(i2, j, s * this.QR.get(i2, k));
                        ++i2;
                    }
                    ++j;
                }
            }
            this.Rdiag[k] = -nrm;
            ++k;
        }
    }

    public final boolean isFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.Rdiag[j] == 0.0f) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public MatrixMxNf getH() {
        MatrixMxNf H = new MatrixMxNf(this.m, this.n);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                if (i >= j) {
                    H.set(i, j, this.QR.get(i, j));
                } else {
                    H.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        return H;
    }

    public MatrixMxNf getR() {
        MatrixMxNf R = new MatrixMxNf(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i < j) {
                    R.set(i, j, this.QR.get(i, j));
                } else if (i == j) {
                    R.set(i, j, this.Rdiag[i]);
                } else {
                    R.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        return R;
    }

    public MatrixMxNf getQ() {
        MatrixMxNf Q = new MatrixMxNf(this.m, this.n);
        int k = this.n - 1;
        while (k >= 0) {
            int i = 0;
            while (i < this.m) {
                Q.set(i, k, 0.0f);
                ++i;
            }
            Q.set(k, k, 1.0f);
            int j = k;
            while (j < this.n) {
                if (this.QR.get(k, k) != 0.0f) {
                    float s = 0.0f;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.QR.get(i2, k) * Q.get(i2, j);
                        ++i2;
                    }
                    s = -s / this.QR.get(k, k);
                    i2 = k;
                    while (i2 < this.m) {
                        Q.add(i2, j, s * this.QR.get(i2, k));
                        ++i2;
                    }
                }
                ++j;
            }
            --k;
        }
        return Q;
    }

    public final MatrixMxNf solve(MatrixMxNf B, MatrixMxNf result) {
        int j;
        if (B.getNumRows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getNumCols();
        MatrixMxNf X = new MatrixMxNf(B);
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                float s = 0.0f;
                int i = k;
                while (i < this.m) {
                    s += this.QR.get(i, k) * X.get(i, j);
                    ++i;
                }
                s = -s / this.QR.get(k, k);
                i = k;
                while (i < this.m) {
                    X.add(i, j, s * this.QR.get(i, k));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                X.div(k, j, this.Rdiag[k]);
                ++j;
            }
            int i = 0;
            while (i < k) {
                int j2 = 0;
                while (j2 < nx) {
                    X.sub(i, j2, X.get(k, j2) * this.QR.get(i, k));
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        MatrixMxNf result2 = X.getSharedSubMatrix(0, 0, this.n - 1, nx - 1);
        if (result != null) {
            result.set(result2);
        }
        return result2;
    }
}

