/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.decomposition;

import org.openmali.FastMath;
import org.openmali.vecmath2.MatrixMxNf;

public class SingularValueDecomposition {
    private MatrixMxNf U;
    private MatrixMxNf V;
    private final float[] s;
    private final int m;
    private final int n;

    public SingularValueDecomposition(MatrixMxNf M) {
        int i;
        int k;
        int j;
        MatrixMxNf A = new MatrixMxNf(M);
        this.m = M.getNumRows();
        this.n = M.getNumCols();
        int nu = Math.min(this.m, this.n);
        this.s = new float[Math.min(this.m + 1, this.n)];
        this.U = new MatrixMxNf(this.m, nu);
        this.V = new MatrixMxNf(this.n, this.n);
        float[] e = new float[this.n];
        float[] work = new float[this.m];
        boolean wantU = true;
        boolean wantV = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k2 = 0;
        while (k2 < Math.max(nct, nrt)) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.s[k2] = 0.0f;
                i3 = k2;
                while (i3 < this.m) {
                    this.s[k2] = FastMath.hypot(this.s[k2], A.get(i3, k2));
                    ++i3;
                }
                if ((double)this.s[k2] != 0.0) {
                    if (A.get(k2, k2) < 0.0f) {
                        this.s[k2] = -this.s[k2];
                    }
                    i3 = k2;
                    while (i3 < this.m) {
                        A.div(i3, k2, this.s[k2]);
                        ++i3;
                    }
                    A.add(k2, k2, 1.0f);
                }
                this.s[k2] = -this.s[k2];
            }
            j = k2 + 1;
            while (j < this.n) {
                if (k2 < nct & this.s[k2] != 0.0f) {
                    float t = 0.0f;
                    i2 = k2;
                    while (i2 < this.m) {
                        t += A.get(i2, k2) * A.get(i2, j);
                        ++i2;
                    }
                    t = -t / A.get(k2, k2);
                    i2 = k2;
                    while (i2 < this.m) {
                        A.add(i2, j, t * A.get(i2, k2));
                        ++i2;
                    }
                }
                e[j] = A.get(k2, j);
                ++j;
            }
            if (wantU & k2 < nct) {
                i3 = k2;
                while (i3 < this.m) {
                    this.U.set(i3, k2, A.get(i3, k2));
                    ++i3;
                }
            }
            if (k2 < nrt) {
                e[k2] = 0.0f;
                i3 = k2 + 1;
                while (i3 < this.n) {
                    e[k2] = FastMath.hypot(e[k2], e[i3]);
                    ++i3;
                }
                if (e[k2] != 0.0f) {
                    if (e[k2 + 1] < 0.0f) {
                        e[k2] = -e[k2];
                    }
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k2];
                    }
                    int n = k2 + 1;
                    e[n] = e[n] + 1.0f;
                }
                e[k2] = -e[k2];
                if (k2 + 1 < this.m & e[k2] != 0.0f) {
                    i3 = k2 + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0f;
                        ++i3;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        int i4 = k2 + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A.get(i4, j);
                            ++i4;
                        }
                        ++j;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        float t = -e[j] / e[k2 + 1];
                        i2 = k2 + 1;
                        while (i2 < this.m) {
                            A.add(i2, j, t * work[i2]);
                            ++i2;
                        }
                        ++j;
                    }
                }
                if (wantV) {
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        this.V.set(i3, k2, e[i3]);
                        ++i3;
                    }
                }
            }
            ++k2;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A.get(nct, nct);
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0f;
        }
        if (nrt + 1 < p) {
            e[nrt] = A.get(nrt, p - 1);
        }
        e[p - 1] = 0.0f;
        if (wantU) {
            j = nct;
            while (j < nu) {
                int i5 = 0;
                while (i5 < this.m) {
                    this.U.set(i5, j, 0.0f);
                    ++i5;
                }
                this.U.set(j, j, 1.0f);
                ++j;
            }
            k = nct - 1;
            while (k >= 0) {
                int i6;
                if (this.s[k] != 0.0f) {
                    int j2 = k + 1;
                    while (j2 < nu) {
                        float t = 0.0f;
                        i = k;
                        while (i < this.m) {
                            t += this.U.get(i, k) * this.U.get(i, j2);
                            ++i;
                        }
                        t = -t / this.U.get(k, k);
                        i = k;
                        while (i < this.m) {
                            this.U.add(i, j2, t * this.U.get(i, k));
                            ++i;
                        }
                        ++j2;
                    }
                    i6 = k;
                    while (i6 < this.m) {
                        this.U.sub(i6, k, -this.U.get(i6, k));
                        ++i6;
                    }
                    this.U.set(k, k, 1.0f + this.U.get(k, k));
                    i6 = 0;
                    while (i6 < k - 1) {
                        this.U.set(i6, k, 0.0f);
                        ++i6;
                    }
                } else {
                    i6 = 0;
                    while (i6 < this.m) {
                        this.U.set(i6, k, 0.0f);
                        ++i6;
                    }
                    this.U.set(k, k, 1.0f);
                }
                --k;
            }
        }
        if (wantV) {
            k = this.n - 1;
            while (k >= 0) {
                if (k < nrt & e[k] != 0.0f) {
                    int j3 = k + 1;
                    while (j3 < nu) {
                        float t = 0.0f;
                        i = k + 1;
                        while (i < this.n) {
                            t += this.V.get(i, k) * this.V.get(i, j3);
                            ++i;
                        }
                        t = -t / this.V.get(k + 1, k);
                        i = k + 1;
                        while (i < this.n) {
                            this.V.add(i, j3, t * this.V.get(i, k));
                            ++i;
                        }
                        ++j3;
                    }
                }
                int i7 = 0;
                while (i7 < this.n) {
                    this.V.set(i7, k, 0.0f);
                    ++i7;
                }
                this.V.set(k, k, 1.0f);
                --k;
            }
        }
        int pp = p - 1;
        int iter = 0;
        float eps = FastMath.pow(2.0f, -52.0f);
        float tiny = FastMath.pow(2.0f, -966.0f);
        block35: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= -1) {
                if (k3 == -1) break;
                if (Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1]))) {
                    e[k3] = 0.0f;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    float t = (ks != p ? Math.abs(e[ks]) : 0.0f) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0f);
                    if (Math.abs(this.s[ks]) <= tiny + eps * t) {
                        this.s[ks] = 0.0f;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[p - 2];
                    e[p - 2] = 0.0f;
                    int j4 = p - 2;
                    while (j4 >= k3) {
                        t = FastMath.hypot(this.s[j4], f);
                        cs = this.s[j4] / t;
                        sn = f / t;
                        this.s[j4] = t;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (wantV) {
                            int i8 = 0;
                            while (i8 < this.n) {
                                t = cs * this.V.get(i8, j4) + sn * this.V.get(i8, p - 1);
                                this.V.set(i8, p - 1, -sn * this.V.get(i8, j4) + cs * this.V.get(i8, p - 1));
                                this.V.set(i8, j4, t);
                                ++i8;
                            }
                        }
                        --j4;
                    }
                    continue block35;
                }
                case 2: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[k3 - 1];
                    e[k3 - 1] = 0.0f;
                    int j5 = k3;
                    while (j5 < p) {
                        t = FastMath.hypot(this.s[j5], f);
                        cs = this.s[j5] / t;
                        sn = f / t;
                        this.s[j5] = t;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (wantU) {
                            int i9 = 0;
                            while (i9 < this.m) {
                                t = cs * this.U.get(i9, j5) + sn * this.U.get(i9, k3 - 1);
                                this.U.set(i9, k3 - 1, -sn * this.U.get(i9, j5) + cs * this.U.get(i9, k3 - 1));
                                this.U.set(i9, j5, t);
                                ++i9;
                            }
                        }
                        ++j5;
                    }
                    continue block35;
                }
                case 3: {
                    float scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    float sp = this.s[p - 1] / scale;
                    float spm1 = this.s[p - 2] / scale;
                    float epm1 = e[p - 2] / scale;
                    float sk = this.s[k3] / scale;
                    float ek = e[k3] / scale;
                    float b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0f;
                    float c = sp * epm1 * (sp * epm1);
                    float shift = 0.0f;
                    if ((double)b != 0.0 | (double)c != 0.0) {
                        shift = FastMath.sqrt(b * b + c);
                        if ((double)b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    float f = (sk + sp) * (sk - sp) + shift;
                    float g = sk * ek;
                    int j6 = k3;
                    while (j6 < p - 1) {
                        int i10;
                        float t = FastMath.hypot(f, g);
                        float cs = f / t;
                        float sn = g / t;
                        if (j6 != k3) {
                            e[j6 - 1] = t;
                        }
                        f = cs * this.s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.s[j6];
                        g = sn * this.s[j6 + 1];
                        this.s[j6 + 1] = cs * this.s[j6 + 1];
                        if (wantV) {
                            i10 = 0;
                            while (i10 < this.n) {
                                t = cs * this.V.get(i10, j6) + sn * this.V.get(i10, j6 + 1);
                                this.V.set(i10, j6 + 1, -sn * this.V.get(i10, j6) + cs * this.V.get(i10, j6 + 1));
                                this.V.set(i10, j6, t);
                                ++i10;
                            }
                        }
                        t = FastMath.hypot(f, g);
                        cs = f / t;
                        sn = g / t;
                        this.s[j6] = t;
                        f = cs * e[j6] + sn * this.s[j6 + 1];
                        this.s[j6 + 1] = -sn * e[j6] + cs * this.s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (wantU && j6 < this.m - 1) {
                            i10 = 0;
                            while (i10 < this.m) {
                                t = cs * this.U.get(i10, j6) + sn * this.U.get(i10, j6 + 1);
                                this.U.set(i10, j6 + 1, -sn * this.U.get(i10, j6) + cs * this.U.get(i10, j6 + 1));
                                this.U.set(i10, j6, t);
                                ++i10;
                            }
                        }
                        ++j6;
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0f) {
                        float f = this.s[k3] = this.s[k3] < 0.0f ? -this.s[k3] : 0.0f;
                        if (wantV) {
                            int i11 = 0;
                            while (i11 <= pp) {
                                this.V.set(i11, k3, -this.V.get(i11, k3));
                                ++i11;
                            }
                        }
                    }
                    while (k3 < pp) {
                        if (this.s[k3] >= this.s[k3 + 1]) break;
                        float t = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t;
                        if (wantV && k3 < this.n - 1) {
                            int i12 = 0;
                            while (i12 < this.n) {
                                t = this.V.get(i12, k3 + 1);
                                this.V.set(i12, k3 + 1, this.V.get(i12, k3));
                                this.V.set(i12, k3, t);
                                ++i12;
                            }
                        }
                        if (wantU && k3 < this.m - 1) {
                            int i13 = 0;
                            while (i13 < this.m) {
                                t = this.U.get(i13, k3 + 1);
                                this.U.set(i13, k3 + 1, this.U.get(i13, k3));
                                this.U.set(i13, k3, t);
                                ++i13;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public final MatrixMxNf getU() {
        MatrixMxNf result = new MatrixMxNf(this.m, Math.min(this.m + 1, this.n));
        result.set(this.U);
        return result;
    }

    public MatrixMxNf getV() {
        MatrixMxNf result = new MatrixMxNf(this.n, this.n);
        result.set(this.V);
        return result;
    }

    public float[] getSingularValues() {
        return this.s;
    }

    public MatrixMxNf getS() {
        MatrixMxNf S = new MatrixMxNf(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                S.set(i, j, 0.0f);
                ++j;
            }
            S.set(i, i, this.s[i]);
            ++i;
        }
        return S;
    }

    public final float norm2() {
        return this.s[0];
    }

    public final float cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        float eps = FastMath.pow(2.0f, -52.0f);
        float tol = (float)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.s.length) {
            if (this.s[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }
}

