/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.openmali.number.Radical1;
import org.openmali.number.Rational;
import org.openmali.number.matrix.Matrix4rad;

public class Parser {
    private static final char RADICAL_SIGN = '\u00fb';
    private StreamTokenizer tokenizer;
    private int num;
    private int den;
    private Rational rational;
    private int radicand;

    public Parser(Reader in) {
        this.tokenizer = new StreamTokenizer(in);
        this.tokenizer.parseNumbers();
        this.tokenizer.ordinaryChar(45);
        this.tokenizer.ordinaryChar(43);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(42);
    }

    public StreamTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public Matrix4rad matrix4rad() throws IOException {
        Matrix4rad ret = new Matrix4rad();
        this.tokenizer.nextToken();
        assert (this.tokenizer.ttype == 91);
        int i = 0;
        while (i < 4) {
            this.tokenizer.nextToken();
            assert (this.tokenizer.ttype == 91);
            ret.set(i, 0, this.radicand1());
            ret.set(i, 1, this.radicand1());
            ret.set(i, 2, this.radicand1());
            ret.set(i, 3, this.radicand1());
            this.tokenizer.nextToken();
            assert (this.tokenizer.ttype == 93);
            ++i;
        }
        this.tokenizer.nextToken();
        assert (this.tokenizer.ttype == 93);
        return ret;
    }

    public Radical1 radicand1() throws IOException {
        Radical1 result = new Radical1();
        this.radicand1Term();
        result.setTerm(this.rational, this.radicand);
        while (this.tokenizer.nextToken() == 43) {
            this.radicand1Term();
            result.setTerm(this.rational, this.radicand);
        }
        this.tokenizer.pushBack();
        return result;
    }

    public void radicand1Term() throws IOException {
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.charAt(0) == '\u00fb') {
            this.rational = new Rational(1);
            this.tokenizer.pushBack();
            this.radicand();
        } else {
            this.tokenizer.pushBack();
            this.rational = this.rational();
            if (this.tokenizer.nextToken() == 42) {
                this.radicand();
            } else {
                this.radicand = 1;
                this.tokenizer.pushBack();
            }
        }
    }

    private void radicand() throws IOException {
        int token = this.tokenizer.nextToken();
        if (token == -3) {
            assert (this.tokenizer.sval.charAt(0) == '\u00fb');
            this.radicand = Integer.parseInt(this.tokenizer.sval.substring(1));
        } else {
            System.err.println("unexpected parse problems, whitespace after \u00fb ?");
            this.radicand = -1;
        }
    }

    public Rational rational() throws IOException {
        int type = this.tokenizer.nextToken();
        if (type == 40) {
            int whole = this.integer();
            if (this.tokenizer.nextToken() != 43) {
                this.tokenizer.pushBack();
            }
            this.fraction();
            Rational ret = new Rational(whole, this.num, this.den);
            assert (this.tokenizer.nextToken() == 41);
            return ret;
        }
        this.tokenizer.pushBack();
        this.fraction();
        return new Rational(this.num, this.den);
    }

    public void fraction() throws IOException {
        this.num = this.integer();
        if (this.tokenizer.nextToken() == 47) {
            this.den = this.natural();
        } else {
            this.den = 1;
            this.tokenizer.pushBack();
        }
    }

    public int integer() throws IOException {
        int val = (this.optionalSign() ? 1 : -1) * this.natural();
        return val;
    }

    private boolean optionalSign() throws IOException {
        boolean positive = true;
        if (this.tokenizer.nextToken() != -2) {
            if (this.tokenizer.ttype != 43) {
                if (this.tokenizer.ttype == 45) {
                    positive = !positive;
                } else {
                    System.out.println("err");
                }
            }
        } else {
            assert (this.tokenizer.ttype == -2);
            this.tokenizer.pushBack();
        }
        return positive;
    }

    public int natural() throws IOException {
        int type = this.tokenizer.nextToken();
        assert (type == -2) : this.tokenizer.sval;
        return (int)this.tokenizer.nval;
    }

    public float floatNum() throws IOException {
        boolean positive = this.optionalSign();
        int type = this.tokenizer.nextToken();
        assert (type == -2) : this.tokenizer.sval;
        float val = (float)this.tokenizer.nval * (float)(positive ? 1 : -1);
        this.tokenizer.nextToken();
        if ("E".equals(this.tokenizer.sval)) {
            int exponent = this.integer();
            val = (float)((double)val * Math.pow(10.0, exponent));
        } else {
            this.tokenizer.pushBack();
        }
        return val;
    }
}

