/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openmali.FastMath;
import org.openmali.number.Parser;
import org.openmali.number.PrimeFactorization;
import org.openmali.number.RadicandBounds;
import org.openmali.number.Rational;

public class Radical1
implements Serializable {
    private static final long serialVersionUID = 6504477689753898414L;
    public HashMap<Integer, Rational> radicands = new HashMap();
    public static final Rational upperTmp = new Rational();
    public static final Rational lowerTmp = new Rational();
    public static final Rational upperTmp2 = new Rational();
    public static final Rational lowerTmp2 = new Rational();
    public static Radical1 ONE = new Radical1(1, 1, 1);
    public static Radical1 ZERO = new Radical1(0, 1, 1);
    public static Object MINUS_ONE = new Radical1(-1, 1, 1);

    public final void setZero() {
        this.radicands.clear();
    }

    public final void set(Radical1 value) {
        this.radicands.clear();
        for (Integer radicand : value.radicands.keySet()) {
            this.radicands.put(radicand, value.radicands.get(radicand).clone());
        }
    }

    public final void get(Radical1 passback) {
        passback.set(this);
    }

    public final float floatValue() {
        float val = 0.0f;
        for (Integer radicand : this.radicands.keySet()) {
            float multiplier = this.radicands.get(radicand).floatValue();
            float radicandValue = FastMath.sqrt(radicand.floatValue());
            val += multiplier * radicandValue;
        }
        return val;
    }

    public final Radical1 negate(Radical1 passback) {
        Radical1.sub(new Radical1(), this, passback);
        return passback;
    }

    public Radical1 negate() {
        for (Rational rational : this.radicands.values()) {
            rational.negate();
        }
        return this;
    }

    public void absolute(Radical1 passback) {
        if (this.floatValue() <= 0.0f) {
            this.negate(passback);
        } else {
            passback.set(this);
        }
    }

    public Radical1 mul(Rational factor, Radical1 passback) {
        HashMap<Integer, Rational> result = new HashMap<Integer, Rational>();
        for (Integer radicand : this.radicands.keySet()) {
            Rational multiplier = this.radicands.get(radicand);
            result.put(radicand, Rational.mul(multiplier, factor, new Rational()));
        }
        passback.radicands.clear();
        passback.radicands.putAll(result);
        return passback;
    }

    public void setTerm(Rational multiplier, Integer radicand) {
        int inside;
        int outside;
        if (!PrimeFactorization.isPrime(radicand)) {
            outside = 1;
            inside = 1;
            List<Integer> primes = PrimeFactorization.getPrimeFactorization(radicand, new ArrayList<Integer>());
            int previousPrime = -1;
            for (Integer prime : primes) {
                if (prime == previousPrime) {
                    outside *= prime.intValue();
                    inside /= prime.intValue();
                    previousPrime = -1;
                    continue;
                }
                inside *= prime.intValue();
                previousPrime = prime;
            }
        } else {
            inside = radicand;
            outside = 1;
        }
        multiplier = Rational.mul(multiplier, new Rational(outside), new Rational());
        radicand = inside;
        if (!multiplier.equals(Rational.ZERO)) {
            this.radicands.put(radicand, multiplier);
        }
    }

    public void setTerm(Rational multiplier, Rational radicand) {
        Rational resultantRadicand = Rational.mul(radicand, new Rational(radicand.getDenominator() * radicand.getDenominator(), 1), new Rational());
        assert (resultantRadicand.getDenominator() == 1);
        int numerator = resultantRadicand.getNumerator() + resultantRadicand.getWhole();
        Rational resultantMultiplier = Rational.mul(multiplier, new Rational(1, radicand.getDenominator()), new Rational());
        this.setTerm(resultantMultiplier, numerator);
    }

    public void addTerm(Rational multiplier, Integer radicand) {
        int inside;
        int outside;
        if (!PrimeFactorization.isPrime(radicand)) {
            outside = 1;
            inside = 1;
            List<Integer> primes = PrimeFactorization.getPrimeFactorization(radicand, new ArrayList<Integer>());
            int previousPrime = -1;
            for (Integer prime : primes) {
                if (prime == previousPrime) {
                    outside *= prime.intValue();
                    inside /= prime.intValue();
                    previousPrime = -1;
                    continue;
                }
                inside *= prime.intValue();
                previousPrime = prime;
            }
        } else {
            inside = radicand;
            outside = 1;
        }
        multiplier = Rational.mul(multiplier, new Rational(outside), new Rational());
        radicand = inside;
        Rational previousMultiplier = this.radicands.get(radicand);
        if (previousMultiplier == null) {
            if (!multiplier.equals(Rational.ZERO)) {
                this.radicands.put(radicand, multiplier);
            }
        } else {
            Rational.add(previousMultiplier, multiplier, previousMultiplier);
            if (previousMultiplier.equals(Rational.ZERO)) {
                this.radicands.remove(radicand);
            }
        }
    }

    public void getBounds(Rational upperPassback, Rational lowerPassback) {
        upperPassback.set(0, 0, 1);
        lowerPassback.set(0, 0, 1);
        for (Integer radicand : this.radicands.keySet()) {
            RadicandBounds.getBounds(radicand, upperTmp, lowerTmp);
            Rational.mul(upperTmp, this.radicands.get(radicand), upperTmp);
            Rational.mul(lowerTmp, this.radicands.get(radicand), lowerTmp);
            Rational.add(upperPassback, upperTmp, upperPassback);
            Rational.add(lowerPassback, lowerTmp, lowerPassback);
        }
    }

    public static Radical1 add(Radical1 a, Radical1 b, Radical1 result) {
        HashMap<Integer, Rational> radicands = new HashMap<Integer, Rational>();
        HashSet totalRadicands = new HashSet();
        totalRadicands.addAll(a.radicands.keySet());
        totalRadicands.addAll(b.radicands.keySet());
        for (Integer radicand : totalRadicands) {
            Rational resultMultiplier;
            Rational multiplierA = a.radicands.get(radicand);
            Rational multiplierB = b.radicands.get(radicand);
            if (multiplierA != null && multiplierB != null) {
                resultMultiplier = Rational.add(multiplierA, multiplierB, new Rational());
            } else if (multiplierA != null) {
                resultMultiplier = new Rational(multiplierA);
            } else {
                assert (multiplierB != null);
                resultMultiplier = new Rational(multiplierB);
            }
            if (resultMultiplier.equals(Rational.ZERO)) continue;
            radicands.put(radicand, resultMultiplier);
        }
        result.radicands.clear();
        result.radicands.putAll(radicands);
        return result;
    }

    public static Radical1 sub(Radical1 a, Radical1 b, Radical1 result) {
        HashMap<Integer, Rational> radicands = new HashMap<Integer, Rational>();
        HashSet totalRadicands = new HashSet();
        totalRadicands.addAll(a.radicands.keySet());
        totalRadicands.addAll(b.radicands.keySet());
        for (Integer radicand : totalRadicands) {
            Rational multiplierA = a.radicands.get(radicand);
            Rational multiplierB = b.radicands.get(radicand);
            Rational resultMultiplier = new Rational();
            if (multiplierA != null) {
                Rational.add(multiplierA, resultMultiplier, resultMultiplier);
            }
            if (multiplierB != null) {
                Rational.sub(resultMultiplier, multiplierB, resultMultiplier);
            }
            if (resultMultiplier.equals(Rational.ZERO)) continue;
            radicands.put(radicand, resultMultiplier);
        }
        result.radicands.clear();
        result.radicands.putAll(radicands);
        return result;
    }

    public static Radical1 mul(Radical1 a, Radical1 b, Radical1 result) {
        Radical1 tmp = new Radical1();
        for (Integer radicandA : a.radicands.keySet()) {
            for (Integer radicandB : b.radicands.keySet()) {
                Rational multiplierA = a.radicands.get(radicandA);
                Rational multiplierB = b.radicands.get(radicandB);
                Rational resultantMultiplier = Rational.mul(multiplierA, multiplierB, new Rational());
                int resultantRadicand = radicandA * radicandB;
                tmp.addTerm(resultantMultiplier, resultantRadicand);
            }
        }
        Iterator<Integer> radicandIter = tmp.radicands.keySet().iterator();
        while (radicandIter.hasNext()) {
            Integer radicand = radicandIter.next();
            if (!tmp.radicands.get(radicand).equals(Rational.ZERO)) continue;
            tmp.radicands.get(radicand).equals(Rational.ZERO);
            radicandIter.remove();
        }
        result.radicands.clear();
        result.radicands.putAll(tmp.radicands);
        return result;
    }

    public static Radical1 mod(Radical1 rad, Rational mod, Radical1 passback) {
        Radical1 modRad = new Radical1(mod);
        rad.getBounds(upperTmp2, lowerTmp2);
        passback.set(rad);
        while (upperTmp2.compareTo(mod) >= 0 && lowerTmp2.compareTo(mod) >= 0) {
            Radical1.sub(passback, modRad, passback);
            Rational.sub(upperTmp2, mod, upperTmp2);
            Rational.sub(lowerTmp2, mod, lowerTmp2);
        }
        while (upperTmp2.compareTo(Rational.ZERO) < 0 && lowerTmp2.compareTo(Rational.ZERO) < 0) {
            Radical1.add(passback, modRad, passback);
            Rational.add(upperTmp2, mod, upperTmp2);
            Rational.add(lowerTmp2, mod, lowerTmp2);
        }
        if (upperTmp2.compareTo(mod) != lowerTmp2.compareTo(mod)) {
            throw new ArithmeticException("Cannot find bounds tight enough to perform provably correct mod operation");
        }
        return passback;
    }

    public String toString() {
        if (this.radicands.size() == 0) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        for (Integer radicand : this.radicands.keySet()) {
            buf.append("+");
            if (!this.radicands.get(radicand).equals(Rational.ONE)) {
                buf.append(this.radicands.get(radicand)).append("*");
            }
            if (radicand == 1) {
                if (!this.radicands.get(radicand).equals(Rational.ONE)) {
                    buf.replace(buf.length() - 1, buf.length(), "");
                    continue;
                }
                buf.append("1");
                continue;
            }
            buf.append("\u221a").append(radicand);
        }
        buf.replace(0, 1, "");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Radical1 radical1 = (Radical1)o;
        return this.radicands.equals(radical1.radicands);
    }

    public static final boolean equals(Radical1 a, Radical1 b) {
        return a.equals(b);
    }

    public int hashCode() {
        return this.radicands.hashCode();
    }

    public Radical1 clone() {
        Radical1 rad = new Radical1();
        rad.set(this);
        return rad;
    }

    public Radical1(Radical1 value) {
        this.set(value);
    }

    public Radical1() {
    }

    public Radical1(int value) {
        this.setTerm(new Rational(value, 1), 1);
    }

    public Radical1(Rational rational) {
        this.setTerm(rational, 1);
    }

    public Radical1(Rational rational, int radical) {
        this.addTerm(rational, radical);
    }

    public Radical1(int nom, int den, int radical) {
        this.addTerm(new Rational(nom, den), radical);
    }

    public static Radical1 parseRadical1(String string) {
        StringReader in = new StringReader(string);
        try {
            Radical1 ret = new Parser(in).radicand1();
            in.close();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

