/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openmali.FastMath;
import org.openmali.number.Radical1;
import org.openmali.number.Rational;
import org.openmali.number.matrix.Matrix3rad;
import org.openmali.number.matrix.Matrix4rad;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadicalUtils {
    public static HashSet<Radical1> approximators = new HashSet();
    private static Radical1 tmp = new Radical1();

    static {
        approximators.add(new Radical1(1));
        approximators.add(new Radical1(-1));
        approximators.add(new Radical1(0));
        approximators.add(new Radical1(new Rational(1, 2)));
        approximators.add(new Radical1(new Rational(-1, 2)));
        approximators.add(new Radical1(1, 2, 3));
        approximators.add(new Radical1(-1, 2, 3));
        approximators.add(new Radical1(1, 2, 2));
        approximators.add(new Radical1(-1, 2, 2));
    }

    public static Matrix4rad convert(Matrix4f rotation) {
        Matrix4rad res = new Matrix4rad();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                res.set(i, j, RadicalUtils.convert(rotation.get(i, j)));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static Matrix4f convert(Matrix4rad rotation) {
        Matrix4f res = new Matrix4f();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                res.set(i, j, rotation.get(i, j, tmp).floatValue());
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static Matrix4f convert(Matrix4rad rotation, Matrix4f passback) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                passback.set(i, j, rotation.get(i, j, tmp).floatValue());
                ++j;
            }
            ++i;
        }
        return passback;
    }

    public static Matrix3rad convert(Matrix3f matrix3f) {
        Matrix3rad res = new Matrix3rad();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                res.set(i, j, RadicalUtils.convert(matrix3f.get(i, j)));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static Radical1 convert(float val) {
        float e = 1.0E-4f;
        Radical1 result = null;
        for (Radical1 appriximator : approximators) {
            if (!FastMath.epsilonEquals(val, appriximator.floatValue(), e)) continue;
            result = appriximator.clone();
        }
        if (result == null) {
            throw new RuntimeException("for " + val);
        }
        assert (FastMath.epsilonEquals(result.floatValue(), val, e)) : val;
        return result;
    }

    public static HashSet<Matrix4rad> removeRedundantRadicals(Set<Matrix4rad> data) {
        HashMap<Radical1, Radical1> radicalInstances = new HashMap<Radical1, Radical1>();
        HashMap<Rational, Rational> rationalInstances = new HashMap<Rational, Rational>();
        HashMap<Integer, Integer> integerInstances = new HashMap<Integer, Integer>();
        HashSet<Matrix4rad> result = new HashSet<Matrix4rad>();
        Radical1 tmp = new Radical1();
        for (Matrix4rad rad : data) {
            Matrix4rad newMatrix4rad = rad.clone();
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 4) {
                    newMatrix4rad.setReference(i, j, RadicalUtils.getCachedRational1(rad.get(i, j, tmp), radicalInstances, rationalInstances, integerInstances));
                    ++j;
                }
                ++i;
            }
            result.add(newMatrix4rad);
            assert (newMatrix4rad.equals(rad));
            assert (newMatrix4rad.hashCode() == rad.hashCode());
        }
        return result;
    }

    private static Radical1 getCachedRational1(Radical1 value, HashMap<Radical1, Radical1> radicalCache, HashMap<Rational, Rational> rationalCache, HashMap<Integer, Integer> integerCache) {
        Radical1 ref = radicalCache.get(value);
        if (ref == null) {
            ref = new Radical1(value);
            radicalCache.put(ref, ref);
            HashMap<Integer, Rational> newRadicandSet = new HashMap<Integer, Rational>();
            for (Map.Entry<Integer, Rational> entry : ref.radicands.entrySet()) {
                newRadicandSet.put(RadicalUtils.getCachedInteger(entry.getKey(), integerCache), RadicalUtils.getCachedRational(entry.getValue(), rationalCache));
            }
            ref.radicands = newRadicandSet;
        }
        return ref;
    }

    private static Rational getCachedRational(Rational rational, HashMap<Rational, Rational> rationalCache) {
        Rational ref = rationalCache.get(rational);
        if (ref == null) {
            rationalCache.put(rational, rational);
            ref = rational;
        }
        return ref;
    }

    private static Integer getCachedInteger(Integer key, HashMap<Integer, Integer> integerCache) {
        Integer ref = integerCache.get(key);
        if (ref == null) {
            integerCache.put(key, key);
            ref = key;
        }
        return ref;
    }
}

