/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number.matrix;

import java.io.Serializable;
import org.openmali.number.Radical1;
import org.openmali.number.Rational;
import org.openmali.number.matrix.TupleNrad;
import org.openmali.vecmath2.MatrixMxNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixMxNrad
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5363921506759370621L;
    protected final Radical1[] values;
    private final int rows;
    private final int cols;
    protected final int dataBegin;
    protected final int colSkip;
    private final int roTrick;
    private boolean isDirty = false;
    private final StringBuffer tmpSB = new StringBuffer();

    public final int getNumRows() {
        return this.rows;
    }

    public final int getNumCols() {
        return this.cols;
    }

    public final boolean isSquare() {
        return this.getNumRows() == this.getNumCols();
    }

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final boolean isSubMatrix() {
        return this.dataBegin != 0 || this.colSkip != this.cols;
    }

    public final void set(int row, int column, Radical1 value) {
        this.values[this.roTrick + this.dataBegin + row * this.colSkip + column].set(value);
        this.isDirty = true;
    }

    public void setReference(int row, int column, Radical1 ref) {
        this.values[this.roTrick + this.dataBegin + row * this.colSkip + column] = ref;
    }

    public final Radical1 get(int row, int column, Radical1 passback) {
        this.values[this.dataBegin + row * this.colSkip + column].get(passback);
        return passback;
    }

    public final Radical1 getReference(int row, int column) {
        return this.values[this.dataBegin + row * this.colSkip + column];
    }

    public void set(MatrixMxNrad values) {
        Radical1 tmp = new Radical1();
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.rows) {
                this.set(i, j, values.get(i, j, tmp));
                ++j;
            }
            ++i;
        }
    }

    public final void getRow(int row, TupleNrad<?> tuple) {
        Radical1 tmp = new Radical1();
        int i = 0;
        while (i < this.cols) {
            tuple.set(i, this.get(row, i, tmp));
            ++i;
        }
    }

    public final void setColumn(int col, TupleNrad<?> tuple) {
        Radical1 tmp = new Radical1();
        int i = 0;
        while (i < this.rows) {
            this.set(i, col, tuple.get(i, tmp));
            ++i;
        }
        this.isDirty = true;
    }

    public final void getColumn(int col, TupleNrad<?> tuple) {
        Radical1 tmp = new Radical1();
        int i = 0;
        while (i < this.rows) {
            tuple.set(i, this.get(i, col, tmp));
            ++i;
        }
    }

    public final void setZero() {
        Radical1 zero = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, zero);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void setIdentity() {
        this.setZero();
        Radical1 one = new Radical1(1);
        int min = this.rows < this.cols ? this.rows : this.cols;
        int i = 0;
        while (i < min) {
            this.set(i, i, one);
            ++i;
        }
        this.isDirty = true;
    }

    public final void negate() {
        Radical1 tmp = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, this.get(r, c, tmp).negate(tmp));
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void negate(MatrixMxNrad m) {
        this.set(m);
        this.negate();
        this.isDirty = true;
    }

    public void transpose() {
        Radical1 tmp = new Radical1();
        Radical1 tmp2 = new Radical1();
        int i = 0;
        while (i < this.rows) {
            int j = i + 1;
            while (j < this.cols) {
                this.get(i, j, tmp);
                this.set(i, j, this.get(j, i, tmp2));
                this.set(j, i, tmp);
                ++j;
            }
            ++i;
        }
        this.isDirty = true;
    }

    public void transpose(MatrixMxNrad mat) {
        this.set(mat);
        this.transpose();
        this.isDirty = true;
    }

    public final void copySubMatrix(int rowSource, int colSource, int numRows, int numCols, int rowDest, int colDest, MatrixMxNrad target) {
        Radical1 tmp = new Radical1();
        if (rowSource < 0 || colSource < 0 || rowDest < 0 || colDest < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource, colSource, rowDest, colDest < 0.");
        }
        if (this.rows < numRows + rowSource || this.cols < numCols + colSource) {
            throw new ArrayIndexOutOfBoundsException("Source Matrix too small.");
        }
        if (target.rows < numRows + rowDest || target.cols < numCols + colDest) {
            throw new ArrayIndexOutOfBoundsException("Target Matrix too small.");
        }
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                target.set(i + rowDest, j + colDest, this.get(i + rowSource, j + colSource, tmp));
                ++j;
            }
            ++i;
        }
    }

    public final void add(float scalar) {
        Radical1 value = new Radical1();
        value.addTerm(new Rational(scalar), 1);
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.add(this.values[this.roTrick + this.dataBegin + r * this.colSkip + c], value, this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void add(MatrixMxNrad m2) {
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m2.rows + "x" + m2.cols + ").");
        }
        Radical1 tmp = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.add(this.values[this.roTrick + this.dataBegin + r * this.colSkip + c], m2.get(r, c, tmp), this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void add(MatrixMxNrad m1, MatrixMxNrad m2) {
        if (this.rows != m1.rows || this.cols != m1.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m1.rows + "x" + m1.cols + ").");
        }
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m2:(" + m2.rows + "x" + m2.cols + ").");
        }
        Radical1 tmp1 = new Radical1();
        Radical1 tmp2 = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.add(m1.get(r, c, tmp1), m2.get(r, c, tmp2), this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void sub(float scalar) {
        this.add(-scalar);
    }

    public final void sub(MatrixMxNrad m2) {
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m2.rows + "x" + m2.cols + ").");
        }
        Radical1 tmp = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.sub(this.values[this.roTrick + this.dataBegin + r * this.colSkip + c], m2.get(r, c, tmp), this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void sub(MatrixMxNrad m1, MatrixMxNrad m2) {
        if (this.rows != m1.rows || this.cols != m1.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m1.rows + "x" + m1.cols + ").");
        }
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m2:(" + m2.rows + "x" + m2.cols + ").");
        }
        Radical1 tmp1 = new Radical1();
        Radical1 tmp2 = new Radical1();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.sub(m1.get(r, c, tmp1), m2.get(r, c, tmp2), this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public final void mul(float scalar) {
        Radical1 operand = new Radical1();
        operand.addTerm(new Rational(scalar), 1);
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Radical1.mul(this.values[this.roTrick + this.dataBegin + r * this.colSkip + c], operand, this.values[this.roTrick + this.dataBegin + r * this.colSkip + c]);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public void mul(MatrixMxNrad m1, MatrixMxNrad m2) {
        if (this.rows != m1.rows) {
            throw new ArrayIndexOutOfBoundsException("rows:" + this.rows + " != m1.rows:" + m1.rows);
        }
        if (this.cols != m2.cols) {
            throw new ArrayIndexOutOfBoundsException("cols:" + this.cols + " != m2.cols:" + m2.cols);
        }
        if (m1.cols != m2.rows) {
            throw new ArrayIndexOutOfBoundsException("m1.cols:" + m1.cols + " != m2.rows:" + m2.rows);
        }
        Radical1 tmp3 = new Radical1();
        MatrixMxNrad newData = new MatrixMxNrad(this.rows, this.cols);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                Radical1 sum = new Radical1();
                int k = 0;
                while (k < m1.cols) {
                    Radical1.mul(m1.getReference(i, k), m2.getReference(k, j), tmp3);
                    Radical1.add(sum, tmp3, sum);
                    ++k;
                }
                newData.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        this.set(newData);
        this.isDirty = true;
    }

    public void mul(MatrixMxNrad gmat) {
        this.mul(this, gmat);
        this.isDirty = true;
    }

    public void mul(TupleNrad<?> v1, TupleNrad<?> v2) {
        if (this.rows < v1.getSize()) {
            throw new IllegalArgumentException("rows:" + this.rows + " < v1.getSize():" + v1.getSize());
        }
        if (this.cols < v2.getSize()) {
            throw new IllegalArgumentException("cols:" + this.cols + " < v2.getSize():" + v2.getSize());
        }
        Radical1 tmp1 = new Radical1();
        Radical1 tmp2 = new Radical1();
        Radical1 tmp3 = new Radical1();
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.set(i, j, Radical1.mul(v1.get(i, tmp1), v2.get(j, tmp2), tmp3));
                ++j;
            }
            ++i;
        }
        this.isDirty = true;
    }

    public void mulTransposeBoth(MatrixMxNrad m1, MatrixMxNrad m2) {
        this.mul(m2, m1);
        this.transpose();
        this.isDirty = true;
    }

    public void mulTransposeLeft(MatrixMxNrad m1, MatrixMxNrad m2) {
        this.transpose(m1);
        this.mul(m2);
        this.isDirty = true;
    }

    public int hashCode() {
        Radical1 tmp = new Radical1();
        int hash = 0;
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                int bits = this.get(r, c, tmp).hashCode();
                hash ^= bits ^ bits >> 32;
                ++c;
            }
            ++r;
        }
        return hash;
    }

    public boolean equals(MatrixMxNrad mat2) {
        if (mat2 == null) {
            return false;
        }
        if (mat2.rows != this.rows) {
            return false;
        }
        if (mat2.cols != this.cols) {
            return false;
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (!this.getReference(i, j).equals(mat2.getReference(i, j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof MatrixMxNrad && this.equals((MatrixMxNrad)o);
    }

    public String toString() {
        Radical1 tmp = new Radical1();
        String nl = System.getProperty("line.separator");
        this.tmpSB.setLength(0);
        this.tmpSB.append("[");
        this.tmpSB.append(nl);
        int i = 0;
        while (i < this.rows) {
            this.tmpSB.append("  [");
            int j = 0;
            while (j < this.cols) {
                if (j > 0) {
                    this.tmpSB.append("\t");
                }
                this.tmpSB.append(this.get(i, j, tmp));
                ++j;
            }
            if (i + 1 < this.rows) {
                this.tmpSB.append("]");
                this.tmpSB.append(nl);
            } else {
                this.tmpSB.append("] ]");
            }
            ++i;
        }
        return this.tmpSB.toString();
    }

    public MatrixMxNrad clone() {
        MatrixMxNrad obj = new MatrixMxNrad(this.rows, this.cols);
        obj.set(this);
        return obj;
    }

    public MatrixMxNrad getSharedSubMatrix(boolean readOnly, int beginRow, int beginCol, int rows, int cols) {
        int begin = this.dataBegin + beginCol + beginRow * this.colSkip;
        return new MatrixMxNrad(readOnly, begin, this.colSkip, rows, cols, this.values);
    }

    public MatrixMxNrad getSharedSubMatrix(int beginRow, int beginCol, int rows, int cols) {
        return this.getSharedSubMatrix(false, beginRow, beginCol, rows, cols);
    }

    protected MatrixMxNrad(boolean readOnly, int rows, int cols) {
        if (rows < 0) {
            throw new NegativeArraySizeException(String.valueOf(rows) + " < 0");
        }
        if (cols < 0) {
            throw new NegativeArraySizeException(String.valueOf(cols) + " < 0");
        }
        this.rows = rows;
        this.cols = cols;
        this.values = new Radical1[rows * cols];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = new Radical1();
            ++i;
        }
        this.dataBegin = 0;
        this.colSkip = cols;
        this.setIdentity();
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected MatrixMxNrad(boolean readOnly, int rows, int cols, Radical1[] values) {
        if (rows < 0) {
            throw new NegativeArraySizeException(String.valueOf(rows) + " < 0");
        }
        if (cols < 0) {
            throw new NegativeArraySizeException(String.valueOf(cols) + " < 0");
        }
        this.rows = rows;
        this.cols = cols;
        this.values = new Radical1[rows * cols];
        int i = 0;
        while (i < values.length) {
            this.values[i] = values[i].clone();
            ++i;
        }
        this.dataBegin = 0;
        this.colSkip = cols;
        int size = rows * cols;
        System.arraycopy(values, 0, this.values, 0, size);
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected MatrixMxNrad(boolean readOnly, MatrixMxNrad matrix) {
        this.rows = matrix.rows;
        this.cols = matrix.cols;
        this.dataBegin = 0;
        this.colSkip = this.cols;
        this.values = new Radical1[this.rows * this.cols];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = new Radical1();
            ++i;
        }
        this.set(matrix);
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected MatrixMxNrad(boolean readOnly, int dataBegin, int colskip, int rows, int cols, Radical1[] values) {
        this.dataBegin = dataBegin;
        this.colSkip = colskip;
        this.cols = cols;
        this.rows = rows;
        this.values = values;
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    public MatrixMxNrad(int rows, int cols) {
        this(false, rows, cols);
    }

    public MatrixMxNrad(int rows, int cols, Radical1[] values) {
        this(false, rows, cols, values);
    }

    public MatrixMxNrad(MatrixMxNrad matrix) {
        this(false, matrix);
    }

    protected MatrixMxNrad(int dataBegin, int colskip, int rows, int cols, Radical1[] values) {
        this(false, dataBegin, colskip, rows, cols, values);
    }

    public static MatrixMxNrad newReadOnly(int rows, int cols) {
        return new MatrixMxNrad(true, rows, cols);
    }

    public static MatrixMxNrad newReadOnly(int rows, int cols, Radical1[] values) {
        return new MatrixMxNrad(true, rows, cols, values);
    }

    public static MatrixMxNrad newReadOnly(MatrixMxNrad matrix) {
        return new MatrixMxNrad(true, matrix);
    }

    public static MatrixMxNf sharedSubMatrixMxNrad(MatrixMxNf mat, int beginRow, int beginCol, int rows, int cols, boolean readOnly) {
        return mat.getSharedSubMatrix(readOnly, beginRow, beginCol, rows, cols);
    }

    public static MatrixMxNrad sharedSubMatrixMxNrad(MatrixMxNrad mat, int beginRow, int beginCol, int rows, int cols) {
        return mat.getSharedSubMatrix(beginRow, beginCol, rows, cols);
    }
}

