/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.FastMath;
import org.openmali.spatial.bodies.BodyInterface;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Body
implements BodyInterface {
    protected float centerX;
    protected float centerY;
    protected float centerZ;
    protected float maxCenterDist;
    protected float maxCenterDistSquared;
    protected boolean distComputed = false;

    public void setCenter(float x, float y, float z) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
    }

    public final void setCenter(Tuple3f center) {
        this.setCenter(center.getX(), center.getY(), center.getZ());
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final float getCenterZ() {
        return this.centerZ;
    }

    public final <T extends Tuple3f> T getCenter(T center) {
        center.set(this.centerX, this.centerY, this.centerZ);
        return center;
    }

    protected void setMaxCenterDistanceSquared(float maxCenterDistSquared) {
        this.maxCenterDistSquared = maxCenterDistSquared;
        this.distComputed = false;
    }

    public final float getMaxCenterDistanceSquared() {
        return this.maxCenterDistSquared;
    }

    public final float getMaxCenterDistance() {
        if (!this.distComputed) {
            this.maxCenterDist = FastMath.sqrt(this.maxCenterDistSquared);
            this.distComputed = true;
        }
        return this.maxCenterDist;
    }
}

