/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import java.io.Serializable;
import org.openmali.FastMath;
import org.openmali.spatial.bodies.Body;
import org.openmali.spatial.bodies.BodyInterface;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.ConvexHull;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;

public class Sphere
extends Body
implements Serializable {
    private static final long serialVersionUID = 5096988865873236385L;
    private final Point3f center2 = new Point3f();

    public final Point3f getCenter() {
        this.center2.set(this.centerX, this.centerY, this.centerZ);
        return this.center2;
    }

    public void setRadius(float radius) {
        this.maxCenterDist = radius;
        this.maxCenterDistSquared = radius * radius;
        this.distComputed = true;
    }

    public final float getRadius() {
        return this.getMaxCenterDistance();
    }

    public final float getRadiusSquared() {
        return this.getMaxCenterDistanceSquared();
    }

    public boolean containsXYPlus(float px, float py, float distance) {
        float dy;
        float dx = px - this.getCenterX();
        float dist = FastMath.sqrt(dx * dx + (dy = py - this.getCenterY()) * dy);
        return dist < this.getRadius() + distance;
    }

    public boolean containsPlus(float px, float py, float pz, float distance) {
        float dz;
        float dy;
        float dx = px - this.getCenterX();
        float dist = FastMath.sqrt(dx * dx + (dy = py - this.getCenterY()) * dy + (dz = pz - this.getCenterZ()) * dz);
        return dist < this.getRadius() + distance;
    }

    public boolean contains(float px, float py, float pz) {
        return Classifier.classifySpherePoint(this, px, py, pz) == Classifier.Classification.INSIDE;
    }

    public boolean contains(Point3f point) {
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    private void combineWithSphere(float xx, float yy, float zz, float rr) {
        float dx = xx - this.getCenterX();
        float dy = yy - this.getCenterY();
        float dz = zz - this.getCenterZ();
        float d = FastMath.sqrt(dx * dx + dy * dy + dz * dz);
        if (this.getRadius() >= d + rr) {
            return;
        }
        if (rr >= d + this.getRadius()) {
            this.setCenter(xx, yy, zz);
            this.setRadius(rr);
            return;
        }
        float dl = FastMath.sqrt(dx * dx + dy * dy + dz * dz);
        float d2 = (d + this.getRadius() + rr) / 2.0f - this.getRadius();
        float dx2 = dx / dl * d2;
        float dy2 = dy / dl * d2;
        float dz2 = dz / dl * d2;
        this.setCenter(this.getCenterX() + dx2, this.getCenterY() + dy2, this.getCenterZ() + dz2);
        float dia = this.getRadius() + d + rr;
        this.setRadius(dia / 2.0f);
    }

    private void combineWithSphere(Sphere sphere) {
        this.combineWithSphere(sphere.getCenterX(), sphere.getCenterY(), sphere.getCenterZ(), sphere.getRadius());
    }

    private void combineWithPoint(float px, float py, float pz) {
        this.combineWithSphere(px, py, pz, 0.0f);
    }

    private void combineWithPoint(Tuple3f p) {
        this.combineWithPoint(p.getX(), p.getY(), p.getZ());
    }

    private void combineWithBox(Box box) {
        this.combineWithPoint(box.getLower());
        this.combineWithPoint(box.getUpper());
    }

    public void combine(BodyInterface body) {
        if (body instanceof Sphere) {
            this.combineWithSphere((Sphere)body);
        } else if (body instanceof Box) {
            this.combineWithBox((Box)body);
        } else {
            if (body instanceof ConvexHull) {
                throw new Error("ConvexHull not supported yet");
            }
            throw new Error("unknown Body type");
        }
    }

    public void combine(BodyInterface[] bos) {
        int i = 0;
        while (i < bos.length) {
            this.combine(bos[i]);
            ++i;
        }
    }

    public void combine(float px, float py, float pz) {
        this.combineWithPoint(px, py, pz);
    }

    public void combine(Point3f point) {
        this.combine(point.getX(), point.getY(), point.getZ());
    }

    public void combine(Point3f[] points) {
        int i = 0;
        while (i < points.length) {
            this.combine(points[i]);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { center: " + this.getCenter() + ", radius: " + this.getRadius() + " }";
    }

    public Sphere(float x, float y, float z, float radius) {
        this.setCenter(x, y, z);
        this.maxCenterDist = radius;
        this.maxCenterDistSquared = radius * radius;
        this.distComputed = true;
    }

    public Sphere(Tuple3f center, float radius) {
        this(center.getX(), center.getY(), center.getZ(), radius);
    }

    public Sphere() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

