/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.polygons;

import org.openmali.spatial.polygons.Polygon;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class Triangle
extends Polygon {
    private Point3f coordA = null;
    private Point3f coordB = null;
    private Point3f coordC = null;
    private Vector3f normalA = null;
    private Vector3f normalB = null;
    private Vector3f normalC = null;
    private Colorf colorA = null;
    private Colorf colorB = null;
    private Colorf colorC = null;
    private TexCoord2f texCoordA = null;
    private TexCoord2f texCoordB = null;
    private TexCoord2f texCoordC = null;
    private Vector3f faceNormal = null;
    private int vertexIndexA = -1;
    private int vertexIndexB = -1;
    private int vertexIndexC = -1;

    public void setFeatures(int features) {
        super.setFeatures(features);
        if (this.hasFeature(1)) {
            if (this.coordA == null) {
                this.coordA = new Point3f();
            }
            if (this.coordB == null) {
                this.coordB = new Point3f();
            }
            if (this.coordC == null) {
                this.coordC = new Point3f();
            }
        }
        if (this.hasFeature(2)) {
            if (this.normalA == null) {
                this.normalA = new Vector3f();
            }
            if (this.normalB == null) {
                this.normalB = new Vector3f();
            }
            if (this.normalC == null) {
                this.normalC = new Vector3f();
            }
        }
        if (this.hasFeature(4)) {
            if (this.colorA == null) {
                this.colorA = new Colorf();
            }
            if (this.colorB == null) {
                this.colorB = new Colorf();
            }
            if (this.colorC == null) {
                this.colorC = new Colorf();
            }
        }
        if (this.hasFeature(8)) {
            if (this.texCoordA == null) {
                this.texCoordA = new TexCoord2f();
            }
            if (this.texCoordB == null) {
                this.texCoordB = new TexCoord2f();
            }
            if (this.texCoordC == null) {
                this.texCoordC = new TexCoord2f();
            }
        }
    }

    public void addFeature(int feature) {
        super.addFeature(feature);
        if ((feature & 1) != 0) {
            if (this.coordA == null) {
                this.coordA = new Point3f();
            }
            if (this.coordB == null) {
                this.coordB = new Point3f();
            }
            if (this.coordC == null) {
                this.coordC = new Point3f();
            }
        }
        if ((feature & 2) != 0) {
            if (this.normalA == null) {
                this.normalA = new Vector3f();
            }
            if (this.normalB == null) {
                this.normalB = new Vector3f();
            }
            if (this.normalC == null) {
                this.normalC = new Vector3f();
            }
        }
        if ((feature & 4) != 0) {
            if (this.colorA == null) {
                this.colorA = new Colorf();
            }
            if (this.colorB == null) {
                this.colorB = new Colorf();
            }
            if (this.colorC == null) {
                this.colorC = new Colorf();
            }
        }
        if ((feature & 8) != 0) {
            if (this.texCoordA == null) {
                this.texCoordA = new TexCoord2f();
            }
            if (this.texCoordB == null) {
                this.texCoordB = new TexCoord2f();
            }
            if (this.texCoordC == null) {
                this.texCoordC = new TexCoord2f();
            }
        }
    }

    public void setVertexCoordA(Tuple3f coord) {
        this.addFeature(1);
        this.coordA.set((TupleNf)coord);
    }

    public void setVertexCoordB(Tuple3f coord) {
        this.addFeature(1);
        this.coordB.set((TupleNf)coord);
    }

    public void setVertexCoordC(Tuple3f coord) {
        this.addFeature(1);
        this.coordC.set((TupleNf)coord);
    }

    public void getVertexCoordA(Tuple3f coord) {
        coord.set((TupleNf)this.coordA);
    }

    public Point3f getVertexCoordA() {
        return this.coordA;
    }

    public void getVertexCoordB(Tuple3f coord) {
        coord.set((TupleNf)this.coordB);
    }

    public Point3f getVertexCoordB() {
        return this.coordB;
    }

    public void getVertexCoordC(Tuple3f coord) {
        coord.set((TupleNf)this.coordC);
    }

    public Point3f getVertexCoordC() {
        return this.coordC;
    }

    public void setVertexCoords(Tuple3f coordA, Tuple3f coordB, Tuple3f coordC) {
        this.setVertexCoordA(coordA);
        this.setVertexCoordB(coordB);
        this.setVertexCoordC(coordC);
    }

    public void getVertexCoords(Tuple3f coordA, Tuple3f coordB, Tuple3f coordC) {
        this.getVertexCoordA(coordA);
        this.getVertexCoordB(coordB);
        this.getVertexCoordC(coordC);
    }

    public void setVertexNormalA(Vector3f normal) {
        this.addFeature(2);
        this.normalA.set((TupleNf)normal);
    }

    public void setVertexNormalB(Vector3f normal) {
        this.addFeature(2);
        this.normalB.set((TupleNf)normal);
    }

    public void setVertexNormalC(Vector3f normal) {
        this.addFeature(2);
        this.normalC.set((TupleNf)normal);
    }

    public void getVertexNormalA(Vector3f normal) {
        normal.set((TupleNf)this.normalA);
    }

    public Vector3f getVertexNormalA() {
        return this.normalA;
    }

    public void getVertexNormalB(Vector3f normal) {
        normal.set((TupleNf)this.normalB);
    }

    public Vector3f getVertexNormalB() {
        return this.normalB;
    }

    public void getVertexNormalC(Vector3f normal) {
        normal.set((TupleNf)this.normalC);
    }

    public Vector3f getVertexNormalC() {
        return this.normalC;
    }

    public void setVertexNormals(Vector3f normalA, Vector3f normalB, Vector3f normalC) {
        this.setVertexNormalA(normalA);
        this.setVertexNormalB(normalB);
        this.setVertexNormalC(normalC);
    }

    public void getVertexNormals(Vector3f normalA, Vector3f normalB, Vector3f normalC) {
        this.getVertexNormalA(normalA);
        this.getVertexNormalB(normalB);
        this.getVertexNormalC(normalC);
    }

    public void setVertexColorA(Colorf color) {
        this.addFeature(4);
        this.colorA.set(color);
    }

    public void setVertexColorB(Colorf color) {
        this.addFeature(4);
        this.colorB.set(color);
    }

    public void setVertexColorC(Colorf color) {
        this.addFeature(4);
        this.colorC.set(color);
    }

    public void getVertexColorA(Colorf color) {
        color.set(this.colorA);
    }

    public Colorf getVertexColorA() {
        return this.colorA;
    }

    public void getVertexColorB(Colorf color) {
        color.set(this.colorB);
    }

    public Colorf getVertexColorB() {
        return this.colorB;
    }

    public void getVertexColorC(Colorf color) {
        color.set(this.colorC);
    }

    public Colorf getVertexColorC() {
        return this.colorC;
    }

    public void setVertexColors(Colorf colorA, Colorf colorB, Colorf colorC) {
        this.setVertexColorA(colorA);
        this.setVertexColorB(colorB);
        this.setVertexColorC(colorC);
    }

    public void getVertexColors(Colorf colorA, Colorf colorB, Colorf colorC) {
        this.getVertexColorA(colorA);
        this.getVertexColorB(colorB);
        this.getVertexColorC(colorC);
    }

    public void setVertexTexCoordA(TexCoord2f texCoord) {
        this.addFeature(8);
        this.setTexCoordsSize(2);
        this.texCoordA.set(texCoord);
    }

    public void setVertexTexCoordB(TexCoord2f texCoord) {
        this.addFeature(8);
        this.setTexCoordsSize(2);
        this.texCoordB.set(texCoord);
    }

    public void setVertexTexCoordC(TexCoord2f texCoord) {
        this.addFeature(8);
        this.setTexCoordsSize(2);
        this.texCoordC.set(texCoord);
    }

    public void getVertexTexCoordA(TexCoord2f texCoord) {
        texCoord.set(this.texCoordA);
    }

    public TexCoord2f getVertexTexCoordA() {
        return this.texCoordA;
    }

    public void getVertexTexCoordB(TexCoord2f texCoord) {
        texCoord.set(this.texCoordB);
    }

    public TexCoord2f getVertexTexCoordB() {
        return this.texCoordB;
    }

    public void getVertexTexCoordC(TexCoord2f texCoord) {
        texCoord.set(this.texCoordC);
    }

    public TexCoord2f getVertexTexCoordC() {
        return this.texCoordC;
    }

    public void setVertexTexCoords(TexCoord2f texCoordA, TexCoord2f texCoordB, TexCoord2f texCoordC) {
        this.setVertexTexCoordA(texCoordA);
        this.setVertexTexCoordB(texCoordB);
        this.setVertexTexCoordC(texCoordC);
    }

    public void getVertexTexCoords(TexCoord2f texCoordA, TexCoord2f texCoordB, TexCoord2f texCoordC) {
        this.getVertexTexCoordA(texCoordA);
        this.getVertexTexCoordB(texCoordB);
        this.getVertexTexCoordC(texCoordC);
    }

    public void setVertexA(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord == null) {
            this.removeFeature(1);
        } else {
            this.setVertexCoordA(coord);
        }
        if (normal == null) {
            this.removeFeature(2);
        } else {
            this.setVertexNormalA(normal);
        }
        if (color == null) {
            this.removeFeature(4);
        } else {
            this.setVertexColorA(color);
        }
        if (texCoord == null) {
            this.removeFeature(8);
        } else {
            this.setVertexTexCoordA(texCoord);
        }
    }

    public void getVertexA(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord != null && this.hasFeature(1)) {
            this.getVertexCoordA(coord);
        }
        if (normal != null && this.hasFeature(2)) {
            this.getVertexNormalA(normal);
        }
        if (color != null && this.hasFeature(4)) {
            this.getVertexColorA(color);
        }
        if (texCoord != null && this.hasFeature(8) && this.getTexCoordsSize() == 2) {
            this.getVertexTexCoordA(texCoord);
        }
    }

    public void setVertexB(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord == null) {
            this.removeFeature(1);
        } else {
            this.setVertexCoordB(coord);
        }
        if (normal == null) {
            this.removeFeature(2);
        } else {
            this.setVertexNormalB(normal);
        }
        if (color == null) {
            this.removeFeature(4);
        } else {
            this.setVertexColorB(color);
        }
        if (texCoord == null) {
            this.removeFeature(8);
        } else {
            this.setVertexTexCoordB(texCoord);
        }
    }

    public void getVertexB(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord != null && this.hasFeature(1)) {
            this.getVertexCoordB(coord);
        }
        if (normal != null && this.hasFeature(2)) {
            this.getVertexNormalB(normal);
        }
        if (color != null && this.hasFeature(4)) {
            this.getVertexColorB(color);
        }
        if (texCoord != null && this.hasFeature(8) && this.getTexCoordsSize() == 2) {
            this.getVertexTexCoordB(texCoord);
        }
    }

    public void setVertexC(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord == null) {
            this.removeFeature(1);
        } else {
            this.setVertexCoordC(coord);
        }
        if (normal == null) {
            this.removeFeature(2);
        } else {
            this.setVertexNormalC(normal);
        }
        if (color == null) {
            this.removeFeature(4);
        } else {
            this.setVertexColorC(color);
        }
        if (texCoord == null) {
            this.removeFeature(8);
        } else {
            this.setVertexTexCoordC(texCoord);
        }
    }

    public void getVertexC(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        if (coord != null && this.hasFeature(1)) {
            this.getVertexCoordC(coord);
        }
        if (normal != null && this.hasFeature(2)) {
            this.getVertexNormalC(normal);
        }
        if (color != null && this.hasFeature(4)) {
            this.getVertexColorC(color);
        }
        if (texCoord != null && this.hasFeature(8) && this.getTexCoordsSize() == 2) {
            this.getVertexTexCoordC(texCoord);
        }
    }

    public float getAngleA() {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordC(), this.getVertexCoordA());
        tmpVec2.sub(this.getVertexCoordB(), this.getVertexCoordA());
        float angle = tmpVec1.angle(tmpVec2);
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
        return angle;
    }

    public float getAngleB() {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordA(), this.getVertexCoordB());
        tmpVec2.sub(this.getVertexCoordC(), this.getVertexCoordB());
        float angle = tmpVec1.angle(tmpVec2);
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
        return angle;
    }

    public float getAngleC() {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordB(), this.getVertexCoordC());
        tmpVec2.sub(this.getVertexCoordA(), this.getVertexCoordC());
        float angle = tmpVec1.angle(tmpVec2);
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
        return angle;
    }

    public void getFaceNormalACAB(Vector3f faceNormal) {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordC(), this.getVertexCoordA());
        tmpVec2.sub(this.getVertexCoordB(), this.getVertexCoordA());
        faceNormal.cross(tmpVec1, tmpVec2);
        faceNormal.normalize();
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
    }

    public Vector3f getFaceNormalACAB() {
        this.getFaceNormalACAB(this.faceNormal);
        return this.faceNormal;
    }

    public void getFaceNormalBABC(Vector3f faceNormal) {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordA(), this.getVertexCoordB());
        tmpVec2.sub(this.getVertexCoordC(), this.getVertexCoordB());
        faceNormal.cross(tmpVec1, tmpVec2);
        faceNormal.normalize();
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
    }

    public Vector3f getFaceNormalBABC() {
        this.getFaceNormalBABC(this.faceNormal);
        return this.faceNormal;
    }

    public void getFaceNormalCBCA(Vector3f faceNormal) {
        Vector3f tmpVec1 = Vector3f.fromPool();
        Vector3f tmpVec2 = Vector3f.fromPool();
        tmpVec1.sub(this.getVertexCoordB(), this.getVertexCoordC());
        tmpVec2.sub(this.getVertexCoordA(), this.getVertexCoordC());
        faceNormal.cross(tmpVec1, tmpVec2);
        faceNormal.normalize();
        Vector3f.toPool(tmpVec2);
        Vector3f.toPool(tmpVec1);
    }

    public Vector3f getFaceNormalCBCA() {
        this.getFaceNormalCBCA(this.faceNormal);
        return this.faceNormal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getFaceNormal(Vector3f faceNormal) {
        if (!this.hasFeature(2)) {
            throw new NullPointerException("You need vertex normals to calculate the face normal");
        }
        Vector3f tmpVec4 = Vector3f.fromPool();
        Vector3f tmpVec5 = Vector3f.fromPool();
        Vector3f tmpVec6 = Vector3f.fromPool();
        try {
            this.getFaceNormalACAB(tmpVec4);
            if (this.getVertexNormalA() != null && tmpVec4.angle(this.getVertexNormalA()) > 1.5707964f) {
                tmpVec4.scale(-1.0f);
            }
            this.getFaceNormalBABC(tmpVec5);
            if (this.getVertexNormalB() != null && tmpVec5.angle(this.getVertexNormalB()) > 1.5707964f) {
                tmpVec5.scale(-1.0f);
            }
            this.getFaceNormalCBCA(tmpVec6);
            if (this.getVertexNormalC() != null && tmpVec6.angle(this.getVertexNormalC()) > 1.5707964f) {
                tmpVec6.scale(-1.0f);
            }
            float angleAB = tmpVec4.angle(tmpVec5);
            float angleAC = tmpVec4.angle(tmpVec6);
            if (angleAB > 0.001f && angleAC > 0.001f) {
                faceNormal.set((TupleNf)tmpVec5);
                return;
            }
            float angleBC = tmpVec5.angle(tmpVec6);
            if (angleBC > 0.001f && angleAB > 0.001f) {
                faceNormal.set((TupleNf)tmpVec6);
                return;
            }
            if (angleBC > 0.001f && angleAC > 0.001f) {
                faceNormal.set((TupleNf)tmpVec4);
                return;
            }
            faceNormal.set((TupleNf)tmpVec4);
            return;
        }
        finally {
            Vector3f.toPool(tmpVec6);
            Vector3f.toPool(tmpVec5);
            Vector3f.toPool(tmpVec4);
        }
    }

    public Vector3f getFaceNormal() {
        if (this.faceNormal == null) {
            this.faceNormal = new Vector3f();
        }
        this.getFaceNormal(this.faceNormal);
        return this.faceNormal;
    }

    public void setVertexIndexA(int index) {
        this.vertexIndexA = index;
    }

    public int getVertexIndexA() {
        return this.vertexIndexA;
    }

    public void setVertexIndexB(int index) {
        this.vertexIndexB = index;
    }

    public int getVertexIndexB() {
        return this.vertexIndexB;
    }

    public void setVertexIndexC(int index) {
        this.vertexIndexC = index;
    }

    public int getVertexIndexC() {
        return this.vertexIndexC;
    }

    public void setVertexIndices(int indexA, int indexB, int indexC) {
        this.setVertexIndexA(indexA);
        this.setVertexIndexB(indexB);
        this.setVertexIndexC(indexC);
    }

    public int sign3D(Tuple3f a, Tuple3f b, Tuple3f c, Tuple3f d) {
        Matrix3f tmpMat = Matrix3f.fromPool();
        tmpMat.setRow(0, a.getX() - d.getX(), a.getY() - d.getY(), a.getZ() - d.getZ());
        tmpMat.setRow(1, b.getX() - d.getX(), b.getY() - d.getY(), b.getZ() - d.getZ());
        tmpMat.setRow(2, c.getX() - d.getX(), c.getY() - d.getY(), c.getZ() - d.getZ());
        float det = tmpMat.determinant();
        float EPSILON = 1.0E-5f;
        Matrix3f.toPool(tmpMat);
        if (det > 1.0E-5f) {
            return 1;
        }
        if (det < -1.0E-5f) {
            return -1;
        }
        return 0;
    }

    public boolean quickIntersectionTest(Ray3f pickRay) {
        Point3f tmpPnt = Point3f.fromPool();
        tmpPnt.scaleAdd(100000.0f, pickRay.getDirection(), pickRay.getOrigin());
        int i = this.sign3D(tmpPnt, this.coordA, pickRay.getOrigin(), this.coordB);
        int j = this.sign3D(tmpPnt, this.coordC, this.coordB, pickRay.getOrigin());
        int k = this.sign3D(tmpPnt, this.coordA, this.coordC, pickRay.getOrigin());
        Point3f.toPool(tmpPnt);
        if (i == 0 && j == 0) {
            return true;
        }
        if (i == 0 && k == 0) {
            return true;
        }
        if (j == 0 && k == 0) {
            return true;
        }
        if (i == 0 && j == k) {
            return true;
        }
        if (j == 0 && i == k) {
            return true;
        }
        if (k == 0 && j == i) {
            return true;
        }
        return i == j && j == k;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float intersects(Point3f rayOrigin, Vector3f rayDirection) {
        Vector3f e1 = Vector3f.fromPool();
        Vector3f e2 = Vector3f.fromPool();
        Vector3f p = Vector3f.fromPool();
        Vector3f q = Vector3f.fromPool();
        Vector3f s = Vector3f.fromPool();
        try {
            e1.sub(this.coordB, this.coordA);
            e2.sub(this.coordC, this.coordA);
            p.cross(rayDirection, e2);
            float a = e1.dot(p);
            if (-1.0E-5f < a && a < 1.0E-5f) {
                return -1.0f;
            }
            float f = 1.0f / a;
            s.sub(rayOrigin, this.coordA);
            float u = f * s.dot(p);
            if (0.0f > u) return -1.0f;
            if (u > 1.0f) {
                return -1.0f;
            }
            q.cross(s, e1);
            float v = f * rayDirection.dot(q);
            if (0.0f > u) return -1.0f;
            if (u + v > 1.0f) {
                return -1.0f;
            }
            float l = f * e2.dot(q);
            if (l < 0.0f) {
                return -1.0f;
            }
            float f2 = l * l;
            return f2;
        }
        finally {
            Vector3f.toPool(s);
            Vector3f.toPool(q);
            Vector3f.toPool(p);
            Vector3f.toPool(e2);
            Vector3f.toPool(e1);
        }
    }

    public float intersects(Ray3f ray) {
        return this.intersects(ray.getOrigin(), ray.getDirection());
    }

    public float intersects(Ray3f ray, float nearestDist) {
        if (this.quickIntersectionTest(ray)) {
            return this.intersects(ray);
        }
        return -1.0f;
    }

    public Triangle(int features, int texCoordsSize) {
        super(features, texCoordsSize);
        this.setFeatures(this.getFeatures());
        this.setTexCoordsSize(this.getTexCoordsSize());
    }

    public Triangle() {
        this(1, 2);
    }
}

