/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.quadtree;

import org.openmali.spatial.AxisIndicator;
import org.openmali.spatial.PlaneIndicator;
import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.quadtree.QuadCell;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree<T extends SpatialNode> {
    public static final PlaneIndicator DEFAULT_PLANE = PlaneIndicator.X_Z_PLANE;
    private final QuadCell<T> rootCell;
    private int minNodesBeforeSplit = 4;
    private int maxLevelForExtendedCells = 0;
    private int maxLevel = 0;

    public final PlaneIndicator getPlane() {
        return this.rootCell.getPlane();
    }

    public final AxisIndicator getUpAxis() {
        return this.rootCell.getUpAxis();
    }

    public final QuadCell<T> getRootCell() {
        return this.rootCell;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final float getCenterX() {
        return this.rootCell.getCenterX();
    }

    public final float getCenterY() {
        return this.rootCell.getCenterY();
    }

    public final float getCenterZ() {
        return this.rootCell.getCenterZ();
    }

    public final float getWidth() {
        return this.rootCell.getWidth();
    }

    public final float getDepth() {
        return this.rootCell.getDepth();
    }

    public void setMinNodesBeforeSplit(int minNodesBeforeSplit) {
        this.minNodesBeforeSplit = minNodesBeforeSplit;
    }

    public final int getMinNodesBeforeSplit() {
        return this.minNodesBeforeSplit;
    }

    public void setMaxLevelForExtendedCells(int maxLevelForExtendedCells) {
        this.maxLevelForExtendedCells = maxLevelForExtendedCells;
    }

    public final int getMaxLevelForExtendedCells() {
        return this.maxLevelForExtendedCells;
    }

    public final int insertNode(T node) {
        int level = this.rootCell.insertNode(node, this.getMinNodesBeforeSplit(), this.getMaxLevelForExtendedCells());
        if (level > this.maxLevel) {
            this.maxLevel = level;
        }
        return level;
    }

    public final void removeNode(T node) {
        this.rootCell.removeNode(node);
    }

    public final void clear() {
        this.rootCell.clear();
    }

    public final void updateNodePosition(T node) {
        if (this.rootCell.removeNode(node)) {
            this.insertNode(node);
        }
    }

    public void dump() {
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + " ( max-level: " + this.getMaxLevel() + " )");
        this.rootCell.dump();
    }

    public QuadTree(float centerX, float centerY, float centerZ, PlaneIndicator plane, float width, float depth, float height, boolean useExtendedCells) {
        this.rootCell = new QuadCell(0, centerX, centerY, centerZ, plane, width, depth, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, PlaneIndicator plane, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), plane, width, depth, height, useExtendedCells);
    }

    public QuadTree(float centerX, float centerY, float centerZ, PlaneIndicator plane, float size, float height, boolean useExtendedCells) {
        this.rootCell = new QuadCell(0, centerX, centerY, centerZ, plane, size, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, PlaneIndicator plane, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), plane, size, height, useExtendedCells);
    }

    private static final PlaneIndicator getPlane(AxisIndicator upAxis) {
        switch (upAxis) {
            case POSITIVE_Y_AXIS: {
                return PlaneIndicator.X_Z_PLANE;
            }
            case POSITIVE_Z_AXIS: {
                return PlaneIndicator.X_Y_PLANE;
            }
            case NEGATIVE_X_AXIS: {
                return PlaneIndicator.Z_Y_PLANE;
            }
        }
        throw new IllegalArgumentException("upAxis");
    }

    public QuadTree(float centerX, float centerY, float centerZ, AxisIndicator upAxis, float width, float depth, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, QuadTree.getPlane(upAxis), width, depth, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, AxisIndicator upAxis, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), upAxis, width, depth, height, useExtendedCells);
    }

    public QuadTree(float centerX, float centerY, float centerZ, AxisIndicator upAxis, float size, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, QuadTree.getPlane(upAxis), size, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, AxisIndicator upAxis, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), upAxis, size, height, useExtendedCells);
    }

    public QuadTree(float centerX, float centerY, float centerZ, float width, float depth, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, DEFAULT_PLANE, width, depth, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), width, depth, height, useExtendedCells);
    }

    public QuadTree(float centerX, float centerY, float centerZ, float size, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, DEFAULT_PLANE, size, height, useExtendedCells);
    }

    public QuadTree(Tuple3f center, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), size, height, useExtendedCells);
    }
}

