/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.twodee;

import org.openmali.types.twodee.Dim2fPool;
import org.openmali.types.twodee.Sized2f;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.vecmath2.Tuple2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dim2f
implements Sized2f {
    private static final Dim2fPool POOL = new Dim2fPool();
    private float width;
    private float height;
    protected boolean isDirty = true;

    public final boolean isDirty() {
        return this.isDirty;
    }

    public void setClean() {
        this.isDirty = false;
    }

    @Override
    public Dim2f setSize(float width, float height) {
        if (width == this.width && height == this.height) {
            return this;
        }
        this.width = width;
        this.height = height;
        this.isDirty = true;
        return this;
    }

    @Override
    public final void setWidth(float width) {
        this.setSize(width, this.height);
    }

    @Override
    public final void setHeight(float height) {
        this.setSize(this.width, height);
    }

    @Override
    public final float getWidth() {
        return this.width;
    }

    @Override
    public final float getHeight() {
        return this.height;
    }

    @Override
    public final float getAspect() {
        if (this.getHeight() != 0.0f) {
            return this.getWidth() / this.getHeight();
        }
        return 0.0f;
    }

    @Override
    public final Dim2f setSize(Sized2fRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public final Dim2f setSize(Tuple2f size) {
        return this.setSize(size.getX(), size.getY());
    }

    public <T extends Tuple2f> T toTuple(T tuple) {
        tuple.set(this.getWidth(), this.getHeight());
        return tuple;
    }

    public Tuple2f toTuple() {
        return new Tuple2f(this.width, this.height);
    }

    public final Dim2f set(float width, float height) {
        return this.setSize(width, height);
    }

    public final Dim2f set(Sized2fRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    public final Dim2f add(float dw, float dh) {
        this.width += dw;
        this.height += dh;
        return this;
    }

    public final Dim2f addW(float dw) {
        this.width += dw;
        return this;
    }

    public final Dim2f addH(float dh) {
        this.height += dh;
        return this;
    }

    public final Dim2f scale(float factW, float factH) {
        this.width *= factW;
        this.height *= factH;
        return this;
    }

    public final Dim2f scaleW(float factW) {
        this.width *= factW;
        return this;
    }

    public final Dim2f scaleH(float factH) {
        this.height *= factH;
        return this;
    }

    public boolean equals(Sized2fRO rect) {
        if (rect == null) {
            return false;
        }
        if (rect == this) {
            return true;
        }
        return rect.getWidth() == this.getWidth() && rect.getHeight() == this.getHeight();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Sized2fRO)) {
            return false;
        }
        return this.equals((Sized2fRO)o);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "( width = " + this.getWidth() + ", height = " + this.getHeight() + ", aspect = " + this.getAspect() + " )";
    }

    public Dim2f(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public Dim2f(Sized2fRO template) {
        this(template.getWidth(), template.getHeight());
    }

    public Dim2f() {
        this(0.0f, 0.0f);
    }

    public static final Dim2f fromPool() {
        return (Dim2f)POOL.alloc();
    }

    public static final Dim2f fromPool(int width, int height) {
        Dim2f inst = (Dim2f)POOL.alloc();
        inst.set(width, height);
        return inst;
    }

    public static final void toPool(Dim2f dim) {
        POOL.free(dim);
    }
}

