/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.twodee;

import org.openmali.types.twodee.Dim2iPool;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Tuple2i;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dim2i
implements Sized2i {
    private static final Dim2iPool POOL = new Dim2iPool();
    private int width;
    private int height;
    protected boolean isDirty = true;

    public final boolean isDirty() {
        return this.isDirty;
    }

    public void setClean() {
        this.isDirty = false;
    }

    @Override
    public Dim2i setSize(int width, int height) {
        if (width == this.width && height == this.height) {
            return this;
        }
        this.width = width;
        this.height = height;
        this.isDirty = true;
        return this;
    }

    @Override
    public final void setWidth(int width) {
        this.setSize(width, this.height);
    }

    @Override
    public final void setHeight(int height) {
        this.setSize(this.width, height);
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final float getAspect() {
        if (this.getHeight() != 0) {
            return (float)this.getWidth() / (float)this.getHeight();
        }
        return 0.0f;
    }

    @Override
    public final Dim2i setSize(Sized2iRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public final Dim2i setSize(Tuple2i size) {
        return this.setSize(size.getX(), size.getY());
    }

    public <T extends Tuple2i> T toTuple(T tuple) {
        tuple.set(this.getWidth(), this.getHeight());
        return tuple;
    }

    public Tuple2i toTuple() {
        return new Tuple2i(this.width, this.height);
    }

    public final Dim2i set(int width, int height) {
        return this.setSize(width, height);
    }

    public final Dim2i set(Sized2iRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    public final Dim2i add(int dw, int dh) {
        this.width += dw;
        this.height += dh;
        return this;
    }

    public final Dim2i addW(int dw) {
        this.width += dw;
        return this;
    }

    public final Dim2i addH(int dh) {
        this.height += dh;
        return this;
    }

    public final Dim2i scale(int factW, int factH) {
        this.width *= factW;
        this.height *= factH;
        return this;
    }

    public final Dim2i scaleW(int factW) {
        this.width *= factW;
        return this;
    }

    public final Dim2i scaleH(int factH) {
        this.height *= factH;
        return this;
    }

    public boolean equals(Sized2iRO rect) {
        if (rect == null) {
            return false;
        }
        if (rect == this) {
            return true;
        }
        return rect.getWidth() == this.getWidth() && rect.getHeight() == this.getHeight();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Sized2iRO)) {
            return false;
        }
        return this.equals((Sized2iRO)o);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "( width = " + this.getWidth() + ", height = " + this.getHeight() + ", aspect = " + this.getAspect() + " )";
    }

    public Dim2i(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Dim2i(Sized2iRO template) {
        this(template.getWidth(), template.getHeight());
    }

    public Dim2i() {
        this(0, 0);
    }

    public static final Dim2i fromPool() {
        return (Dim2i)POOL.alloc();
    }

    public static final Dim2i fromPool(int width, int height) {
        Dim2i inst = (Dim2i)POOL.alloc();
        inst.set(width, height);
        return inst;
    }

    public static final void toPool(Dim2i dim) {
        POOL.free(dim);
    }
}

