/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.twodee;

import org.openmali.types.twodee.Positioned2i;
import org.openmali.types.twodee.Positioned2iRO;
import org.openmali.types.twodee.Rect2iPool;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Tuple2i;

public class Rect2i
implements Positioned2i,
Sized2i {
    private static final Rect2iPool POOL = new Rect2iPool();
    private int left;
    private int top;
    private int width;
    private int height;
    protected boolean isDirty = true;

    public final boolean isDirty() {
        return this.isDirty;
    }

    public void setClean() {
        this.isDirty = false;
    }

    public Rect2i setLocation(int left, int top) {
        if (left == this.left && top == this.top) {
            return this;
        }
        this.left = left;
        this.top = top;
        this.isDirty = true;
        return this;
    }

    public final Rect2i setLocation(Tuple2i upperLeft) {
        return this.setLocation(upperLeft.getX(), upperLeft.getY());
    }

    public final Tuple2i getLocation() {
        return new Tuple2i(this.left, this.top);
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public Rect2i setSize(int width, int height) {
        if (width == this.width && height == this.height) {
            return this;
        }
        this.width = width;
        this.height = height;
        this.isDirty = true;
        return this;
    }

    public final void setWidth(int width) {
        this.setSize(width, this.height);
    }

    public final void setHeight(int height) {
        this.setSize(this.width, height);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float getAspect() {
        if (this.getHeight() != 0) {
            return (float)this.getWidth() / (float)this.getHeight();
        }
        return 0.0f;
    }

    public final int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public final Rect2i setSize(Sized2iRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    public final Rect2i setSize(Tuple2i size) {
        return this.setSize(size.getX(), size.getY());
    }

    public final Rect2i set(int left, int top, int width, int height) {
        this.setLocation(left, top);
        this.setSize(width, height);
        return this;
    }

    public final Rect2i set(Positioned2iRO pos, Sized2iRO size) {
        this.setLocation(pos.getLeft(), pos.getTop());
        this.setSize(size.getWidth(), size.getHeight());
        return this;
    }

    public final Rect2i set(Rect2i rect) {
        this.setLocation(rect.getLeft(), rect.getTop());
        this.setSize(rect.getWidth(), rect.getHeight());
        return this;
    }

    public final boolean isCoveredBy(int left, int top, int width, int height) {
        return this.left >= left && this.left + this.width <= left + width && this.top >= top && this.top + this.height <= top + height;
    }

    public final boolean isCoveredBy(Rect2i rect) {
        return this.isCoveredBy(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public final boolean covers(int left, int top, int width, int height) {
        return left >= this.left && left + width <= this.left + this.width && top >= this.top && top + height <= this.top + this.height;
    }

    public final boolean covers(Rect2i rect) {
        return this.covers(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public final int getMatchFactor(int left, int top, int width, int height) {
        int l = Math.min(left, this.left);
        int t = Math.min(top, this.top);
        int w = Math.max(left + width, this.left + this.width) - l;
        int h = Math.max(top + height, this.top + this.height) - t;
        int a = w * h;
        return a - width * height;
    }

    public final int getMatchFactor(Rect2i rect) {
        return this.getMatchFactor(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public final boolean intersects(int left, int top, int width, int height) {
        if (this.left + this.width < left) {
            return false;
        }
        if (left + width < this.left) {
            return false;
        }
        if (this.top + this.height < top) {
            return false;
        }
        return top + height >= this.top;
    }

    public final boolean intersects(Rect2i rect) {
        return this.intersects(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public Rect2i combine(int left, int top, int width, int height) {
        int newLeft = Math.min(this.left, left);
        int newTop = Math.min(this.top, top);
        int newWidth = Math.max(this.left + this.width - newLeft, left + width - newLeft);
        int newHeight = Math.max(this.top + this.height - newTop, top + height - newTop);
        this.set(newLeft, newTop, newWidth, newHeight);
        return this;
    }

    public final Rect2i combine(Rect2i rect) {
        return this.combine(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public Rect2i clamp(int left, int top, int width, int height) {
        int clipX0 = this.left;
        int clipY0 = this.top;
        int clipX1 = clipX0 + this.width - 1;
        int clipY1 = clipY0 + this.height - 1;
        if (clipX0 < left) {
            clipX0 = left;
        }
        if (clipY0 < top) {
            clipY0 = top;
        }
        if (clipX1 < clipX0) {
            clipX1 = clipX0;
        }
        if (clipY1 < clipY0) {
            clipY1 = clipY0;
        }
        if (clipX1 > left + width - 1) {
            clipX1 = left + width - 1;
        }
        if (clipY1 > top + height - 1) {
            clipY1 = top + height - 1;
        }
        if (clipX0 > clipX1) {
            clipX0 = clipX1;
        }
        if (clipY0 > clipY1) {
            clipY0 = clipY1;
        }
        this.set(clipX0, clipY0, clipX1 - clipX0 + 1, clipY1 - clipY0 + 1);
        return this;
    }

    public final Rect2i clamp(Rect2i rect) {
        return this.clamp(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    public boolean equals(Rect2i rect) {
        if (rect == null) {
            return false;
        }
        if (rect == this) {
            return true;
        }
        return rect.getLeft() == this.getLeft() && rect.getTop() == this.getTop() && rect.getWidth() == this.getWidth() && rect.getHeight() == this.getHeight();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Rect2i)) {
            return false;
        }
        return this.equals((Rect2i)o);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "( left = " + this.getLeft() + ", top = " + this.getTop() + ", width = " + this.getWidth() + ", height = " + this.getHeight() + ", aspect = " + this.getAspect() + " )";
    }

    public Rect2i(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public Rect2i(Rect2i template) {
        this(template.getLeft(), template.getTop(), template.getWidth(), template.getHeight());
    }

    public Rect2i() {
        this(0, 0, 0, 0);
    }

    public static final Rect2i fromPool() {
        return (Rect2i)POOL.alloc();
    }

    public static final Rect2i fromPool(int left, int top, int width, int height) {
        Rect2i inst = (Rect2i)POOL.alloc();
        inst.set(left, top, width, height);
        return inst;
    }

    public static final void toPool(Rect2i rect) {
        POOL.free(rect);
    }
}

