/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.nio.FloatBuffer;
import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.MatrixMxNf;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.pools.Matrix3fPool;
import org.openmali.vecmath2.util.MatrixUtils;
import org.openmali.vecmath2.util.VecMathUtils;

public class Matrix3f
extends MatrixMxNf
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 7821487009107178638L;
    public static final Matrix3f ZERO = Matrix3f.newReadOnly(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = Matrix3f.newReadOnly(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public static final Matrix3f ROT_PLUS_90_DEG_BY_X_AXIS;
    public static final Matrix3f ROT_MINUS_90_DEG_BY_X_AXIS;
    public static final Matrix3f ROT_PLUS_90_DEG_BY_Y_AXIS;
    public static final Matrix3f ROT_MINUS_90_DEG_BY_Y_AXIS;
    public static final Matrix3f ROT_PLUS_90_DEG_BY_Z_AXIS;
    public static final Matrix3f ROT_MINUS_90_DEG_BY_Z_AXIS;
    public static final Matrix3f Z_UP_TO_Y_UP;
    private static final ThreadLocal<Matrix3fPool> POOL;
    private Matrix3f readOnlyInstance = null;
    protected static final int M = 3;
    protected static final int N = 3;

    static {
        Matrix3f tmp = MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_X_AXIS, 1.5707964f);
        ROT_PLUS_90_DEG_BY_X_AXIS = new Matrix3f(true, tmp);
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_X_AXIS, -1.5707964f, tmp);
        ROT_MINUS_90_DEG_BY_X_AXIS = new Matrix3f(true, tmp);
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_Y_AXIS, 1.5707964f, tmp);
        ROT_PLUS_90_DEG_BY_Y_AXIS = new Matrix3f(true, tmp);
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_Y_AXIS, -1.5707964f, tmp);
        ROT_MINUS_90_DEG_BY_Y_AXIS = new Matrix3f(true, tmp);
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_Z_AXIS, 1.5707964f, tmp);
        ROT_PLUS_90_DEG_BY_Z_AXIS = new Matrix3f(true, tmp);
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_Z_AXIS, -1.5707964f, tmp);
        ROT_MINUS_90_DEG_BY_Z_AXIS = new Matrix3f(true, tmp);
        Z_UP_TO_Y_UP = ROT_MINUS_90_DEG_BY_X_AXIS;
        POOL = new ThreadLocal<Matrix3fPool>(){

            @Override
            protected Matrix3fPool initialValue() {
                return new Matrix3fPool(128);
            }
        };
    }

    public final float m00() {
        return this.get(0, 0);
    }

    public final float m01() {
        return this.get(0, 1);
    }

    public final float m02() {
        return this.get(0, 2);
    }

    public final float m10() {
        return this.get(1, 0);
    }

    public final float m11() {
        return this.get(1, 1);
    }

    public final float m12() {
        return this.get(1, 2);
    }

    public final float m20() {
        return this.get(2, 0);
    }

    public final float m21() {
        return this.get(2, 1);
    }

    public final float m22() {
        return this.get(2, 2);
    }

    public final Matrix3f m00(float v) {
        this.set(0, 0, v);
        return this;
    }

    public final Matrix3f m01(float v) {
        this.set(0, 1, v);
        return this;
    }

    public final Matrix3f m02(float v) {
        this.set(0, 2, v);
        return this;
    }

    public final Matrix3f m10(float v) {
        this.set(1, 0, v);
        return this;
    }

    public final Matrix3f m11(float v) {
        this.set(1, 1, v);
        return this;
    }

    public final Matrix3f m12(float v) {
        this.set(1, 2, v);
        return this;
    }

    public final Matrix3f m20(float v) {
        this.set(2, 0, v);
        return this;
    }

    public final Matrix3f m21(float v) {
        this.set(2, 1, v);
        return this;
    }

    public final Matrix3f m22(float v) {
        this.set(2, 2, v);
        return this;
    }

    public final Matrix3f setRow(int row, float x, float y, float z) {
        if (row >= 0 && row <= 3) {
            this.set(row, 0, x);
            this.set(row, 1, y);
            this.set(row, 2, z);
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + row);
    }

    public final Matrix3f setRow(int row, Tuple3f t3f) {
        if (row >= 0 && row <= 3) {
            this.set(row, 0, t3f.getX());
            this.set(row, 1, t3f.getY());
            this.set(row, 2, t3f.getZ());
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + row);
    }

    public final Matrix3f getRow(int row, Tuple3f t3f) {
        if (row >= 0 && row <= 3) {
            t3f.setX(this.get(row, 0));
            t3f.setY(this.get(row, 1));
            t3f.setZ(this.get(row, 2));
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + row);
    }

    public final Matrix3f setColumn(int column, float x, float y, float z) {
        if (column >= 0 && column <= 3) {
            this.set(0, column, x);
            this.set(1, column, y);
            this.set(2, column, z);
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + column);
    }

    public final Matrix3f setColumn(int column, Tuple3f t3f) {
        if (column >= 0 && column <= 3) {
            this.set(0, column, t3f.getX());
            this.set(1, column, t3f.getY());
            this.set(2, column, t3f.getZ());
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + column);
    }

    public final Matrix3f getColumn(int column, Tuple3f t3f) {
        if (column >= 0 && column <= 3) {
            t3f.setX(this.get(0, column));
            t3f.setY(this.get(1, column));
            t3f.setZ(this.get(2, column));
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + column);
    }

    public final Matrix3f set(float scale) {
        int r = 0;
        while (r < 3) {
            int c = 0;
            while (c < 3) {
                if (r == c) {
                    this.set(r, c, scale);
                } else {
                    this.set(r, c, 0.0f);
                }
                ++c;
            }
            ++r;
        }
        return this;
    }

    public final float getScale() {
        return this.SVD(null);
    }

    public final void set(Quaternion4f quat) {
        this.setFromQuat(quat.getA(), quat.getB(), quat.getC(), quat.getD());
    }

    public final void set(AxisAngle3f aa3f) {
        this.setFromAxisAngle(aa3f.getX(), aa3f.getY(), aa3f.getZ(), aa3f.getAngle());
    }

    public final Matrix3f set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00(m00);
        this.m01(m01);
        this.m02(m02);
        this.m10(m10);
        this.m11(m11);
        this.m12(m12);
        this.m20(m20);
        this.m21(m21);
        this.m22(m22);
        return this;
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.put(this.values[0]).put(this.values[3]).put(this.values[6]).put(this.values[1]).put(this.values[4]).put(this.values[7]).put(this.values[2]).put(this.values[5]).put(this.values[8]);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        buffer.put(this.values[0]).put(this.values[3]).put(this.values[6]).put(this.values[1]).put(this.values[4]).put(this.values[7]).put(this.values[2]).put(this.values[5]).put(this.values[8]);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static FloatBuffer writeToBuffer(Matrix3f[] matrices, FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        int i = 0;
        while (i < matrices.length) {
            matrices[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static FloatBuffer writeToBuffer(Matrix3f[] matrices, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        int i = 0;
        while (i < matrices.length) {
            matrices[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer) {
        buffer.get(this.values, 0, 1).get(this.values, 3, 1).get(this.values, 6, 1).get(this.values, 1, 1).get(this.values, 4, 1).get(this.values, 7, 1).get(this.values, 2, 1).get(this.values, 5, 1).get(this.values, 8, 1);
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer, int position) {
        buffer.position(position);
        buffer.get(this.values, 0, 1).get(this.values, 3, 1).get(this.values, 6, 1).get(this.values, 1, 1).get(this.values, 4, 1).get(this.values, 7, 1).get(this.values, 2, 1).get(this.values, 5, 1).get(this.values, 8, 1);
        return buffer;
    }

    public static FloatBuffer readFromBuffer(Matrix3f[] matrices, FloatBuffer buffer) {
        int i = 0;
        while (i < matrices.length) {
            matrices[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public static FloatBuffer readFromBuffer(Matrix3f[] matrices, FloatBuffer buffer, int position) {
        buffer.position(position);
        int i = 0;
        while (i < matrices.length) {
            matrices[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public final Matrix3f negate(Matrix3f mat) {
        this.set(mat);
        this.negate();
        return this;
    }

    public final float determinant() {
        return this.m00() * (this.m11() * this.m22() - this.m21() * this.m12()) - this.m01() * (this.m10() * this.m22() - this.m20() * this.m12()) + this.m02() * (this.m10() * this.m21() - this.m20() * this.m11());
    }

    public final Matrix3f normalize() {
        this.SVD(this);
        return this;
    }

    public final Matrix3f normalize(Matrix3f mat) {
        this.set(mat);
        this.SVD(this);
        return this;
    }

    public final Matrix3f normalizeCP() {
        float s = FastMath.pow(this.determinant(), -0.33333334f);
        this.mul(s);
        return this;
    }

    public final Matrix3f normalizeCP(Matrix3f mat) {
        this.set(mat);
        this.normalizeCP();
        return this;
    }

    public final Matrix3f transpose(Matrix3f mat) {
        super.transpose(mat);
        return this;
    }

    public Matrix3f mul(float scalar) {
        this.values[0] = this.values[0] * scalar;
        this.values[1] = this.values[1] * scalar;
        this.values[2] = this.values[2] * scalar;
        this.values[3] = this.values[3] * scalar;
        this.values[4] = this.values[4] * scalar;
        this.values[5] = this.values[5] * scalar;
        this.values[6] = this.values[6] * scalar;
        this.values[7] = this.values[7] * scalar;
        this.values[8] = this.values[8] * scalar;
        this.isDirty[0] = true;
        return this;
    }

    public Matrix3f invert() {
        float d = this.determinant();
        if (d == 0.0f) {
            return this;
        }
        d = 1.0f / d;
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.set(this.values[4] * this.values[8] - this.values[5] * this.values[7], this.values[2] * this.values[7] - this.values[1] * this.values[8], this.values[1] * this.values[5] - this.values[2] * this.values[4], this.values[5] * this.values[6] - this.values[3] * this.values[8], this.values[0] * this.values[8] - this.values[2] * this.values[6], this.values[2] * this.values[3] - this.values[0] * this.values[5], this.values[3] * this.values[7] - this.values[4] * this.values[6], this.values[1] * this.values[6] - this.values[0] * this.values[7], this.values[0] * this.values[4] - this.values[1] * this.values[3]);
        this.mul(d);
        return this;
    }

    public final void invert(Matrix3f mat) {
        this.set(mat);
        this.invert();
    }

    public final void transform(Tuple3f t3f, Tuple3f result) {
        result.set(this.m00() * t3f.getX() + this.m01() * t3f.getY() + this.m02() * t3f.getZ(), this.m10() * t3f.getX() + this.m11() * t3f.getY() + this.m12() * t3f.getZ(), this.m20() * t3f.getX() + this.m21() * t3f.getY() + this.m22() * t3f.getZ());
    }

    public final void transform(Tuple3f t3f) {
        this.transform(t3f, t3f);
    }

    public final void add(Matrix3f m1, Matrix3f m2) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, m1.get(i, j) + m2.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void add(Matrix3f m2) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, this.get(i, j) + m2.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void sub(Matrix3f m1, Matrix3f m2) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, m1.get(i, j) - m2.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void sub(Matrix3f m2) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, this.get(i, j) - m2.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void rotX(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.set(0, 0, 1.0f);
        this.set(0, 1, 0.0f);
        this.set(0, 2, 0.0f);
        this.set(1, 0, 0.0f);
        this.set(1, 1, c);
        this.set(1, 2, -s);
        this.set(2, 0, 0.0f);
        this.set(2, 1, s);
        this.set(2, 2, c);
    }

    public final void rotY(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.set(0, 0, c);
        this.set(0, 1, 0.0f);
        this.set(0, 2, s);
        this.set(1, 0, 0.0f);
        this.set(1, 1, 1.0f);
        this.set(1, 2, 0.0f);
        this.set(2, 0, -s);
        this.set(2, 1, 0.0f);
        this.set(2, 2, c);
    }

    public final void rotZ(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.set(0, 0, c);
        this.set(0, 1, -s);
        this.set(0, 2, 0.0f);
        this.set(1, 0, s);
        this.set(1, 1, c);
        this.set(1, 2, 0.0f);
        this.set(2, 0, 0.0f);
        this.set(2, 1, 0.0f);
        this.set(2, 2, 1.0f);
    }

    public final void mul(float scalar, Matrix3f mat) {
        this.set(mat);
        this.mul(scalar);
    }

    public final void mul(Matrix3f mat1, Matrix3f mat2) {
        this.set(mat1.m00() * mat2.m00() + mat1.m01() * mat2.m10() + mat1.m02() * mat2.m20(), mat1.m00() * mat2.m01() + mat1.m01() * mat2.m11() + mat1.m02() * mat2.m21(), mat1.m00() * mat2.m02() + mat1.m01() * mat2.m12() + mat1.m02() * mat2.m22(), mat1.m10() * mat2.m00() + mat1.m11() * mat2.m10() + mat1.m12() * mat2.m20(), mat1.m10() * mat2.m01() + mat1.m11() * mat2.m11() + mat1.m12() * mat2.m21(), mat1.m10() * mat2.m02() + mat1.m11() * mat2.m12() + mat1.m12() * mat2.m22(), mat1.m20() * mat2.m00() + mat1.m21() * mat2.m10() + mat1.m22() * mat2.m20(), mat1.m20() * mat2.m01() + mat1.m21() * mat2.m11() + mat1.m22() * mat2.m21(), mat1.m20() * mat2.m02() + mat1.m21() * mat2.m12() + mat1.m22() * mat2.m22());
    }

    public final void mul(Matrix3f mat) {
        this.mul(this, mat);
    }

    public final void mul(Tuple3f vec, Tuple3f t3dOut) {
        t3dOut.set(this.m00() * vec.getX() + this.m01() * vec.getY() + this.m02() * vec.getZ(), this.m10() * vec.getX() + this.m11() * vec.getY() + this.m12() * vec.getZ(), this.m20() * vec.getX() + this.m21() * vec.getY() + this.m22() * vec.getZ());
    }

    public final void mulNormalize(Matrix3f mat) {
        this.mul(mat);
        this.SVD(this);
    }

    public final void mulNormalize(Matrix3f mat1, Matrix3f mat2) {
        this.mul(mat1, mat2);
        this.SVD(this);
    }

    public final void mulTransposeBoth(Matrix3f mat1, Matrix3f mat2) {
        this.mul(mat2, mat1);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix3f m1, Matrix3f m2) {
        this.set(0, 0, m1.m00() * m2.m00() + m1.m01() * m2.m01() + m1.m02() * m2.m02());
        this.set(0, 1, m1.m00() * m2.m10() + m1.m01() * m2.m11() + m1.m02() * m2.m12());
        this.set(0, 2, m1.m00() * m2.m20() + m1.m01() * m2.m21() + m1.m02() * m2.m22());
        this.set(1, 0, m1.m10() * m2.m00() + m1.m11() * m2.m01() + m1.m12() * m2.m02());
        this.set(1, 1, m1.m10() * m2.m10() + m1.m11() * m2.m11() + m1.m12() * m2.m12());
        this.set(1, 2, m1.m10() * m2.m20() + m1.m11() * m2.m21() + m1.m12() * m2.m22());
        this.set(2, 0, m1.m20() * m2.m00() + m1.m21() * m2.m01() + m1.m22() * m2.m02());
        this.set(2, 1, m1.m20() * m2.m10() + m1.m21() * m2.m11() + m1.m22() * m2.m12());
        this.set(2, 2, m1.m20() * m2.m20() + m1.m21() * m2.m21() + m1.m22() * m2.m22());
    }

    public final void mulTransposeLeft(Matrix3f mat1, Matrix3f mat2) {
        this.set(0, 0, mat1.m00() * mat2.m00() + mat1.m10() * mat2.m10() + mat1.m20() * mat2.m20());
        this.set(0, 1, mat1.m00() * mat2.m01() + mat1.m10() * mat2.m11() + mat1.m20() * mat2.m21());
        this.set(0, 2, mat1.m00() * mat2.m02() + mat1.m10() * mat2.m12() + mat1.m20() * mat2.m22());
        this.set(1, 0, mat1.m01() * mat2.m00() + mat1.m11() * mat2.m10() + mat1.m21() * mat2.m20());
        this.set(1, 1, mat1.m01() * mat2.m01() + mat1.m11() * mat2.m11() + mat1.m21() * mat2.m21());
        this.set(1, 2, mat1.m01() * mat2.m02() + mat1.m11() * mat2.m12() + mat1.m21() * mat2.m22());
        this.set(2, 0, mat1.m02() * mat2.m00() + mat1.m12() * mat2.m10() + mat1.m22() * mat2.m20());
        this.set(2, 1, mat1.m02() * mat2.m01() + mat1.m12() * mat2.m11() + mat1.m22() * mat2.m21());
        this.set(2, 2, mat1.m02() * mat2.m02() + mat1.m12() * mat2.m12() + mat1.m22() * mat2.m22());
    }

    public final void setCross(Vector3f v) {
        this.set(0, 1, -v.getZ());
        this.set(0, 2, v.getY());
        this.set(1, 0, v.getZ());
        this.set(1, 2, -v.getX());
        this.set(2, 0, -v.getY());
        this.set(2, 1, v.getX());
    }

    public final void setCross(Vector3f v, boolean notInverted) {
        if (notInverted) {
            this.setCross(v);
        } else {
            this.set(0, 1, v.getZ());
            this.set(0, 2, -v.getY());
            this.set(1, 0, -v.getZ());
            this.set(1, 2, v.getX());
            this.set(2, 0, v.getY());
            this.set(2, 1, -v.getX());
        }
    }

    public void interpolate(Matrix3f m1, Matrix3f m2, float alpha) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.values[0] = m1.values[0] + (m2.values[0] - m1.values[0]) * alpha;
        this.values[1] = m1.values[1] + (m2.values[1] - m1.values[1]) * alpha;
        this.values[2] = m1.values[2] + (m2.values[2] - m1.values[2]) * alpha;
        this.values[3] = m1.values[3] + (m2.values[3] - m1.values[3]) * alpha;
        this.values[4] = m1.values[4] + (m2.values[4] - m1.values[4]) * alpha;
        this.values[5] = m1.values[5] + (m2.values[5] - m1.values[5]) * alpha;
        this.values[6] = m1.values[6] + (m2.values[6] - m1.values[6]) * alpha;
        this.values[7] = m1.values[7] + (m2.values[7] - m1.values[7]) * alpha;
        this.values[8] = m1.values[8] + (m2.values[8] - m1.values[8]) * alpha;
        this.isDirty[0] = true;
    }

    public Matrix3f asReadOnly() {
        return new Matrix3f(true, this.dataBegin, this.colSkip, this.values, this.isDirty);
    }

    public Matrix3f getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    public int hashCode() {
        return VecMathUtils.floatToIntBits(this.m00()) ^ VecMathUtils.floatToIntBits(this.m01()) ^ VecMathUtils.floatToIntBits(this.m02()) ^ VecMathUtils.floatToIntBits(this.m10()) ^ VecMathUtils.floatToIntBits(this.m11()) ^ VecMathUtils.floatToIntBits(this.m12()) ^ VecMathUtils.floatToIntBits(this.m20()) ^ VecMathUtils.floatToIntBits(this.m21()) ^ VecMathUtils.floatToIntBits(this.m22());
    }

    public boolean equals(Matrix3f m2) {
        if (m2 == null) {
            return false;
        }
        int r = 0;
        while (r < 3) {
            int c = 0;
            while (c < 3) {
                if (this.get(r, c) != m2.get(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Matrix3f && this.equals((Matrix3f)o);
    }

    public boolean epsilonEquals(Matrix3f m2, float epsilon) {
        int r = 0;
        while (r < 3) {
            int c = 0;
            while (c < 3) {
                if (Math.abs(this.get(r, c) - m2.get(r, c)) > epsilon) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    private final float SVD(Matrix3f rot) {
        float t;
        float s = FastMath.sqrt((this.m00() * this.m00() + this.m10() * this.m10() + this.m20() * this.m20() + this.m01() * this.m01() + this.m11() * this.m11() + this.m21() * this.m21() + this.m02() * this.m02() + this.m12() * this.m12() + this.m22() * this.m22()) / 3.0f);
        float f = t = s == 0.0f ? 0.0f : 1.0f / s;
        if (rot != null) {
            if (rot != this) {
                rot.set(this);
            }
            rot.mul(t);
        }
        return s;
    }

    private final void setFromQuat(float a, float b, float c, float d) {
        float n = a * a + b * b + c * c + d * d;
        float s = n > 0.0f ? 2.0f / n : 0.0f;
        float xs = a * s;
        float ys = b * s;
        float zs = c * s;
        float wx = d * xs;
        float wy = d * ys;
        float wz = d * zs;
        float xx = a * xs;
        float xy = a * ys;
        float xz = a * zs;
        float yy = b * ys;
        float yz = b * zs;
        float zz = c * zs;
        this.set(0, 0, 1.0f - (yy + zz));
        this.set(0, 1, xy - wz);
        this.set(0, 2, xz + wy);
        this.set(1, 0, xy + wz);
        this.set(1, 1, 1.0f - (xx + zz));
        this.set(1, 2, yz - wx);
        this.set(2, 0, xz - wy);
        this.set(2, 1, yz + wx);
        this.set(2, 2, 1.0f - (xx + yy));
    }

    private final void setFromAxisAngle(float x, float y, float z, float angle) {
        float n = 1.0f / FastMath.sqrt(x * x + y * y + z * z);
        x *= n;
        y *= n;
        z *= n;
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        float omc = 1.0f - c;
        this.set(0, 0, c + x * x * omc);
        this.set(1, 1, c + y * y * omc);
        this.set(2, 2, c + z * z * omc);
        float tmp1 = x * y * omc;
        float tmp2 = z * s;
        this.set(0, 1, tmp1 - tmp2);
        this.set(1, 0, tmp1 + tmp2);
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.set(0, 2, tmp1 + tmp2);
        this.set(2, 0, tmp1 - tmp2);
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.set(1, 2, tmp1 - tmp2);
        this.set(2, 1, tmp1 + tmp2);
    }

    public Matrix3f clone() {
        return new Matrix3f(this);
    }

    protected Matrix3f(boolean readOnly) {
        super(readOnly, 3, 3);
    }

    protected Matrix3f(boolean readOnly, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this(readOnly);
        this.values[0 * this.getNumCols() + 0] = m00;
        this.values[0 * this.getNumCols() + 1] = m01;
        this.values[0 * this.getNumCols() + 2] = m02;
        this.values[1 * this.getNumCols() + 0] = m10;
        this.values[1 * this.getNumCols() + 1] = m11;
        this.values[1 * this.getNumCols() + 2] = m12;
        this.values[2 * this.getNumCols() + 0] = m20;
        this.values[2 * this.getNumCols() + 1] = m21;
        this.values[2 * this.getNumCols() + 2] = m22;
    }

    protected Matrix3f(boolean readOnly, float[] values) {
        this(readOnly);
        int size = this.getNumRows() * this.getNumCols();
        System.arraycopy(values, 0, this.values, 0, size);
    }

    protected Matrix3f(boolean readOnly, Matrix3f mat) {
        this(readOnly, mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
    }

    protected Matrix3f(boolean readOnly, int dataBegin, int colSkip, float[] values, boolean[] isDirty) {
        super(readOnly, dataBegin, colSkip, 3, 3, values, isDirty);
    }

    public Matrix3f() {
        this(false);
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this(false, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Matrix3f(float[] values) {
        this(false, values);
    }

    public Matrix3f(Matrix3f mat) {
        this(false, mat);
    }

    public static Matrix3f newReadOnly() {
        return new Matrix3f(true);
    }

    public static Matrix3f newReadOnly(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return new Matrix3f(true, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static Matrix3f newReadOnly(float[] values) {
        return new Matrix3f(true, values);
    }

    public static Matrix3f newReadOnly(Matrix3f mat) {
        return new Matrix3f(true, mat);
    }

    protected Matrix3f(int dataBegin, int colSkip, float[] values, boolean[] isDirty) {
        this(false, dataBegin, colSkip, values, isDirty);
    }

    public static Matrix3f sharedSubMatrix3f(MatrixMxNf mat, int beginRow, int beginCol) {
        return new Matrix3f(beginRow, beginCol, mat.values, null);
    }

    public static Matrix3f fromPool() {
        return POOL.get().alloc();
    }

    public static void toPool(Matrix3f o) {
        POOL.get().free(o);
    }
}

