/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMathd;
import org.openmali.vecmath2.Tuple3d;
import org.openmali.vecmath2.pools.Point3dPool;

public class Point3d
extends Tuple3d
implements Externalizable {
    public static final Point3d ZERO = Point3d.newReadOnly(0.0, 0.0, 0.0);
    private static final ThreadLocal<Point3dPool> POOL = new ThreadLocal<Point3dPool>(){

        @Override
        protected Point3dPool initialValue() {
            return new Point3dPool(128);
        }
    };
    private Point3d readOnlyInstance = null;

    public final double distanceSquared(Point3d that) {
        double result = 0.0;
        int i = 0;
        while (i < this.getSize()) {
            double d = this.getValue(i) - that.getValue(i);
            result += d * d;
            ++i;
        }
        return result;
    }

    public final double distance(Point3d that) {
        return FastMathd.sqrt(this.distanceSquared(that));
    }

    public final double distanceSquared(double p2x, double p2y, double p2z) {
        double result = 0.0;
        double d = this.getX() - p2x;
        result += d * d;
        d = this.getY() - p2y;
        result += d * d;
        d = this.getZ() - p2z;
        return result += d * d;
    }

    public final double distance(double p2x, double p2y, double p2z) {
        return FastMathd.sqrt(this.distanceSquared(p2x, p2y, p2z));
    }

    public final double distanceToOriginSquared() {
        return this.distance(0.0, 0.0, 0.0);
    }

    public double distanceToOrigin() {
        return FastMathd.sqrt(this.distanceToOriginSquared());
    }

    public Point3d asReadOnly() {
        return new Point3d(true, this.values, this.isDirty, false);
    }

    public Point3d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Point3d(boolean readOnly, double x, double y, double z) {
        super(readOnly, x, y, z);
    }

    protected Point3d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Point3d(boolean readOnly, Tuple3d tuple) {
        this(readOnly, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    protected Point3d(boolean readOnly) {
        this(readOnly, 0.0, 0.0, 0.0);
    }

    public Point3d(double x, double y, double z) {
        this(false, x, y, z);
    }

    public Point3d(double[] values) {
        this(false, values, null, true);
    }

    public Point3d(Tuple3d tuple) {
        this(false, tuple);
    }

    public Point3d() {
        this(false);
    }

    public static Point3d newReadOnly(double x, double y, double z) {
        return new Point3d(true, x, y, z);
    }

    public static Point3d newReadOnly(double[] values) {
        return new Point3d(true, values, null, true);
    }

    public static Point3d newReadOnly(Tuple3d tuple) {
        return new Point3d(true, tuple);
    }

    public static Point3d newReadOnly() {
        return new Point3d(true);
    }

    public static Point3d fromPool() {
        return POOL.get().alloc();
    }

    public static Point3d fromPool(double x, double y, double z) {
        return POOL.get().alloc(x, y, z);
    }

    public static Point3d fromPool(Tuple3d tuple) {
        return Point3d.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Point3d o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly() {
        return Point3d.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(Tuple3d tuple3d) {
        return Point3d.newReadOnly(tuple3d);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(double[] dArray) {
        return Point3d.newReadOnly(dArray);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(double d, double d2, double d3) {
        return Point3d.newReadOnly(d, d2, d3);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool(Tuple3d tuple3d) {
        return Point3d.fromPool(tuple3d);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool(double d, double d2, double d3) {
        return Point3d.fromPool(d, d2, d3);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool() {
        return Point3d.fromPool();
    }
}

