/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.PointInterface;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.pools.Point3fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point3f
extends Tuple3f
implements Externalizable,
PointInterface<Tuple3f, Point3f> {
    private static final long serialVersionUID = -6199186808152383088L;
    public static final Point3f ZERO = Point3f.newReadOnly(0.0f, 0.0f, 0.0f);
    private static final ThreadLocal<Point3fPool> POOL = new ThreadLocal<Point3fPool>(){

        @Override
        protected Point3fPool initialValue() {
            return new Point3fPool(128);
        }
    };
    private Point3f readOnlyInstance = null;

    @Override
    public final float distanceSquared(Point3f that) {
        float result = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            float d = this.getValue(i) - that.getValue(i);
            result += d * d;
            ++i;
        }
        return result;
    }

    @Override
    public final float distance(Point3f that) {
        return FastMath.sqrt(this.distanceSquared(that));
    }

    public final float distanceSquared(float p2x, float p2y, float p2z) {
        float result = 0.0f;
        float d = this.getX() - p2x;
        result += d * d;
        d = this.getY() - p2y;
        result += d * d;
        d = this.getZ() - p2z;
        return result += d * d;
    }

    public final float distance(float p2x, float p2y, float p2z) {
        return FastMath.sqrt(this.distanceSquared(p2x, p2y, p2z));
    }

    @Override
    public final float distanceToOriginSquared() {
        return this.distance(0.0f, 0.0f, 0.0f);
    }

    @Override
    public float distanceToOrigin() {
        return FastMath.sqrt(this.distanceToOriginSquared());
    }

    @Override
    public Point3f clone() {
        return new Point3f(this);
    }

    @Override
    public Point3f asReadOnly() {
        return new Point3f(true, this.values, this.isDirty, false);
    }

    @Override
    public Point3f getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Point3f(boolean readOnly, float x, float y, float z) {
        super(readOnly, x, y, z);
    }

    protected Point3f(boolean readOnly, float[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Point3f(boolean readOnly, Tuple3f tuple) {
        this(readOnly, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    protected Point3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f);
    }

    public Point3f(float x, float y, float z) {
        this(false, x, y, z);
    }

    public Point3f(float[] values) {
        this(false, values, null, true);
    }

    public Point3f(Tuple3f tuple) {
        this(false, tuple);
    }

    public Point3f() {
        this(false);
    }

    public static Point3f newReadOnly(float x, float y, float z) {
        return new Point3f(true, x, y, z);
    }

    public static Point3f newReadOnly(float[] values) {
        return new Point3f(true, values, null, true);
    }

    public static Point3f newReadOnly(Tuple3f tuple) {
        return new Point3f(true, tuple);
    }

    public static Point3f newReadOnly() {
        return new Point3f(true);
    }

    public static Point3f fromPool() {
        return POOL.get().alloc();
    }

    public static Point3f fromPool(float x, float y, float z) {
        return POOL.get().alloc(x, y, z);
    }

    public static Point3f fromPool(Tuple3f tuple) {
        return Point3f.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Point3f o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly() {
        return Point3f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(Tuple3f tuple3f) {
        return Point3f.newReadOnly(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(float[] fArray) {
        return Point3f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(float f, float f2, float f3) {
        return Point3f.newReadOnly(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool(Tuple3f tuple3f) {
        return Point3f.fromPool(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool(float f, float f2, float f3) {
        return Point3f.fromPool(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool() {
        return Point3f.fromPool();
    }
}

