/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord2fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexCoord2f
extends TexCoordf<TexCoord2f>
implements Externalizable {
    private static final long serialVersionUID = 4961153246436722156L;
    private static final ThreadLocal<TexCoord2fPool> POOL = new ThreadLocal<TexCoord2fPool>(){

        @Override
        protected TexCoord2fPool initialValue() {
            return new TexCoord2fPool(128);
        }
    };
    public static final TexCoord2f LOWER_LEFT = TexCoord2f.newReadOnly(0.0f, 0.0f);
    public static final TexCoord2f LOWER_RIGHT = TexCoord2f.newReadOnly(1.0f, 0.0f);
    public static final TexCoord2f UPPER_LEFT = TexCoord2f.newReadOnly(0.0f, 1.0f);
    public static final TexCoord2f UPPER_RIGHT = TexCoord2f.newReadOnly(1.0f, 1.0f);

    public final TexCoord2f set(float s, float t) {
        this.setS(s);
        this.setT(t);
        return this;
    }

    public final TexCoord2f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord2f s(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float s() {
        return this.values[0];
    }

    public final TexCoord2f setT(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float getT() {
        return this.values[1];
    }

    public final TexCoord2f t(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float t() {
        return this.values[1];
    }

    public final TexCoord2f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f addT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f subT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mulT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mul(float vs, float vt) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vt;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mul(float factor) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * factor;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f divT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f div(float vs, float vt) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vt;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TexCoord2f add(float s, float t) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + t;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TexCoord2f sub(float s, float t) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - t;
        this.isDirty = true;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord2f && this.equals((TexCoord2f)o);
    }

    public TexCoord2f clone() {
        return new TexCoord2f(this);
    }

    protected TexCoord2f(boolean readOnly, float s, float t) {
        super(readOnly, new float[]{s, t});
    }

    protected TexCoord2f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1]);
    }

    protected TexCoord2f(boolean readOnly, TexCoordf<?> texCoord) {
        super(readOnly, TexCoord2f.newArray(texCoord.values, 2));
    }

    protected TexCoord2f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f);
    }

    public TexCoord2f(float s, float t) {
        this(false, s, t);
    }

    public TexCoord2f(float[] values) {
        this(false, values);
    }

    public TexCoord2f(TexCoordf<?> texCoord) {
        this(false, texCoord);
    }

    public TexCoord2f() {
        this(false);
    }

    public static final TexCoord2f newReadOnly(float s, float t) {
        return new TexCoord2f(true, s, t);
    }

    public static final TexCoord2f newReadOnly(float[] values) {
        return new TexCoord2f(true, values);
    }

    public static final TexCoord2f newReadOnly(TexCoordf<?> texCoord) {
        return new TexCoord2f(true, texCoord);
    }

    public static TexCoord2f fromPool() {
        return POOL.get().alloc();
    }

    public static TexCoord2f fromPool(float s, float t) {
        return POOL.get().alloc(s, t);
    }

    public static void toPool(TexCoord2f o) {
        POOL.get().free(o);
    }
}

