/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord3fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexCoord3f
extends TexCoordf<TexCoord3f>
implements Externalizable {
    private static final long serialVersionUID = -7616743403485094339L;
    private static final ThreadLocal<TexCoord3fPool> POOL = new ThreadLocal<TexCoord3fPool>(){

        @Override
        protected TexCoord3fPool initialValue() {
            return new TexCoord3fPool(128);
        }
    };

    public final TexCoord3f set(float s, float t, float r) {
        this.setS(s);
        this.setT(t);
        this.setP(r);
        return this;
    }

    public final TexCoord3f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord3f s(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float s() {
        return this.values[0];
    }

    public final TexCoord3f setT(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float getT() {
        return this.values[1];
    }

    public final TexCoord3f t(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float t() {
        return this.values[1];
    }

    public final TexCoord3f setP(float p) {
        this.values[this.roTrick + 2] = p;
        this.isDirty = true;
        return this;
    }

    public final float getP() {
        return this.values[2];
    }

    public final TexCoord3f p(float p) {
        this.values[this.roTrick + 2] = p;
        this.isDirty = true;
        return this;
    }

    public final float p() {
        return this.values[2];
    }

    public final TexCoord3f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f addT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f addP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f subT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f subP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f mulT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f mulP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f mul(float vs, float vt, float vp) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vt;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vp;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f mul(float factor) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * factor;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f divT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f divP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f div(float vs, float vt, float vp) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vt;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vp;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f add(float s, float t, float p) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + t;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + p;
        this.isDirty = true;
        return this;
    }

    public final TexCoord3f sub(float s, float t, float p) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - t;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - p;
        this.isDirty = true;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord3f && this.equals((TexCoord3f)o);
    }

    public TexCoord3f clone() {
        return new TexCoord3f(this);
    }

    protected TexCoord3f(boolean readOnly, float s, float t, float p) {
        super(readOnly, new float[]{s, t, p});
    }

    protected TexCoord3f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2]);
    }

    protected TexCoord3f(boolean readOnly, TexCoordf<?> texCoord) {
        super(readOnly, TexCoord3f.newArray(texCoord.values, 3));
    }

    protected TexCoord3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f);
    }

    public TexCoord3f(float s, float t, float p) {
        this(false, s, t, p);
    }

    public TexCoord3f(float[] values) {
        this(false, values);
    }

    public TexCoord3f(TexCoordf<?> texCoord) {
        this(false, texCoord);
    }

    public TexCoord3f() {
        this(false);
    }

    public static final TexCoord3f newReadOnly(float s, float t, float p) {
        return new TexCoord3f(true, s, t, p);
    }

    public static final TexCoord3f newReadOnly(float[] values) {
        return new TexCoord3f(true, values);
    }

    public static final TexCoord3f newReadOnly(TexCoordf<?> texCoord) {
        return new TexCoord3f(true, texCoord);
    }

    public static TexCoord3f fromPool() {
        return POOL.get().alloc();
    }

    public static TexCoord3f fromPool(float s, float t, float p) {
        return POOL.get().alloc(s, t, p);
    }

    public static void toPool(TexCoord3f o) {
        POOL.get().free(o);
    }
}

