/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord4fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexCoord4f
extends TexCoordf<TexCoord4f>
implements Externalizable {
    private static final long serialVersionUID = -8625802351660888699L;
    private static final ThreadLocal<TexCoord4fPool> POOL = new ThreadLocal<TexCoord4fPool>(){

        @Override
        protected TexCoord4fPool initialValue() {
            return new TexCoord4fPool(128);
        }
    };

    public final TexCoord4f set(float s, float t, float p, float q) {
        this.setS(s);
        this.setT(t);
        this.setP(p);
        this.setQ(q);
        return this;
    }

    public final TexCoord4f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord4f s(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float s() {
        return this.values[0];
    }

    public final TexCoord4f setT(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float getT() {
        return this.values[1];
    }

    public final TexCoord4f t(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float t() {
        return this.values[1];
    }

    public final TexCoord4f setP(float p) {
        this.values[this.roTrick + 2] = p;
        this.isDirty = true;
        return this;
    }

    public final float getP() {
        return this.values[2];
    }

    public final TexCoord4f p(float p) {
        this.values[this.roTrick + 2] = p;
        this.isDirty = true;
        return this;
    }

    public final float p() {
        return this.values[2];
    }

    public final TexCoord4f setQ(float q) {
        this.values[this.roTrick + 3] = q;
        this.isDirty = true;
        return this;
    }

    public final float getQ() {
        return this.values[3];
    }

    public final TexCoord4f q(float q) {
        this.values[this.roTrick + 3] = q;
        this.isDirty = true;
        return this;
    }

    public final float q() {
        return this.values[3];
    }

    public final TexCoord4f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f addT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f addP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f addQ(float v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f subT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f subP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f subQ(float v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mulT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mulP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mulQ(float v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mul(float vs, float vt, float vp, float vq) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vt;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vp;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * vq;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f mul(float factor) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * factor;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f divT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f divP(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f divQ(float v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f div(float vs, float vt, float vp, float vq) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vt;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vp;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / vq;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f add(float s, float t, float p, float q) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + t;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + p;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + q;
        this.isDirty = true;
        return this;
    }

    public final TexCoord4f sub(float s, float t, float p, float q) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - t;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - p;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - q;
        this.isDirty = true;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord4f && this.equals((TexCoord4f)o);
    }

    public TexCoord4f clone() {
        return new TexCoord4f(this);
    }

    protected TexCoord4f(boolean readOnly, float s, float t, float p, float q) {
        super(readOnly, new float[]{s, t, p, q});
    }

    protected TexCoord4f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2], values[3]);
    }

    protected TexCoord4f(boolean readOnly, TexCoord4f texCoord) {
        super(readOnly, TexCoord4f.newArray(texCoord.values, 4));
    }

    protected TexCoord4f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public TexCoord4f(float s, float t, float p, float q) {
        this(false, s, t, p, q);
    }

    public TexCoord4f(float[] values) {
        this(false, values);
    }

    public TexCoord4f(TexCoord4f texCoord) {
        this(false, texCoord);
    }

    public TexCoord4f() {
        this(false);
    }

    public static final TexCoord4f newReadOnly(float s, float t, float p, float q) {
        return new TexCoord4f(true, s, t, p, q);
    }

    public static final TexCoord4f newReadOnly(float[] values) {
        return new TexCoord4f(true, values);
    }

    public static final TexCoord4f newReadOnly(TexCoord4f texCoord) {
        return new TexCoord4f(true, texCoord);
    }

    public static TexCoord4f fromPool() {
        return POOL.get().alloc();
    }

    public static TexCoord4f fromPool(float s, float t, float p, float q) {
        return POOL.get().alloc(s, t, p, q);
    }

    public static void toPool(TexCoord4f o) {
        POOL.get().free(o);
    }
}

