/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.Point3d;
import org.openmali.vecmath2.TupleNd;
import org.openmali.vecmath2.pools.Tuple3dPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple3d
extends TupleNd<Tuple3d>
implements Externalizable {
    private static final ThreadLocal<Tuple3dPool> POOL = new ThreadLocal<Tuple3dPool>(){

        @Override
        protected Tuple3dPool initialValue() {
            return new Tuple3dPool(128);
        }
    };
    private Tuple3d readOnlyInstance = null;

    public final Tuple3d set(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    public final Tuple3d setX(double x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3d setY(double y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3d setZ(double z) {
        this.setValue(2, z);
        return this;
    }

    public final double getX() {
        return this.getValue(0);
    }

    public final double getY() {
        return this.getValue(1);
    }

    public final double getZ() {
        return this.getValue(2);
    }

    public final Tuple3d x(double x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3d y(double y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3d z(double z) {
        this.setValue(2, z);
        return this;
    }

    public final double x() {
        return this.getValue(0);
    }

    public final double y() {
        return this.getValue(1);
    }

    public final double z() {
        return this.getValue(2);
    }

    public final Tuple3d addX(double v) {
        this.addValue(0, v);
        return this;
    }

    public final Tuple3d addY(double v) {
        this.addValue(1, v);
        return this;
    }

    public final Tuple3d addZ(double v) {
        this.addValue(2, v);
        return this;
    }

    public final Tuple3d add(double x, double y, double z) {
        this.addValue(0, x);
        this.addValue(1, y);
        this.addValue(2, z);
        return this;
    }

    public final Tuple3d subX(double v) {
        this.subValue(0, v);
        return this;
    }

    public final Tuple3d subY(double v) {
        this.subValue(1, v);
        return this;
    }

    public final Tuple3d subZ(double v) {
        this.subValue(2, v);
        return this;
    }

    public final Tuple3d sub(double x, double y, double z) {
        this.subValue(0, x);
        this.subValue(1, y);
        this.subValue(2, z);
        return this;
    }

    public final Tuple3d mulX(double v) {
        this.mulValue(0, v);
        return this;
    }

    public final Tuple3d mulY(double v) {
        this.mulValue(1, v);
        return this;
    }

    public final Tuple3d mulZ(double v) {
        this.mulValue(2, v);
        return this;
    }

    public final Tuple3d mul(double vx, double vy, double vz) {
        this.mulValue(0, vx);
        this.mulValue(1, vy);
        this.mulValue(2, vz);
        return this;
    }

    public final Tuple3d divX(double v) {
        this.divValue(0, v);
        return this;
    }

    public final Tuple3d divY(double v) {
        this.divValue(1, v);
        return this;
    }

    public final Tuple3d divZ(double v) {
        this.divValue(2, v);
        return this;
    }

    public final Tuple3d div(double vx, double vy, double vz) {
        this.divValue(0, vx);
        this.divValue(1, vy);
        this.divValue(2, vz);
        return this;
    }

    public final Tuple3d scale(double factorX, double factorY, double factorZ) {
        this.mul(factorX, factorY, factorZ);
        return this;
    }

    @Override
    public Tuple3d asReadOnly() {
        return new Tuple3d(true, this.values, this.isDirty, false);
    }

    @Override
    public Tuple3d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof Tuple3d && ((TupleNd)this).equals((Tuple3d)o);
    }

    public Tuple3d clone() {
        try {
            return (Tuple3d)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected Tuple3d(boolean readOnly, double x, double y, double z) {
        super(readOnly, 3);
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
    }

    protected Tuple3d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, 3, copy);
    }

    protected Tuple3d(boolean readOnly, Tuple3d that) {
        super(readOnly, that);
    }

    protected Tuple3d(boolean readOnly) {
        this(readOnly, 0.0, 0.0, 0.0);
    }

    public Tuple3d(double x, double y, double z) {
        this(false, x, y, z);
    }

    public Tuple3d(double[] values) {
        this(false, values, null, true);
    }

    public Tuple3d(Tuple3d that) {
        this(false, that);
    }

    public Tuple3d() {
        this(false, 0.0, 0.0, 0.0);
    }

    public static Tuple3d newReadOnly(double x, double y, double z) {
        return new Point3d(true, x, y, z);
    }

    public static Tuple3d newReadOnly(double[] values) {
        return new Point3d(true, values, null, true);
    }

    public static Tuple3d newReadOnly(Tuple3d tuple) {
        return new Point3d(true, tuple);
    }

    public static Tuple3d newReadOnly() {
        return new Point3d(true);
    }

    public static Tuple3d fromPool() {
        return POOL.get().alloc();
    }

    public static Tuple3d fromPool(double x, double y, double z) {
        return POOL.get().alloc(x, y, z);
    }

    public static Tuple3d fromPool(Tuple3d tuple) {
        return Tuple3d.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Tuple3d o) {
        POOL.get().free(o);
    }
}

