/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import org.openmali.FastMathd;
import org.openmali.vecmath2.util.SerializationUtils;
import org.openmali.vecmath2.util.VecMathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TupleNd<T extends TupleNd<T>> {
    private final int N;
    protected final double[] values;
    protected final int roTrick;
    protected final boolean[] isDirty;
    private static final StringBuffer TMP_SB = new StringBuffer();

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        if (this.isReadOnly()) {
            throw new Error("This instance is read-only.");
        }
        boolean oldValue = this.isDirty[0];
        this.isDirty[0] = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty[0];
    }

    public final int getSize() {
        return this.N;
    }

    public final T setValue(int i, double v) {
        this.values[this.roTrick + i] = v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final double getValue(int i) {
        return this.values[i];
    }

    public final DoubleBuffer writeToBuffer(DoubleBuffer buffer) {
        buffer.clear();
        buffer.put(this.values);
        buffer.flip();
        return buffer;
    }

    public static final DoubleBuffer writeToBuffer(TupleNd<?>[] tuples, DoubleBuffer buffer) {
        buffer.clear();
        int i = 0;
        while (i < tuples.length) {
            buffer.put(tuples[i].values);
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    public final T fill(double f) {
        Arrays.fill(this.values, this.roTrick + 0, this.getSize(), f);
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T addValue(int i, double v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T subValue(int i, double v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T mulValue(int i, double v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T mul(double v) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * v;
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T divValue(int i, double v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T div(double v) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] / v;
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public T set(double[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, this.N);
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T set(TupleNd<?> tuple) {
        System.arraycopy(tuple.values, 0, this.values, this.roTrick + 0, Math.min(this.getSize(), tuple.getSize()));
        this.isDirty[0] = true;
        return (T)this;
    }

    public void get(double[] buffer) {
        System.arraycopy(this.values, 0, buffer, 0, this.N);
    }

    public final void get(TupleNd<?> buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, Math.min(this.getSize(), buffer.getSize()));
    }

    public final T setZero() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, 0.0);
            ++i;
        }
        return (T)this;
    }

    public final T negate() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, -this.values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T negate(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, -((TupleNd)tuple).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T absolute() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, Math.abs(this.values[i]));
            ++i;
        }
        return (T)this;
    }

    public final T absolute(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, Math.abs(((TupleNd)tuple).values[i]));
            ++i;
        }
        return (T)this;
    }

    public final T add(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNd)tuple1).values[i] + ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T add(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, this.values[i] + ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T sub(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNd)tuple1).values[i] - ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T sub(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.subValue(i, ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T scale(double factor, T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNd)tuple).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T scale(double factor) {
        int i = 0;
        while (i < this.N) {
            this.mulValue(i, factor);
            ++i;
        }
        return (T)this;
    }

    public final T scaleAdd(double factor, T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNd)tuple1).values[i] + ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T scaleAdd(double factor, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * this.values[i] + ((TupleNd)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T clampMin(double min) {
        int i = 0;
        while (i < this.N) {
            if (this.values[i] < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return (T)this;
    }

    public final T clampMax(double max) {
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return (T)this;
    }

    public final T clamp(double min, double max) {
        this.clampMin(min);
        this.clampMax(max);
        return (T)this;
    }

    public final T clamp(double min, double max, T tuple) {
        this.set((TupleNd<?>)tuple);
        this.clamp(min, max);
        return (T)this;
    }

    public final T clampMin(double min, T tuple) {
        this.set((TupleNd<?>)tuple);
        this.clampMin(min);
        return (T)this;
    }

    public final T clampMax(double max, T tuple) {
        this.set((TupleNd<?>)tuple);
        this.clampMax(max);
        return (T)this;
    }

    public final T round(T tuple, int decPlaces) {
        double pow = FastMathd.pow(10.0, decPlaces);
        int i = 0;
        while (i < this.N) {
            this.setValue(i, (double)((int)(((TupleNd)tuple).getValue(i) * pow)) / pow);
            ++i;
        }
        return (T)this;
    }

    public final T round(int decPlaces) {
        double pow = FastMathd.pow(10.0, decPlaces);
        int i = 0;
        while (i < this.N) {
            this.setValue(i, (double)((int)(this.getValue(i) * pow)) / pow);
            ++i;
        }
        return (T)this;
    }

    public void interpolate(T t2, double alpha) {
        double beta = 1.0 - alpha;
        int i = 0;
        while (i < this.N) {
            this.setValue(i, beta * this.getValue(i) + alpha * ((TupleNd)t2).getValue(i));
            ++i;
        }
    }

    public final void interpolate(T t1, T t2, double alpha) {
        this.set((TupleNd<?>)t1);
        this.interpolate(t2, alpha);
    }

    public abstract T asReadOnly();

    public abstract T getReadOnly();

    public boolean equals(T v2) {
        if (v2 == null) {
            return false;
        }
        if (this.N != ((TupleNd)v2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) != ((TupleNd)v2).getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            return this.equals((T)((TupleNd)o));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean epsilonEquals(T v2, double epsilon) {
        if (this.N != ((TupleNd)v2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (Math.abs(this.getValue(i) - ((TupleNd)v2).getValue(i)) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.N) {
            long bits = VecMathUtils.doubleToLongBits(this.getValue(i));
            hash = (int)((long)hash ^ (bits ^ bits >> 32));
            ++i;
        }
        return hash;
    }

    public String toString() {
        TMP_SB.setLength(0);
        TMP_SB.append("( ");
        int i = 0;
        while (i < this.N - 1) {
            TMP_SB.append(this.getValue(i));
            TMP_SB.append(", ");
            ++i;
        }
        TMP_SB.append(this.getValue(this.N - 1));
        TMP_SB.append(" )");
        return String.valueOf(this.getClass().getSimpleName()) + TMP_SB.toString();
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            this.values[i] = SerializationUtils.readDoubleFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty[0] = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 4 * this.N + 1;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected TupleNd(boolean readOnly, int n) {
        this.N = n;
        this.values = new double[n];
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected TupleNd(boolean readOnly, double[] values, boolean[] isDirty, int n, boolean copy) {
        this.N = n;
        if (copy) {
            this.values = new double[n];
            System.arraycopy(values, 0, this.values, 0, this.N);
            this.isDirty = isDirty == null ? new boolean[1] : new boolean[]{isDirty[0]};
        } else {
            this.values = values;
            this.isDirty = isDirty;
        }
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected TupleNd(boolean readOnly, double[] values, int n) {
        this(readOnly, values, null, n, true);
    }

    protected TupleNd(boolean readOnly, TupleNd<?> that) {
        this(readOnly, that.values, null, that.values.length, true);
    }

    public TupleNd(int n) {
        this(false, n);
    }

    public TupleNd(double[] values, int n) {
        this(false, values, n);
    }

    public TupleNd(TupleNd<?> that) {
        this(false, that);
    }
}

