/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.vecmath2.util.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TupleNi<T extends TupleNi<T>>
implements Externalizable {
    protected final int N;
    protected final int[] values;
    protected final int roTrick;
    protected final boolean[] isDirty;

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        if (this.isReadOnly()) {
            throw new Error("This instance is read-only.");
        }
        boolean oldValue = this.isDirty[0];
        this.isDirty[0] = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty[0];
    }

    public final int getSize() {
        return this.N;
    }

    public final T setValue(int i, int v) {
        this.values[this.roTrick + i] = v;
        this.isDirty[0] = true;
        return (T)this;
    }

    public final int getValue(int i) {
        return this.values[i];
    }

    public final T set(int[] values, int offset) {
        System.arraycopy(values, offset, this.values, this.roTrick + 0, this.N);
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T set(int[] values) {
        return this.set(values, 0);
    }

    public final T set(T tuple) {
        System.arraycopy(((TupleNi)tuple).values, 0, this.values, this.roTrick + 0, this.N);
        return (T)this;
    }

    public final T get(int[] buffer, int offset) {
        System.arraycopy(this.values, 0, buffer, offset, this.N);
        return (T)this;
    }

    public final T get(int[] buffer) {
        return this.get(buffer, 0);
    }

    public final T get(T buffer) {
        System.arraycopy(this.values, 0, ((TupleNi)buffer).values, 0, this.N);
        return (T)this;
    }

    public final T setZero() {
        int i = 0;
        while (i < this.getSize()) {
            this.setValue(i, 0);
            ++i;
        }
        return (T)this;
    }

    public final T negate(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, -((TupleNi)tuple).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T negate() {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = (int)((float)this.values[n] * -1.0f);
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T absolute() {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = Math.abs(this.values[i]);
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T absolute(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = Math.abs(((TupleNi)tuple).values[i]);
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T add(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNi)tuple1).getValue(i) + ((TupleNi)tuple2).getValue(i));
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T add(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, this.getValue(i) + ((TupleNi)tuple2).getValue(i));
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T sub(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNi)tuple1).values[i] - ((TupleNi)tuple2).values[i]);
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T sub(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, this.values[i] - ((TupleNi)tuple2).values[i]);
            ++i;
        }
        this.isDirty[0] = true;
        return (T)this;
    }

    public final T scale(int factor, T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNi)tuple).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T scale(int factor) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, this.getValue(i) * factor);
            ++i;
        }
        return (T)this;
    }

    public final T scaleAdd(int factor, T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNi)tuple1).values[i] + ((TupleNi)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T scaleAdd(int factor, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * this.values[i] + ((TupleNi)tuple2).values[i]);
            ++i;
        }
        return (T)this;
    }

    public final T clampMin(int min) {
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return (T)this;
    }

    public final T clampMax(int max) {
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return (T)this;
    }

    public final T clamp(int min, int max) {
        this.clampMin(min);
        this.clampMax(max);
        return (T)this;
    }

    public final T clamp(int min, int max, T tuple) {
        this.set(tuple);
        this.clamp(min, max);
        return (T)this;
    }

    public final T clampMin(int min, T tuple) {
        this.set(tuple);
        this.clampMin(min);
        return (T)this;
    }

    public final T clampMax(int max, T tuple) {
        this.set(tuple);
        this.clampMax(max);
        return (T)this;
    }

    public abstract T asReadOnly();

    public abstract T getReadOnly();

    public abstract int hashCode();

    public boolean equals(T t2) {
        if (t2 == null) {
            return false;
        }
        if (this.N != ((TupleNi)t2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) != ((TupleNi)t2).getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof TupleNi && this.equals((TupleNi)tuple2);
    }

    public abstract String toString();

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            this.values[i] = SerializationUtils.readIntFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty[0] = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 4 * this.N + 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected TupleNi(boolean readOnly, int n) {
        this.N = n;
        this.values = new int[n];
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected TupleNi(boolean readOnly, int[] values, boolean[] isDirty, int n, boolean copy) {
        this.N = n;
        if (copy) {
            this.values = new int[n];
            System.arraycopy(values, 0, this.values, 0, this.N);
            this.isDirty = isDirty == null ? new boolean[1] : new boolean[]{isDirty[0]};
        } else {
            this.values = values;
            this.isDirty = isDirty;
        }
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected TupleNi(boolean readOnly, int[] values, int n) {
        this(readOnly, values, null, n, true);
    }

    protected TupleNi(boolean readOnly, TupleNi<?> that) {
        this(readOnly, that.values, null, that.values.length, true);
    }

    public TupleNi(int n) {
        this(false, n);
    }

    public TupleNi(int[] values, int n) {
        this(false, values, n);
    }

    public TupleNi(TupleNi<?> that) {
        this(false, that);
    }
}

