/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMathd;
import org.openmali.vecmath2.Tuple2d;
import org.openmali.vecmath2.pools.Vector2dPool;

public class Vector2d
extends Tuple2d
implements Externalizable {
    private static final long serialVersionUID = -6082359302762117788L;
    public static final Vector2d ZERO = Vector2d.newReadOnly(0.0, 0.0);
    public static final Vector2d POSITIVE_X_AXIS = Vector2d.newReadOnly(1.0, 0.0);
    public static final Vector2d NEGATIVE_X_AXIS = Vector2d.newReadOnly(-1.0, 0.0);
    public static final Vector2d POSITIVE_Y_AXIS = Vector2d.newReadOnly(0.0, 1.0);
    public static final Vector2d NEGATIVE_Y_AXIS = Vector2d.newReadOnly(0.0, -1.0);
    private static final ThreadLocal<Vector2dPool> POOL = new ThreadLocal<Vector2dPool>(){

        @Override
        protected Vector2dPool initialValue() {
            return new Vector2dPool(128);
        }
    };
    private Vector2d readOnlyInstance = null;

    public final double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public final double length() {
        return FastMathd.sqrt(this.lengthSquared());
    }

    public final Vector2d normalize() {
        double l = this.length();
        this.divX(l);
        this.divY(l);
        return this;
    }

    public final Vector2d normalize(Vector2d vector) {
        this.set(vector);
        this.normalize();
        return this;
    }

    public final Vector2d cross(Vector2d v1, Vector2d v2) {
        this.set(v1.getY() * v2.getX() - v1.getX() * v2.getY(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return this;
    }

    public final double dot(Vector2d v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY();
    }

    public final double angle(Vector2d v2) {
        return Math.abs(FastMathd.atan2(this.getX() * v2.getY() - this.getY() * v2.getX(), this.dot(v2)));
    }

    public Vector2d asReadOnly() {
        return new Vector2d(true, this.values, this.isDirty, false);
    }

    public Tuple2d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Vector2d(boolean readOnly, double x, double y) {
        super(readOnly, x, y);
    }

    protected Vector2d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Vector2d(boolean readOnly, Tuple2d tuple) {
        this(readOnly, tuple.getX(), tuple.getY());
    }

    protected Vector2d(boolean readOnly) {
        this(readOnly, 0.0, 0.0);
    }

    public Vector2d(double x, double y) {
        this(false, x, y);
    }

    public Vector2d(double[] values) {
        this(false, values, null, true);
    }

    public Vector2d(Tuple2d tuple) {
        this(false, tuple);
    }

    public Vector2d() {
        this(false);
    }

    public static Vector2d newReadOnly(double x, double y) {
        return new Vector2d(true, x, y);
    }

    public static Vector2d newReadOnly(double[] values) {
        return new Vector2d(true, values, null, true);
    }

    public static Vector2d newReadOnly(Tuple2d tuple) {
        return new Vector2d(true, tuple);
    }

    public static Vector2d newReadOnly() {
        return new Vector2d(true);
    }

    public static Vector2d fromPool() {
        return POOL.get().alloc();
    }

    public static Vector2d fromPool(double x, double y) {
        return POOL.get().alloc(x, y);
    }

    public static Vector2d fromPool(Tuple2d tuple) {
        return Vector2d.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Vector2d o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly() {
        return Vector2d.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(Tuple2d tuple2d) {
        return Vector2d.newReadOnly(tuple2d);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(double[] dArray) {
        return Vector2d.newReadOnly(dArray);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(double d, double d2) {
        return Vector2d.newReadOnly(d, d2);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool(Tuple2d tuple2d) {
        return Vector2d.fromPool(tuple2d);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool(double d, double d2) {
        return Vector2d.fromPool(d, d2);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool() {
        return Vector2d.fromPool();
    }
}

