/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.VectorInterface;
import org.openmali.vecmath2.pools.Vector2fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector2f
extends Tuple2f
implements Externalizable,
VectorInterface<Tuple2f, Vector2f> {
    private static final long serialVersionUID = -6082359302762117788L;
    public static final Vector2f ZERO = Vector2f.newReadOnly(0.0f, 0.0f);
    public static final Vector2f POSITIVE_X_AXIS = Vector2f.newReadOnly(1.0f, 0.0f);
    public static final Vector2f NEGATIVE_X_AXIS = Vector2f.newReadOnly(-1.0f, 0.0f);
    public static final Vector2f POSITIVE_Y_AXIS = Vector2f.newReadOnly(0.0f, 1.0f);
    public static final Vector2f NEGATIVE_Y_AXIS = Vector2f.newReadOnly(0.0f, -1.0f);
    private static final ThreadLocal<Vector2fPool> POOL = new ThreadLocal<Vector2fPool>(){

        @Override
        protected Vector2fPool initialValue() {
            return new Vector2fPool(128);
        }
    };
    private Vector2f readOnlyInstance = null;

    @Override
    public final float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public final float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public final Vector2f normalize() {
        float l = this.length();
        this.divX(l);
        this.divY(l);
        return this;
    }

    public final Vector2f normalize(Vector2f vector) {
        this.set((TupleNf)vector);
        this.normalize();
        return this;
    }

    public final Vector2f cross(Vector2f v1, Vector2f v2) {
        this.set(v1.getY() * v2.getX() - v1.getX() * v2.getY(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return this;
    }

    @Override
    public final float dot(Vector2f v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY();
    }

    @Override
    public final float angle(Vector2f v2) {
        return Math.abs(FastMath.atan2(this.getX() * v2.getY() - this.getY() * v2.getX(), this.dot(v2)));
    }

    @Override
    public Vector2f clone() {
        return new Vector2f(this);
    }

    @Override
    public Vector2f asReadOnly() {
        return new Vector2f(true, this.values, this.isDirty, false);
    }

    @Override
    public Vector2f getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Vector2f(boolean readOnly, float x, float y) {
        super(readOnly, x, y);
    }

    protected Vector2f(boolean readOnly, float[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Vector2f(boolean readOnly, Tuple2f tuple) {
        this(readOnly, tuple.getX(), tuple.getY());
    }

    protected Vector2f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f);
    }

    public Vector2f(float x, float y) {
        this(false, x, y);
    }

    public Vector2f(float[] values) {
        this(false, values, null, true);
    }

    public Vector2f(Tuple2f tuple) {
        this(false, tuple);
    }

    public Vector2f() {
        this(false);
    }

    public static Vector2f newReadOnly(float x, float y) {
        return new Vector2f(true, x, y);
    }

    public static Vector2f newReadOnly(float[] values) {
        return new Vector2f(true, values, null, true);
    }

    public static Vector2f newReadOnly(Tuple2f tuple) {
        return new Vector2f(true, tuple);
    }

    public static Vector2f newReadOnly() {
        return new Vector2f(true);
    }

    public static Vector2f fromPool() {
        return POOL.get().alloc();
    }

    public static Vector2f fromPool(float x, float y) {
        return POOL.get().alloc(x, y);
    }

    public static Vector2f fromPool(Tuple2f tuple) {
        return Vector2f.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Vector2f o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly() {
        return Vector2f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(Tuple2f tuple2f) {
        return Vector2f.newReadOnly(tuple2f);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(float[] fArray) {
        return Vector2f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(float f, float f2) {
        return Vector2f.newReadOnly(f, f2);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool(Tuple2f tuple2f) {
        return Vector2f.fromPool(tuple2f);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool(float f, float f2) {
        return Vector2f.fromPool(f, f2);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool() {
        return Vector2f.fromPool();
    }
}

