/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.MatrixMxNf;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.VectorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorNf
extends TupleNf<VectorNf>
implements Externalizable,
VectorInterface<VectorNf, VectorNf> {
    private static final long serialVersionUID = 8171027992467938290L;
    private VectorNf readOnlyInstance = null;

    public final float getNormSquared() {
        float s = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            s += this.getValue(i) * this.getValue(i);
            ++i;
        }
        return s;
    }

    public final float getNorm() {
        return FastMath.sqrt(this.getNormSquared());
    }

    public final VectorNf normalize() {
        float len = this.getNorm();
        int i = 0;
        while (i < this.getSize()) {
            this.divValue(i, len);
            ++i;
        }
        return this;
    }

    public final VectorNf normalize(VectorNf v) {
        this.set((TupleNf)v);
        this.normalize();
        return this;
    }

    @Override
    public float lengthSquared() {
        return this.getNormSquared();
    }

    @Override
    public float length() {
        return this.getNorm();
    }

    public void mul(MatrixMxNf m, VectorNf v) {
        int vSize = v.getSize();
        int numCols = m.getNumCols();
        int numRows = m.getNumRows();
        if (vSize != numCols) {
            throw new IllegalArgumentException("v1.size:" + vSize + " != m1.nCol:" + numCols);
        }
        if (this.getSize() != numRows) {
            throw new IllegalArgumentException("this.size:" + this.getSize() + " != m1.nRow:" + numRows);
        }
        int i = 0;
        while (i < this.getSize()) {
            float sum = 0.0f;
            int j = 0;
            while (j < numCols) {
                sum += m.get(i, j) * v.getValue(j);
                ++j;
            }
            this.setValue(i, sum);
            ++i;
        }
    }

    public void mul(VectorNf v1, MatrixMxNf m) {
        int v1Size = v1.getSize();
        int cols = m.getNumCols();
        int rows = m.getNumRows();
        if (v1Size != rows) {
            throw new IllegalArgumentException("v1.size:" + v1Size + " != m1.nRow:" + rows);
        }
        if (this.getSize() != cols) {
            throw new IllegalArgumentException("this.size:" + this.getSize() + " != m1.nCol:" + cols);
        }
        int i = 0;
        while (i < this.getSize()) {
            float sum = 0.0f;
            int j = 0;
            while (j < rows) {
                sum += m.get(j, i) * v1.getValue(j);
                ++j;
            }
            this.setValue(i, sum);
            ++i;
        }
    }

    public final VectorNf cross(VectorNf v1, VectorNf v2) {
        int n = this.getSize();
        int i = 0;
        while (i < n) {
            this.setValue(i, v1.getValue((i + 1) % n) * v2.getValue((i + 2) % n) - v1.getValue((i + 2) % n) * v2.getValue((i + 1) % n));
            ++i;
        }
        return this;
    }

    @Override
    public final float dot(VectorNf v2) {
        if (this.getSize() != v2.getSize()) {
            throw new IllegalArgumentException("this.size:" + this.getSize() + " != v1.size:" + v2.getSize());
        }
        float sum = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            sum += this.getValue(i) * v2.getValue(i);
            ++i;
        }
        return sum;
    }

    @Override
    public final float angle(VectorNf v2) {
        return FastMath.acos(this.dot(v2) / this.getNorm() / v2.getNorm());
    }

    public void SVDBackSolve(MatrixMxNf U, MatrixMxNf W, MatrixMxNf V, VectorNf b) {
        float s;
        if (this.getSize() != U.getNumRows() || this.getSize() != U.getNumCols()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.getSize() + " != U.nRow,nCol:" + U.getNumRows() + "," + U.getNumCols());
        }
        if (this.getSize() != W.getNumRows()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.getSize() + " != W.nRow:" + W.getNumRows());
        }
        if (b.getSize() != W.getNumCols()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + b.getSize() + " != W.nCol:" + W.getNumCols());
        }
        if (b.getSize() != V.getNumRows() || b.getSize() != V.getNumCols()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + this.getSize() + " != V.nRow,nCol:" + V.getNumRows() + "," + V.getNumCols());
        }
        int m = U.getNumRows();
        int n = V.getNumRows();
        float[] tmp = new float[n];
        int j = 0;
        while (j < n) {
            s = 0.0f;
            float wj = W.get(j, j);
            if (wj != 0.0f) {
                int i = 0;
                while (i < m) {
                    s += U.get(i, j) * b.getValue(i);
                    ++i;
                }
                s /= wj;
            }
            tmp[j] = s;
            ++j;
        }
        j = 0;
        while (j < n) {
            s = 0.0f;
            int jj = 0;
            while (jj < n) {
                s += V.get(j, jj) * tmp[jj];
                ++jj;
            }
            this.setValue(j, s);
            ++j;
        }
    }

    public void LUDBackSolve(MatrixMxNf lu, VectorNf b, VectorNf permutation) {
        int j;
        float sum;
        if (this.getSize() != b.getSize()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.getSize() + " != b.size:" + b.getSize());
        }
        if (this.getSize() != lu.getNumRows()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.getSize() + " != LU.nRow:" + lu.getNumRows());
        }
        if (this.getSize() != lu.getNumCols()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.getSize() + " != LU.nCol:" + lu.getNumCols());
        }
        int n = this.getSize();
        int i = 0;
        while (i < n) {
            this.setValue(i, b.getValue((int)permutation.getValue(i)));
            ++i;
        }
        int ii = -1;
        int i2 = 0;
        while (i2 < n) {
            sum = this.getValue(i2);
            if (ii >= 0) {
                j = ii;
                while (j <= i2 - 1) {
                    sum -= lu.get(i2, j) * this.getValue(j);
                    ++j;
                }
            } else if (sum != 0.0f) {
                ii = i2;
            }
            this.setValue(i2, sum);
            ++i2;
        }
        i2 = n - 1;
        while (i2 >= 0) {
            sum = this.getValue(i2);
            j = i2 + 1;
            while (j < n) {
                sum -= lu.get(i2, j) * this.getValue(j);
                ++j;
            }
            this.setValue(i2, sum / lu.get(i2, i2));
            --i2;
        }
    }

    @Override
    public VectorNf asReadOnly() {
        return new VectorNf(true, this.values, this.isDirty, false);
    }

    @Override
    public VectorNf getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    public Object clone() {
        return new VectorNf(this);
    }

    protected VectorNf(boolean readOnly, int length) {
        super(readOnly, length);
    }

    protected VectorNf(boolean readOnly, float[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, values.length, copy);
    }

    protected VectorNf(boolean readOnly, float[] values, int start, int length) {
        this(readOnly, length);
        System.arraycopy(values, start, this.values, 0, length);
    }

    protected VectorNf(boolean readOnly, TupleNf<?> vector) {
        super(readOnly, vector);
    }

    public VectorNf(int length) {
        this(false, length);
    }

    public VectorNf(float[] values) {
        this(false, values, null, true);
    }

    public VectorNf(float[] values, int start, int length) {
        this(false, values, start, length);
    }

    public VectorNf(TupleNf<?> vector) {
        this(false, vector);
    }

    public static VectorNf newReadOnly(int length) {
        return new VectorNf(true, length);
    }

    public static VectorNf newReadOnly(float[] values) {
        return new VectorNf(true, values, null, true);
    }

    public static VectorNf newReadOnly(float[] values, int start, int length) {
        return new VectorNf(true, values, start, length);
    }

    public static VectorNf newReadOnly(TupleNf<?> vector) {
        return new VectorNf(true, vector);
    }
}

