/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.FloatUtils;
import org.openmali.vecmath2.util.TupleUtils;

public class MatrixUtils {
    public static void matrixToEuler(Matrix3f matrix, Tuple3f euler) {
        if (matrix.m10() == 1.0f) {
            euler.setX(0.0f);
            euler.setY(FastMath.atan2(matrix.m02(), matrix.m22()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        } else if (matrix.m10() == -1.0f) {
            euler.setX(0.0f);
            euler.setY(FastMath.atan2(matrix.m02(), matrix.m22()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        } else {
            euler.setX(FastMath.atan2(-matrix.m12(), matrix.m11()));
            euler.setY(FastMath.atan2(-matrix.m20(), matrix.m00()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        }
    }

    public static Tuple3f matrixToEuler(Matrix3f matrix) {
        Tuple3f euler = new Tuple3f();
        MatrixUtils.matrixToEuler(matrix, euler);
        return euler;
    }

    public static void matrixToEuler(Matrix4f matrix, Tuple3f euler) {
        if (matrix.m10() == 1.0f) {
            euler.setX(0.0f);
            euler.setY(FastMath.atan2(matrix.m02(), matrix.m22()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        } else if (matrix.m10() == -1.0f) {
            euler.setX(0.0f);
            euler.setY(FastMath.atan2(matrix.m02(), matrix.m22()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        } else {
            euler.setX(FastMath.atan2(-matrix.m12(), matrix.m11()));
            euler.setY(FastMath.atan2(-matrix.m20(), matrix.m00()));
            euler.setZ(FastMath.asin(-matrix.m10()));
        }
    }

    public static Tuple3f matrixToEuler(Matrix4f matrix) {
        Tuple3f euler = new Tuple3f();
        MatrixUtils.matrixToEuler(matrix, euler);
        return euler;
    }

    public static void eulerToMatrix3f(float eulerX, float eulerY, float eulerZ, Matrix3f matrix) {
        float sx = FastMath.sin(eulerX);
        float sy = FastMath.sin(eulerY);
        float sz = FastMath.sin(eulerZ);
        float cx = FastMath.cos(eulerX);
        float cy = FastMath.cos(eulerY);
        float cz = FastMath.cos(eulerZ);
        matrix.set(0, 0, cy * cz);
        matrix.set(0, 1, -(cx * sz) + sx * sy * cz);
        matrix.set(0, 2, sx * sz + cx * sy * cz);
        matrix.set(1, 0, cy * sz);
        matrix.set(1, 1, cx * cz + sx * sy * sz);
        matrix.set(1, 2, -(sx * cz) + cx * sy * sz);
        matrix.set(2, 0, -sy);
        matrix.set(2, 1, sx * cy);
        matrix.set(2, 2, cx * cy);
    }

    public static void eulerToMatrix3f(Tuple3f euler, Matrix3f matrix) {
        MatrixUtils.eulerToMatrix3f(euler.getX(), euler.getY(), euler.getZ(), matrix);
    }

    public static Matrix3f eulerToMatrix3f(float eulerX, float eulerY, float eulerZ) {
        Matrix3f matrix = new Matrix3f();
        MatrixUtils.eulerToMatrix3f(eulerX, eulerY, eulerZ, matrix);
        return matrix;
    }

    public static Matrix3f eulerToMatrix3f(Tuple3f euler) {
        Matrix3f matrix = new Matrix3f();
        MatrixUtils.eulerToMatrix3f(euler.getX(), euler.getY(), euler.getZ(), matrix);
        return matrix;
    }

    public static void eulerToMatrix4f(float eulerX, float eulerY, float eulerZ, Matrix4f matrix) {
        float sx = FastMath.sin(eulerX);
        float sy = FastMath.sin(eulerY);
        float sz = FastMath.sin(eulerZ);
        float cx = FastMath.cos(eulerX);
        float cy = FastMath.cos(eulerY);
        float cz = FastMath.cos(eulerZ);
        matrix.set(0, 0, cy * cz);
        matrix.set(0, 1, -(cx * sz) + sx * sy * cz);
        matrix.set(0, 2, sx * sz + cx * sy * cz);
        matrix.set(1, 0, cy * sz);
        matrix.set(1, 1, cx * cz + sx * sy * sz);
        matrix.set(1, 2, -(sx * cz) + cx * sy * sz);
        matrix.set(2, 0, -sy);
        matrix.set(2, 1, sx * cy);
        matrix.set(2, 2, cx * cy);
        matrix.set(3, 3, 1.0f);
    }

    public static void eulerToMatrix4f(Tuple3f euler, Matrix4f matrix) {
        MatrixUtils.eulerToMatrix4f(euler.getX(), euler.getY(), euler.getZ(), matrix);
    }

    public static Matrix4f eulerToMatrix4f(Tuple3f euler) {
        Matrix4f matrix = new Matrix4f();
        MatrixUtils.eulerToMatrix4f(euler.getX(), euler.getY(), euler.getZ(), matrix);
        return matrix;
    }

    public static Matrix4f eulerToMatrix4f(float eulerX, float eulerY, float eulerZ) {
        Matrix4f matrix = new Matrix4f();
        MatrixUtils.eulerToMatrix4f(eulerX, eulerY, eulerZ, matrix);
        return matrix;
    }

    public static final void getRotationMatrix(float axisX, float axisY, float axisZ, float angle, Matrix3f out) {
        float length = FloatUtils.vectorLength(axisX, axisY, axisZ);
        float v1 = axisX / length;
        float v2 = axisY / length;
        float v3 = axisZ / length;
        float v1q = v1 * v1;
        float v2q = v2 * v2;
        float v3q = v3 * v3;
        float a = angle;
        float sin_a = FastMath.sin(a);
        float cos_a = FastMath.cos(a);
        float m11 = cos_a + v1q * (1.0f - cos_a);
        float m12 = v1 * v2 * (1.0f - cos_a) - v3 * sin_a;
        float m13 = v1 * v3 * (1.0f - cos_a) + v2 * sin_a;
        float m21 = v2 * v1 * (1.0f - cos_a) + v3 * sin_a;
        float m22 = cos_a + v2q * (1.0f - cos_a);
        float m23 = v2 * v3 * (1.0f - cos_a) - v1 * sin_a;
        float m31 = v3 * v1 * (1.0f - cos_a) - v2 * sin_a;
        float m32 = v3 * v2 * (1.0f - cos_a) + v1 * sin_a;
        float m33 = cos_a + v3q * (1.0f - cos_a);
        out.m00(m11);
        out.m01(m12);
        out.m02(m13);
        out.m10(m21);
        out.m11(m22);
        out.m12(m23);
        out.m20(m31);
        out.m21(m32);
        out.m22(m33);
    }

    public static final Matrix3f getRotationMatrix(float axisX, float axisY, float axisZ, float angle) {
        Matrix3f result = new Matrix3f();
        MatrixUtils.getRotationMatrix(axisX, axisY, axisZ, angle, result);
        return result;
    }

    public static final Matrix3f getRotationMatrixX(float angle) {
        return MatrixUtils.getRotationMatrix(1.0f, 0.0f, 0.0f, angle);
    }

    public static final Matrix3f getRotationMatrixY(float angle) {
        return MatrixUtils.getRotationMatrix(0.0f, 1.0f, 0.0f, angle);
    }

    public static final Matrix3f getRotationMatrixZ(float angle) {
        return MatrixUtils.getRotationMatrix(0.0f, 0.0f, 1.0f, angle);
    }

    public static void getRotationMatrix(Tuple3f axis, float angle, Matrix3f out) {
        MatrixUtils.getRotationMatrix(axis.getX(), axis.getY(), axis.getZ(), angle, out);
    }

    public static Matrix3f getRotationMatrix(Tuple3f axis, float angle) {
        return MatrixUtils.getRotationMatrix(axis.getX(), axis.getY(), axis.getZ(), angle);
    }

    public static final Matrix3f computeRotation(float v1x, float v1y, float v1z, float v2x, float v2y, float v2z, int normalize, Matrix3f result) {
        AxisAngle3f rotation = AxisAngle3f.fromPool();
        FloatUtils.computeRotation(v1x, v1y, v1z, v2x, v2y, v2z, normalize, rotation);
        result.set(rotation);
        AxisAngle3f.toPool(rotation);
        return result;
    }

    public static final Matrix3f computeRotation(Tuple3f v1, Tuple3f v2, int normalize, Matrix3f result) {
        AxisAngle3f rotation = AxisAngle3f.fromPool();
        TupleUtils.computeRotation(v1, v2, normalize, rotation);
        result.set(rotation);
        AxisAngle3f.toPool(rotation);
        return result;
    }
}

