/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.xml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode {
    private String name;
    private XMLNode parent;
    private Map<String, String> attributes;
    private Map<String, List<XMLNode>> children;
    private String text = "";

    public XMLNode(String name, XMLNode parent) {
        this.name = name;
        this.parent = parent;
        this.attributes = new HashMap<String, String>();
        this.children = new HashMap<String, List<XMLNode>>();
    }

    public String getName() {
        return this.name;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void addChild(String name, XMLNode child) {
        List<XMLNode> nodes = this.children.get(name);
        if (nodes == null) {
            nodes = new LinkedList<XMLNode>();
        }
        nodes.add(child);
        this.children.put(name, nodes);
    }

    public void setText(String text) {
        this.text = this.text + text;
    }

    public String get(String path, String fallback) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            List<XMLNode> ch = this.children.get(split[0]);
            if (ch == null) {
                return fallback;
            }
            return ch.get(0).get(split[1], fallback);
        }
        if (this.attributes.get(path) == null) {
            return fallback;
        }
        return this.attributes.get(path);
    }

    public String getText(String path, String fallback) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            List<XMLNode> ch = this.children.get(split[0]);
            if (ch == null) {
                return fallback;
            }
            return ch.get(0).getText(split[1], fallback);
        }
        if (!this.children.containsKey(path)) {
            return fallback;
        }
        List<XMLNode> ch = this.children.get(path);
        return ch.get((int)0).text;
    }

    public List<XMLNode> getAll(String path) {
        if (path.contains(".")) {
            String[] split = path.split("\\.", 2);
            List<XMLNode> ch = this.children.get(split[0]);
            if (ch == null) {
                LinkedList<XMLNode> l = new LinkedList<XMLNode>();
                return l;
            }
            return ch.get(0).getAll(split[1]);
        }
        if (!this.children.containsKey(path)) {
            LinkedList<XMLNode> l = new LinkedList<XMLNode>();
            return l;
        }
        return this.children.get(path);
    }
}

