/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;

public class SqlTool {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlTool.class);
    public static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static String revnum = "$Revision: 3481 $".substring("$Revision: ".length(), "$Revision: 3481 $".length() - 2);
    public static final int SQLTOOLERR_EXITVAL = 1;
    public static final int SYNTAXERR_EXITVAL = 11;
    public static final int RCERR_EXITVAL = 2;
    public static final int SQLERR_EXITVAL = 3;
    public static final int IOERR_EXITVAL = 4;
    public static final int FILEERR_EXITVAL = 5;
    public static final int INPUTERR_EXITVAL = 6;
    public static final int CONNECTERR_EXITVAL = 7;
    private static String CMDLINE_ID = "cmdline";
    public static String LS = System.getProperty("line.separator");
    private static BadCmdline bcl = new BadCmdline();

    private static String promptForPassword(String string) throws PrivateException {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(SqltoolRB.passwordFor_prompt.getString(RCData.expandSysPropVars(string)));
            string2 = bufferedReader.readLine();
            string2 = string2 == null ? "" : string2.trim();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException.getMessage());
        }
        finally {
            Object var1_3 = null;
        }
        return string2;
    }

    private static void varParser(String string, Map<String, String> map, boolean bl) throws PrivateException {
        if (map == null) {
            throw new IllegalArgumentException("varMap is null in SqlTool.varParser call");
        }
        if (string == null) {
            throw new IllegalArgumentException("varString is null in SqlTool.varParser call");
        }
        for (String string2 : string.split("\\s*,\\s*")) {
            int n = string2.indexOf(61);
            if (n < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            if (bl) {
                string3 = string3.toLowerCase();
            }
            map.put(string3, string4);
        }
    }

    public static void main(String[] stringArray) {
        try {
            SqlTool.objectMain(stringArray);
        }
        catch (SqlToolException sqlToolException) {
            System.err.println(sqlToolException.getMessage() == null ? sqlToolException : sqlToolException.getMessage());
            System.exit(sqlToolException.exitValue);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void objectMain(String[] stringArray) throws SqlToolException {
        Object object;
        Object object2;
        logger.finer("Invoking SqlTool");
        String string = null;
        PipedReader pipedReader = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        File[] fileArray = null;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Boolean bl7 = null;
        Boolean bl8 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        HashMap<String, String> hashMap = null;
        SqlFile[] sqlFileArray = null;
        Connection connection = null;
        Map<String, String> map = null;
        try {
            void var33_55;
            block108: {
                try {
                    while (n + 1 < stringArray.length && stringArray[n + 1].startsWith("--") && stringArray[++n].length() != 2) {
                        String string13 = stringArray[n].substring(2).toLowerCase();
                        if (string13.equals("help")) {
                            System.out.println(SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                            pipedReader = null;
                            return;
                        }
                        if (string13.equals("abortonerr")) {
                            if (bl7 != null) {
                                throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                            }
                            bl7 = Boolean.FALSE;
                            continue;
                        }
                        if (string13.equals("continueonerr")) {
                            if (bl7 != null) {
                                throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                            }
                            bl7 = Boolean.TRUE;
                            continue;
                        }
                        if (string13.startsWith("continueonerr=")) {
                            if (bl7 != null) {
                                throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                            }
                            bl7 = Boolean.valueOf(stringArray[n].substring("--continueonerr=".length()));
                            continue;
                        }
                        if (string13.equals("list")) {
                            bl2 = true;
                            continue;
                        }
                        if (string13.equals("rcfile")) {
                            if (++n == stringArray.length) {
                                throw bcl;
                            }
                            string = stringArray[n];
                            continue;
                        }
                        if (string13.startsWith("rcfile=")) {
                            string = stringArray[n].substring("--rcfile=".length());
                            continue;
                        }
                        if (string13.equals("setvar")) {
                            if (++n == stringArray.length) {
                                throw bcl;
                            }
                            string5 = stringArray[n];
                            continue;
                        }
                        if (string13.startsWith("setvar=")) {
                            string5 = stringArray[n].substring("--setvar=".length());
                            continue;
                        }
                        if (string13.equals("sql")) {
                            bl4 = true;
                            if (++n == stringArray.length) {
                                throw bcl;
                            }
                            string2 = stringArray[n];
                            continue;
                        }
                        if (string13.startsWith("sql=")) {
                            bl4 = true;
                            string2 = stringArray[n].substring("--sql=".length());
                            continue;
                        }
                        if (string13.equals("debug")) {
                            bl = true;
                            continue;
                        }
                        if (string13.equals("noautofile")) {
                            bl5 = true;
                            continue;
                        }
                        if (string13.equals("autocommit")) {
                            bl6 = true;
                            continue;
                        }
                        if (string13.equals("stdinput")) {
                            bl4 = false;
                            bl8 = Boolean.TRUE;
                            continue;
                        }
                        if (string13.equals("noinput")) {
                            bl4 = true;
                            bl8 = Boolean.FALSE;
                            continue;
                        }
                        if (string13.equals("driver")) {
                            if (++n == stringArray.length) {
                                throw bcl;
                            }
                            string3 = stringArray[n];
                            continue;
                        }
                        if (string13.startsWith("driver=")) {
                            string3 = stringArray[n].substring("--driver=".length());
                            continue;
                        }
                        if (string13.equals("inlinerc")) {
                            if (++n == stringArray.length) {
                                throw bcl;
                            }
                            string6 = stringArray[n];
                            continue;
                        }
                        if (!string13.startsWith("inlinerc=")) throw bcl;
                        string6 = stringArray[n].substring("--inlinerc=".length());
                    }
                    if (!bl2 && string6 == null && ++n != stringArray.length && (string4 = stringArray[n]).equals("-")) {
                        string4 = null;
                    }
                    int n2 = 0;
                    if (string2 != null) {
                        try {
                            pipedReader = new PipedReader();
                            object2 = new PipedWriter(pipedReader);
                            try {
                                ((Writer)object2).write(string2 + LS);
                                ((PipedWriter)object2).flush();
                            }
                            finally {
                                try {
                                    ((PipedWriter)object2).close();
                                }
                                finally {
                                    object2 = null;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            throw new SqlToolException(4, SqltoolRB.sqltempfile_fail.getString(iOException.toString()));
                        }
                    }
                    if (bl8 != null) {
                        bl4 = bl8 == false;
                    }
                    boolean bl9 = bl3 = !bl4 && stringArray.length <= n + 1;
                    if (stringArray.length == n + 2 && stringArray[n + 1].equals("-")) {
                        if (bl8 == null) {
                            bl4 = false;
                        }
                        break block108;
                    }
                    if (stringArray.length <= n + 1) break block108;
                    fileArray = new File[stringArray.length - n - 1 + (bl8 == null || bl8 == false ? 0 : 1)];
                    if (bl) {
                        System.err.println("scriptFiles has " + fileArray.length + " elements");
                    }
                    while (n + 1 < stringArray.length) {
                        fileArray[n2++] = new File(stringArray[++n]);
                    }
                    if (bl8 != null && bl8.booleanValue()) {
                        fileArray[n2++] = null;
                        bl4 = true;
                    }
                }
                catch (BadCmdline badCmdline) {
                    throw new SqlToolException(11, SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                }
            }
            object = null;
            if (string6 != null) {
                hashMap = new HashMap<String, String>();
                try {
                    SqlTool.varParser(string6, hashMap, true);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(11, privateException.getMessage());
                }
                string7 = (String)hashMap.remove("url");
                string8 = (String)hashMap.remove("user");
                string10 = (String)hashMap.remove("charset");
                string11 = (String)hashMap.remove("truststore");
                string9 = (String)hashMap.remove("password");
                string12 = (String)hashMap.remove("transiso");
                if (string7 == null) throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                if (string7.length() < 1) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                }
                if (string9 != null && string9.length() > 0) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_password_visible.getString());
                }
                if (hashMap.size() > 0) {
                    throw new SqlToolException(6, SqltoolRB.rcdata_inline_extravars.getString(hashMap.keySet().toString()));
                }
                if (string8 != null && string9 == null) {
                    try {
                        string9 = SqlTool.promptForPassword(string8);
                    }
                    catch (PrivateException privateException) {
                        throw new SqlToolException(6, SqltoolRB.password_readfail.getString(privateException.getMessage()));
                    }
                }
                try {
                    object = new RCData(CMDLINE_ID, string7, string8, string9, string3, string10, string11, null, string12);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_genfromvalues_fail.getString());
                }
            }
            if (bl2 || string4 != null) {
                try {
                    object = new RCData(new File(string == null ? DEFAULT_RCFILE : string), string4);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, SqltoolRB.conndata_retrieval_fail.getString(string4, exception.getMessage()));
                }
            }
            if (bl2) {
                pipedReader = null;
                return;
            }
            if (bl3) {
                System.out.print("SqlTool v. " + revnum + '.' + LS);
            }
            if (object != null) {
                try {
                    connection = ((RCData)object).getConnection(string3, System.getProperty("javax.net.ssl.trustStore"));
                    connection.setAutoCommit(bl6);
                    if (bl3 && (object2 = SqlFile.getBanner(connection)) != null) {
                        System.out.println((String)object2);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    if (bl) {
                        logger.error(exception.getClass().getName(), exception);
                    }
                    String string14 = ((RCData)object).username == null ? "<DFLTUSER>" : ((RCData)object).username;
                    throw new SqlToolException(7, SqltoolRB.connection_fail.getString(((RCData)object).url, string14, exception.getMessage()));
                }
            }
            object2 = new File[]{};
            File[] fileArray2 = new File[]{null};
            File file = null;
            if (!(!bl3 || bl5 || (file = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && file.canRead())) {
                file = null;
            }
            if (fileArray == null) {
                fileArray = bl4 ? object2 : fileArray2;
            }
            int n3 = fileArray.length;
            if (pipedReader != null) {
                void var33_54;
                ++var33_54;
            }
            if (file != null) {
                ++var33_55;
            }
            sqlFileArray = new SqlFile[var33_55];
            if (string5 != null) {
                try {
                    map = new HashMap<String, String>();
                    SqlTool.varParser(string5, map, false);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(2, privateException.getMessage());
                }
            }
            int n4 = -1;
            String string15 = object == null ? null : ((RCData)object).charset;
            try {
                int n5 = 0;
                if (file != null) {
                    sqlFileArray[n5++] = new SqlFile(file, string15);
                }
                if (pipedReader != null) {
                    sqlFileArray[n5++] = new SqlFile(pipedReader, "--sql", System.out, null, false);
                }
                for (File file2 : fileArray) {
                    if (n4 < 0 && bl3) {
                        n4 = n5;
                    }
                    sqlFileArray[n5++] = file2 == null ? new SqlFile(string15, bl3) : new SqlFile(file2, string15, bl3);
                }
            }
            catch (IOException iOException) {
                try {
                    if (connection == null) throw new SqlToolException(5, iOException.getMessage());
                    connection.close();
                    throw new SqlToolException(5, iOException.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SqlToolException(5, iOException.getMessage());
            }
        }
        finally {
            pipedReader = null;
        }
        object = null;
        try {
            object2 = sqlFileArray;
            int n6 = ((File[])object2).length;
            int n7 = 0;
            while (n7 < n6) {
                File file = object2[n7];
                if (connection != null) {
                    ((SqlFile)((Object)file)).setConnection(connection);
                }
                if (map != null) {
                    ((SqlFile)((Object)file)).addUserVars(map);
                }
                if (object != null) {
                    ((SqlFile)((Object)file)).addMacros((Map<String, Token>)object);
                }
                if (bl7 != null) {
                    ((SqlFile)((Object)file)).setContinueOnError(bl7);
                }
                ((SqlFile)((Object)file)).execute();
                map = ((SqlFile)((Object)file)).getUserVars();
                object = ((SqlFile)((Object)file)).getMacros();
                connection = ((SqlFile)((Object)file)).getConnection();
                ++n7;
            }
            return;
        }
        catch (SqlToolError sqlToolError) {
            throw new SqlToolException(1);
        }
        catch (SQLException sQLException) {
            throw new SqlToolException(3);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class SqlToolException
    extends Exception {
        static final long serialVersionUID = 1424909871915188519L;
        int exitValue = 1;

        SqlToolException(String string, int n) {
            super(string);
            this.exitValue = n;
        }

        SqlToolException(int n, String string) {
            this(string, n);
        }

        SqlToolException(int n) {
            this.exitValue = n;
        }
    }

    private static class PrivateException
    extends Exception {
        static final long serialVersionUID = -7765061479594523462L;

        PrivateException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        static final long serialVersionUID = -2134764796788108325L;

        BadCmdline() {
        }
    }
}

