/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.LoadAgent;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.SaveAgent;

public class Agent_AgentManager
extends jade.core.Agent {
    Connection db;
    Logger log;
    Codec codec = new SLCodec();
    Ontology ontology = MessagesOntology.getInstance();

    public Agent_AgentManager() {
        try {
            this.db = DriverManager.getConnection("jdbc:hsqldb:file:data/db/pikaterdb", "", "");
            Logger.getRootLogger().addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %-5p %c - %m%n"), "log"));
            this.log = Logger.getLogger(Agent_AgentManager.class);
            this.log.setLevel(Level.TRACE);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setup() {
        super.setup();
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        MessageTemplate mt = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)this.ontology.getName()), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        this.addBehaviour((Behaviour)new AchieveREResponder(this, mt){
            private static final long serialVersionUID = 7L;

            protected ACLMessage handleRequest(ACLMessage request) throws NotUnderstoodException, RefuseException {
                Agent_AgentManager.this.log.info((Object)("Agent " + Agent_AgentManager.this.getLocalName() + " received request: " + request.getContent()));
                try {
                    Action a = (Action)Agent_AgentManager.this.getContentManager().extractContent(request);
                    if (a.getAction() instanceof LoadAgent) {
                        LoadAgent la = (LoadAgent)a.getAction();
                        Execute fa = la.getFirst_action();
                        jade.core.Agent newAgent = null;
                        if (la.getObject() != null) {
                            newAgent = (jade.core.Agent)Agent_AgentManager.toObject(la.getObject());
                        } else {
                            String filename = "saved" + System.getProperty("file.separator") + la.getFilename() + ".model";
                            System.out.println(filename);
                            ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(filename));
                            newAgent = (jade.core.Agent)inputStream.readObject();
                        }
                        System.out.print("Ozivenej: " + newAgent);
                        if (newAgent == null) {
                            throw new ControllerException("Agent not created.");
                        }
                        AgentContainer container = Agent_AgentManager.this.getContainerController();
                        AgentController controller = container.acceptNewAgent(la.getFilename(), newAgent);
                        controller.start();
                        Agent_AgentManager.this.log.info((Object)("Loaded agent:   " + la.getFilename()));
                        ACLMessage reply = null;
                        if (fa != null) {
                            Action ac = new Action();
                            ac.setAction((Concept)fa);
                            ac.setActor(request.getSender());
                            ACLMessage first_message = new ACLMessage(16);
                            first_message.setLanguage(Agent_AgentManager.this.codec.getName());
                            first_message.setOntology(Agent_AgentManager.this.ontology.getName());
                            first_message.addReceiver(new AID(la.getFilename(), false));
                            first_message.clearAllReplyTo();
                            first_message.addReplyTo(request.getSender());
                            first_message.setProtocol("fipa-request");
                            first_message.setConversationId(request.getConversationId());
                            Agent_AgentManager.this.getContentManager().fillContent(first_message, (ContentElement)ac);
                            Agent_AgentManager.this.send(first_message);
                        }
                        reply = request.createReply();
                        reply.setContent("Agent " + newAgent.getLocalName() + " resurected.");
                        reply.setPerformative(7);
                        return reply;
                    }
                    if (a.getAction() instanceof SaveAgent) {
                        SaveAgent sa = (SaveAgent)a.getAction();
                        int userID = sa.getUserID();
                        Agent agent = sa.getAgent();
                        String name = agent.getName();
                        Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTime().getTime());
                        String filename = userID + "_" + name + "_" + currentTimestamp.toString().replace(":", "-").replace(" ", "_");
                        byte[] object = sa.getAgent().getObject();
                        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("saved" + System.getProperty("file.separator") + filename + ".model"));
                        jade.core.Agent newAgent = (jade.core.Agent)Agent_AgentManager.toObject(object);
                        oos.writeObject(Agent_AgentManager.toObject(object));
                        oos.flush();
                        oos.close();
                        Agent_AgentManager.this.log.info((Object)("Agent " + name + " saved to file" + filename + ".model"));
                        ACLMessage reply = request.createReply();
                        reply.setContent(filename);
                        reply.setPerformative(7);
                        return reply;
                    }
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                    Agent_AgentManager.this.log.error((Object)("Problem extracting content: " + e.getMessage()));
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                    Agent_AgentManager.this.log.error((Object)("Codec problem: " + e.getMessage()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (StaleProxyException e) {
                    e.printStackTrace();
                }
                catch (ControllerException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                ACLMessage failure = request.createReply();
                failure.setPerformative(6);
                Agent_AgentManager.this.log.error((Object)("Failure responding to request: " + request.getContent()));
                return failure;
            }
        });
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static Object toObject(byte[] bytes) throws IOException, ClassNotFoundException {
        Object object = null;
        object = new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        return object;
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH.mm.ss");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

