/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Result;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;
import org.jdom.JDOMException;
import pikater.Agent_GUI;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.Results;
import pikater.ontology.messages.Task;

public class Agent_GUI_config_file
extends Agent_GUI {
    private static final long serialVersionUID = -709390383325209787L;
    private String path = System.getProperty("user.dir") + System.getProperty("file.separator");
    private String configFileName;

    protected void displayResult(ACLMessage inform) {
        try {
            Result result;
            ContentElement content = this.getContentManager().extractContent(inform);
            if (content instanceof Result && (result = (Result)content).getValue() instanceof Results) {
                List tasks = ((Results)result.getValue()).getResults();
                if (tasks != null) {
                    for (Task task : tasks) {
                        System.out.println("Agent " + this.getLocalName() + ": options for agent " + task.getAgent().getName() + " were " + task.getAgent().optionsToString() + " error_rate: " + task.getResult().getError_rate());
                    }
                } else {
                    System.out.println("Agent " + this.getLocalName() + ": there were no tasks in this computation.");
                }
            }
        }
        catch (UngroundedException e) {
            e.printStackTrace();
        }
        catch (Codec.CodecException e) {
            System.out.println("Agent " + this.getLocalName() + " " + inform.getContent());
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
    }

    protected void displayResurrectedResult(ACLMessage inform) {
        try {
            ContentElement content = this.getContentManager().extractContent(inform);
            if (content instanceof Result) {
                Result result = (Result)content;
                if (result.getValue() instanceof Evaluation) {
                    Evaluation eval = (Evaluation)result.getValue();
                    System.out.println("Agent " + this.getLocalName() + ": " + " error_rate: " + eval.getError_rate());
                    List dataList = eval.getLabeled_data();
                    Iterator itr = dataList.iterator();
                    while (itr.hasNext()) {
                        System.out.println("Instances: " + ((DataInstances)itr.next()).getInstances());
                    }
                }
            } else {
                System.out.println("Agent " + this.getLocalName() + ": there were no tasks in this computation.");
            }
        }
        catch (UngroundedException e) {
            e.printStackTrace();
        }
        catch (Codec.CodecException e) {
            System.out.println("Agent " + this.getLocalName() + " " + inform.getContent());
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
    }

    protected void displayTaskResult(ACLMessage inform) {
        try {
            ContentElement content = this.getContentManager().extractContent(inform);
            System.out.println(content);
            if (content instanceof Result) {
                Result result = (Result)content;
                if (result.getValue() instanceof Task) {
                    Task task = (Task)result.getValue();
                    System.out.println("Agent " + this.getLocalName() + ": options for agent " + task.getAgent().getName() + " were " + task.getAgent().optionsToString() + " error_rate: " + task.getResult().getError_rate());
                }
            } else {
                System.out.println("Agent " + this.getLocalName() + ": there were no tasks in this computation.");
            }
        }
        catch (UngroundedException e) {
            e.printStackTrace();
        }
        catch (Codec.CodecException e) {
            System.out.println("Agent " + this.getLocalName() + " " + inform.getContent());
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
    }

    protected void DisplayWrongOption(int problemGuiId, String agentName, String optionName, String errorMessage) {
        System.out.println("Agent :" + this.getName() + " " + problemGuiId + " " + agentName + " " + optionName + " " + errorMessage);
    }

    protected void allOptionsReceived(int problem_id) {
        this.sendProblem(problem_id);
    }

    protected String getAgentType() {
        return "GUI config file";
    }

    protected void mySetup() {
        this.setDefault_number_of_values_to_try(3);
        this.setDefault_error_rate(0.01);
        this.doWait(1000L);
        System.out.println("Agent types: " + this.offerAgentTypes());
        this.configFileName = this.getConfigFileName();
        try {
            System.out.println("file:" + System.getProperty("file.separator") + System.getProperty("file.separator") + System.getProperty("user.dir") + System.getProperty("file.separator") + this.configFileName);
            this.getProblemsFromXMLFile(this.configFileName);
        }
        catch (JDOMException e) {
            System.out.println(this.configFileName + " is not well-formed. " + e.getMessage());
        }
        catch (IOException e) {
            System.out.print("Could not check " + this.configFileName);
            System.out.println(" because " + e.getMessage());
        }
        String agentName = "1_RBFNetwork1_2011-05-22_23-17-33.112";
    }

    protected void displayPartialResult(ACLMessage inform) {
        System.out.println("Partial results");
    }

    private String getConfigFileName() {
        return (String)this.getArguments()[0];
    }

    protected void onGuiEvent(GuiEvent arg0) {
    }

    protected void displayFileImportProgress(int completed, int all) {
    }
}

