/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.core.Agent;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import pikater.ontology.messages.MessagesOntology;

public class Agent_Initiator
extends Agent {
    private Codec codec = new SLCodec();
    private Ontology ontology = MessagesOntology.getInstance();
    private static final long serialVersionUID = -3908734088006529947L;
    private String path = System.getProperty("user.dir") + System.getProperty("file.separator");

    protected void setup() {
        this.getContentManager().registerLanguage((Codec)new SLCodec(), "fipa-sl");
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        try {
            FileReader input = new FileReader(this.path + "init");
            BufferedReader bufRead = new BufferedReader(input);
            int count = 0;
            String line = bufRead.readLine();
            ++count;
            while (line != null) {
                System.out.println(count + ": " + line);
                String delims = "[ ]+";
                String[] params = line.split(delims);
                if (params[0].equals("$a")) {
                    Object[] rest_of_the_array = new String[params.length - 3];
                    for (int i = 3; i < params.length; ++i) {
                        rest_of_the_array[i - 3] = params[i];
                    }
                    this.CreateAgent(params[1], params[2], rest_of_the_array);
                }
                if (params[0].equals("$l")) {
                    Object[] p = new String[]{"load"};
                    this.CreateAgent(params[1], params[2], p);
                }
                line = bufRead.readLine();
                ++count;
            }
            bufRead.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java ReadFile filename\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int CreateAgent(String type, String name, Object[] args) {
        AgentContainer container = this.getContainerController();
        try {
            AgentController agent = container.createNewAgent(name, type, args);
            agent.start();
            this.doWait(300L);
        }
        catch (ControllerException e) {
            System.err.println("Exception while adding agent: " + (Object)((Object)e));
            e.printStackTrace();
            return 0;
        }
        return 1;
    }
}

