/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.proto.IteratedAchieveREInitiator;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Date;
import java.util.Vector;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Computation;
import pikater.ontology.messages.Compute;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Option;
import pikater.ontology.messages.Results;
import pikater.ontology.messages.Task;

public abstract class Agent_OptionsManager
extends jade.core.Agent {
    private static final long serialVersionUID = -7210526529341802567L;
    private Codec codec = new SLCodec();
    private Ontology ontology = MessagesOntology.getInstance();
    private String trainFileName;
    private String testFileName;
    private Computation receivedComputation;
    private String receiver;
    private String computation_id;
    private String problem_id;
    private String start;
    protected float error_rate = 0.3f;
    protected int maximum_tries = 10;
    private int task_i = 0;
    private long timeout = -1L;
    boolean working = false;
    boolean finished = false;
    protected Evaluation evaluation;
    protected List Options;
    protected Agent Agent;
    private ACLMessage msgPrev = new ACLMessage(6);
    private boolean sendAgain = false;

    protected abstract String getAgentType();

    protected abstract boolean finished();

    protected abstract void generateNewOptions(Evaluation var1);

    protected boolean registerWithDF() {
        DFAgentDescription description = new DFAgentDescription();
        description.setName(this.getAID());
        ServiceDescription servicedesc = new ServiceDescription();
        servicedesc.setName(this.getLocalName());
        String typeDesc = this.getAgentType();
        servicedesc.setType(typeDesc);
        description.addServices(servicedesc);
        ServiceDescription servicedesc_g = new ServiceDescription();
        servicedesc_g.setName(this.getLocalName());
        servicedesc_g.setType("OptionsManager");
        description.addServices(servicedesc_g);
        try {
            DFService.register((jade.core.Agent)this, (DFAgentDescription)description);
            System.out.println(this.getLocalName() + ": successfully registered with DF; service type: " + typeDesc);
            return true;
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + ": error registering with DF, exiting:" + (Object)((Object)e));
            return false;
        }
    }

    protected void setup() {
        System.out.println(this.getLocalName() + " is alive...");
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        this.registerWithDF();
        MessageTemplate template_inform = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchProtocol((String)"fipa-request"), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        AchieveREResponder receive_computation = new AchieveREResponder(this, template_inform){

            protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
                System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": REQUEST received from " + request.getSender().getName() + ".");
                System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": Agree");
                ACLMessage agree = request.createReply();
                agree.setPerformative(1);
                return agree;
            }
        };
        receive_computation.registerPrepareResultNotification((Behaviour)new ComputeComputation(this, null));
        this.addBehaviour((Behaviour)receive_computation);
    }

    private boolean noMutableOptions() {
        for (Option next_option : this.Options) {
            if (!next_option.getMutable()) continue;
            return false;
        }
        return true;
    }

    private String getImmutableOptions() {
        String str = "";
        for (Option next_option : this.Options) {
            if (next_option.getMutable() || next_option.getValue() == null) continue;
            if (next_option.getData_type().equals("BOOLEAN") && next_option.getValue().equals("True")) {
                str = str + "-" + next_option.getName() + " ";
                continue;
            }
            str = str + "-" + next_option.getName() + " " + next_option.getValue() + " ";
        }
        return str;
    }

    private class ComputeComputation
    extends IteratedAchieveREInitiator {
        private static final long serialVersionUID = -138067991593729776L;
        private List results;

        public ComputeComputation(jade.core.Agent a, ACLMessage request) {
            super(a, request);
            this.results = new ArrayList();
            System.out.println(a.getLocalName() + ": ComputeComputation behavior created.");
        }

        protected Vector prepareRequests(ACLMessage request) {
            String incomingRequestKey = ((AchieveREResponder)this.parent).REQUEST_KEY;
            ACLMessage incomingRequest = (ACLMessage)this.getDataStore().get((Object)incomingRequestKey);
            try {
                ContentElement content = Agent_OptionsManager.this.getContentManager().extractContent(incomingRequest);
                if (((Action)content).getAction() instanceof Compute) {
                    Computation computation = ((Compute)((Action)content).getAction()).getComputation();
                    Agent_OptionsManager.this.receivedComputation = computation;
                    Agent_OptionsManager.this.Agent = computation.getAgent();
                    Agent_OptionsManager.this.Options = Agent_OptionsManager.this.Agent.getOptions();
                    Agent_OptionsManager.this.trainFileName = computation.getData().getTrain_file_name();
                    Agent_OptionsManager.this.testFileName = computation.getData().getTest_file_name();
                    Agent_OptionsManager.this.receiver = computation.getAgent().getName();
                    Agent_OptionsManager.this.computation_id = computation.getId();
                    Agent_OptionsManager.this.error_rate = computation.getMethod().getError_rate().floatValue();
                    Agent_OptionsManager.this.maximum_tries = computation.getMethod().getMaximum_tries();
                    Agent_OptionsManager.this.problem_id = computation.getProblem_id();
                    Agent_OptionsManager.this.start = computation.getStart();
                    if (Agent_OptionsManager.this.timeout < 0L) {
                        Agent_OptionsManager.this.timeout = System.currentTimeMillis() + (long)computation.getTimeout();
                    }
                }
            }
            catch (UngroundedException e) {
                e.printStackTrace();
            }
            catch (Codec.CodecException e) {
                e.printStackTrace();
            }
            catch (OntologyException e) {
                e.printStackTrace();
            }
            AID responder = new AID(Agent_OptionsManager.this.receiver, false);
            System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": Forward the request to " + responder.getName());
            ACLMessage outgoingRequest = Agent_OptionsManager.this.sendAgain ? Agent_OptionsManager.this.msgPrev : this.newMessage(request);
            Agent_OptionsManager.this.msgPrev = outgoingRequest;
            Vector<ACLMessage> v = new Vector<ACLMessage>(1);
            v.addElement(outgoingRequest);
            return v;
        }

        protected void handleInform(ACLMessage inform, Vector nextRequests) {
            Agent_OptionsManager.this.sendAgain = false;
            System.out.println(Agent_OptionsManager.this.getLocalName() + ": Agent " + inform.getSender().getName() + " sent a reply.");
            ACLMessage msgNew = this.newMessage(inform);
            nextRequests.add(msgNew);
            this.storeTask();
            if (Agent_OptionsManager.this.finished() || Agent_OptionsManager.this.finished) {
                this.storeNotification(7);
            }
            Agent_OptionsManager.this.msgPrev = msgNew;
        }

        protected void handleRefuse(ACLMessage refuse) {
            System.out.println(Agent_OptionsManager.this.getLocalName() + ": Agent " + refuse.getSender().getName() + " refused to perform the requested action");
            if (System.currentTimeMillis() < Agent_OptionsManager.this.timeout) {
                Agent_OptionsManager.this.doWait(200L);
                this.reset();
                Agent_OptionsManager.this.sendAgain = true;
                Agent_OptionsManager.this.addBehaviour((Behaviour)this);
            } else {
                Agent_OptionsManager.this.finished = true;
                this.storeNotification(6);
            }
        }

        protected void handleFailure(ACLMessage failure) {
            Agent_OptionsManager.this.sendAgain = false;
            if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                System.out.println("Responder does not exist");
                Agent_OptionsManager.this.finished = true;
                this.storeNotification(6);
            } else {
                System.out.println("Agent " + failure.getSender().getName() + " failed to perform the requested action");
                ACLMessage msgNew = this.newMessage(failure);
                Agent_OptionsManager.this.evaluation = new Evaluation();
                Agent_OptionsManager.this.evaluation.setStatus(failure.getContent());
                Vector<ACLMessage> v = new Vector<ACLMessage>(1);
                v.addElement(msgNew);
                String requestsKey = this.ALL_NEXT_REQUESTS_KEY;
                this.getDataStore().put((Object)requestsKey, v);
                this.storeTask();
                if (Agent_OptionsManager.this.finished() || Agent_OptionsManager.this.finished) {
                    this.storeNotification(7);
                }
                Agent_OptionsManager.this.msgPrev = msgNew;
            }
        }

        private void storeTask() {
            try {
                ContentElement content = Agent_OptionsManager.this.getContentManager().extractContent(Agent_OptionsManager.this.msgPrev);
                if (((Action)content).getAction() instanceof Execute) {
                    Task task = ((Execute)((Action)content).getAction()).getTask();
                    task.setResult(Agent_OptionsManager.this.evaluation);
                    this.results.add((Object)task);
                }
            }
            catch (UngroundedException e) {
                e.printStackTrace();
            }
            catch (Codec.CodecException e) {
                e.printStackTrace();
            }
            catch (OntologyException e) {
                e.printStackTrace();
            }
        }

        private void storeNotification(int performative) {
            if (performative == 7) {
                System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": computation executed successfully");
            } else {
                if (performative == 2) {
                    System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": there were no tasks to compute.");
                } else {
                    System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + ": computation failed");
                }
                performative = 6;
            }
            String incomingRequestkey = ((AchieveREResponder)this.parent).REQUEST_KEY;
            ACLMessage incomingRequest = (ACLMessage)this.getDataStore().get((Object)incomingRequestkey);
            ACLMessage msgOut = incomingRequest.createReply();
            msgOut.setPerformative(performative);
            if (Agent_OptionsManager.this.finished() || Agent_OptionsManager.this.finished) {
                System.out.println("Agent " + Agent_OptionsManager.this.getLocalName() + " finished the goal, sending the results to the manager.");
                Results _results = new Results();
                _results.setResults(this.results);
                _results.setComputation_id(Agent_OptionsManager.this.computation_id);
                _results.setProblem_id(Agent_OptionsManager.this.problem_id);
                try {
                    ContentElement content = Agent_OptionsManager.this.getContentManager().extractContent(incomingRequest);
                    Result result = new Result((Concept)((Action)content), (Object)_results);
                    Agent_OptionsManager.this.getContentManager().fillContent(msgOut, (ContentElement)result);
                }
                catch (UngroundedException e) {
                    e.printStackTrace();
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
            }
            String notificationkey = ((AchieveREResponder)this.parent).RESULT_NOTIFICATION_KEY;
            this.getDataStore().put((Object)notificationkey, (Object)msgOut);
        }

        ACLMessage newMessage(ACLMessage _result) {
            ACLMessage msg;
            if (_result != null && _result.getPerformative() != 6) {
                try {
                    Result result;
                    ContentElement content = Agent_OptionsManager.this.getContentManager().extractContent(_result);
                    if (content instanceof Result && (result = (Result)content).getValue() instanceof Evaluation) {
                        Agent_OptionsManager.this.evaluation = (Evaluation)result.getValue();
                    }
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
                System.out.println(Agent_OptionsManager.this.getLocalName() + ": Agent " + _result.getSender().getLocalName() + "'s errorRate was " + Agent_OptionsManager.this.evaluation.getError_rate());
            }
            if (!Agent_OptionsManager.this.finished && !Agent_OptionsManager.this.finished()) {
                if (Agent_OptionsManager.this.Options != null) {
                    Agent_OptionsManager.this.generateNewOptions(Agent_OptionsManager.this.evaluation);
                }
                Agent_OptionsManager.this.Agent.setOptions(Agent_OptionsManager.this.Options);
                System.out.println(Agent_OptionsManager.this.getLocalName() + ": new options for agent " + Agent_OptionsManager.this.receiver + " are " + Agent_OptionsManager.this.Agent.optionsToString());
                msg = new ACLMessage(16);
                msg.setLanguage(Agent_OptionsManager.this.codec.getName());
                msg.setOntology(Agent_OptionsManager.this.ontology.getName());
                msg.addReceiver(new AID(Agent_OptionsManager.this.receiver, false));
                msg.setProtocol("fipa-request");
                msg.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
                Execute execute = new Execute();
                Task task = new Task();
                String id = Agent_OptionsManager.this.computation_id + "_" + Agent_OptionsManager.this.task_i;
                Agent_OptionsManager.this.task_i++;
                task.setId(id);
                task.setComputation_id(Agent_OptionsManager.this.computation_id);
                task.setProblem_id(Agent_OptionsManager.this.problem_id);
                task.setGet_results(Agent_OptionsManager.this.receivedComputation.getGet_results());
                task.setGui_agent(Agent_OptionsManager.this.receivedComputation.getGui_agent());
                task.setData(Agent_OptionsManager.this.receivedComputation.getData());
                task.setAgent(Agent_OptionsManager.this.Agent);
                task.setStart(Agent_OptionsManager.this.start);
                execute.setTask(task);
                Action a = new Action();
                a.setAction((Concept)execute);
                a.setActor(this.myAgent.getAID());
                try {
                    Agent_OptionsManager.this.getContentManager().fillContent(msg, (ContentElement)a);
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
                if (Agent_OptionsManager.this.Options == null || Agent_OptionsManager.this.noMutableOptions()) {
                    Agent_OptionsManager.this.finished = true;
                }
            } else {
                msg = new ACLMessage(2);
            }
            return msg;
        }
    }
}

