/*
 * Decompiled with CFR 0.152.
 */
package pikater.agents.computing;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import pikater.ontology.messages.Data;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.GetData;
import pikater.ontology.messages.GetOptions;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.PartialResults;
import pikater.ontology.messages.SaveAgent;
import pikater.ontology.messages.Task;
import weka.core.Instances;

public abstract class Agent_ComputingAgent
extends Agent {
    private static final long serialVersionUID = -7927583436579620995L;
    protected Codec codec = new SLCodec();
    private Ontology ontology = MessagesOntology.getInstance();
    public String trainFileName;
    public String testFileName;
    public String labelFileName = "";
    public states state = states.NEW;
    public boolean hasGotRightData = false;
    protected pikater.ontology.messages.Agent agent_options = null;
    protected Instances data;
    Instances train;
    DataInstances onto_train;
    Instances test;
    DataInstances onto_test;
    Instances label;
    DataInstances onto_label;
    int convId = 0;
    protected String[] OPTIONS;
    protected Task current_task = null;
    protected String[] OPTIONS_ARGS;
    protected Object[] args;
    boolean working = false;
    LinkedList<ACLMessage> taskFIFO = new LinkedList();
    private Behaviour execution_behaviour = null;
    private Behaviour send_options_behaviour = null;
    private boolean newAgent = true;
    private boolean resurrected = false;

    protected abstract void train() throws Exception;

    protected abstract Evaluation evaluateCA() throws Exception;

    protected abstract DataInstances getPredictions(Instances var1, DataInstances var2);

    public abstract String getAgentType();

    protected abstract void getParameters();

    protected boolean registerWithDF() {
        DFAgentDescription description = new DFAgentDescription();
        description.setName(this.getAID());
        ServiceDescription servicedesc = new ServiceDescription();
        servicedesc.setName(this.getLocalName());
        String typeDesc = this.state == states.TRAINED ? this.getAgentType() + " trained on " + this.trainFileName : this.getAgentType();
        servicedesc.setType(typeDesc);
        description.addServices(servicedesc);
        ServiceDescription servicedesc_g = new ServiceDescription();
        servicedesc_g.setName(this.getLocalName());
        servicedesc_g.setType("ComputingAgent");
        description.addServices(servicedesc_g);
        try {
            DFService.register((Agent)this, (DFAgentDescription)description);
            System.out.println(this.getLocalName() + ": successfully registered with DF; service type: " + typeDesc);
            return true;
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + ": error registering with DF, exiting:" + (Object)((Object)e));
            return false;
        }
    }

    protected void deregisterWithDF() {
        try {
            DFService.deregister((Agent)this);
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + " failed to deregister with DF.");
        }
    }

    protected ACLMessage sendOptions(ACLMessage request) {
        ACLMessage msgOut = request.createReply();
        msgOut.setPerformative(7);
        try {
            ContentElement content = this.getContentManager().extractContent(request);
            Result result = new Result((Concept)((Action)content), (Object)this.agent_options);
            try {
                this.getContentManager().fillContent(msgOut, (ContentElement)result);
            }
            catch (Codec.CodecException ce) {
                ce.printStackTrace();
            }
            catch (OntologyException oe) {
                oe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgOut;
    }

    protected void setup() {
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        if (!this.newAgent) {
            this.resurrected = true;
            System.out.println(this.getLocalName() + " resurrected.");
            this.taskFIFO = new LinkedList();
            this.execution_behaviour.reset();
            this.state = states.TRAINED;
            return;
        }
        this.newAgent = false;
        System.out.println(this.getAgentType() + " " + this.getLocalName() + " is alive...");
        this.args = this.getArguments();
        if (this.args != null && this.args.length > 0) {
            this.OPTIONS_ARGS = new String[this.args.length];
            if (this.args[0].equals("load")) {
                this.args = new String[0];
            } else {
                for (int i = 0; i < this.args.length; ++i) {
                    this.OPTIONS_ARGS[i] = (String)this.args[i];
                }
                for (String s : this.OPTIONS_ARGS) {
                    System.out.print(s + " ");
                }
            }
        }
        this.getParameters();
        this.registerWithDF();
        this.send_options_behaviour = new RequestServer(this);
        this.addBehaviour(this.send_options_behaviour);
        this.execution_behaviour = new ProcessAction(this);
        this.addBehaviour(this.execution_behaviour);
    }

    public boolean setOptions(Task task) {
        this.current_task = task;
        this.OPTIONS = task.getAgent().optionsToString().split("[ ]+");
        return true;
    }

    public String getOptions() {
        String strOPTIONS = "";
        strOPTIONS = strOPTIONS + "OPTIONS:";
        for (int i = 0; i < this.OPTIONS.length; ++i) {
            strOPTIONS = strOPTIONS + " " + this.OPTIONS[i];
        }
        return strOPTIONS;
    }

    protected ACLMessage sendGetDataReq(String fileName) {
        ACLMessage msgOut = null;
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("ARFFReader");
        template.addServices(sd);
        try {
            DFAgentDescription[] result = DFService.search((Agent)this, (DFAgentDescription)template);
            System.out.println("Found the following ARFFReader agents:");
            AID[] ARFFReaders = new AID[result.length];
            for (int i = 0; i < result.length; ++i) {
                ARFFReaders[i] = result[i].getName();
                System.out.println(ARFFReaders[i].getName());
            }
            AID reader = ARFFReaders[0];
            msgOut = new ACLMessage(16);
            msgOut.setProtocol("fipa-request");
            msgOut.setReplyByDate(new Date(System.currentTimeMillis() + 10000L));
            msgOut.setLanguage(this.codec.getName());
            msgOut.setOntology(this.ontology.getName());
            msgOut.addReceiver(reader);
            msgOut.setConversationId("get-data_" + this.convId++);
            GetData get_data = new GetData();
            get_data.setFile_name(fileName);
            Action a = new Action();
            a.setAction((Concept)get_data);
            a.setActor(this.getAID());
            this.getContentManager().fillContent(msgOut, (ContentElement)a);
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
            return null;
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
            return null;
        }
        catch (OntologyException e) {
            e.printStackTrace();
            return null;
        }
        return msgOut;
    }

    public static byte[] toBytes(Object object) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        return baos.toByteArray();
    }

    public static Object toObject(byte[] data) throws Exception {
        Object object = new ObjectInputStream(new ByteArrayInputStream(data)).readObject();
        return object;
    }

    protected void sendResultsToGUI(Boolean first_time, Task _task, List _evaluations) {
        ACLMessage msgOut = new ACLMessage(7);
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("GUIAgent");
        template.addServices(sd);
        try {
            DFAgentDescription[] gui_agents = DFService.search((Agent)this, (DFAgentDescription)template);
            for (int i = 0; i < gui_agents.length; ++i) {
                msgOut.addReceiver(gui_agents[i].getName());
            }
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        msgOut.setConversationId("partial-results");
        PartialResults content = new PartialResults();
        content.setResults(_evaluations);
        content.setTask_id(_task.getId());
        if (first_time.booleanValue()) {
            content.setTask(_task);
        }
        try {
            this.getContentManager().fillContent(msgOut, (ContentElement)content);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        this.send(msgOut);
    }

    private byte[] getAgentObject() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject((Object)this);
        oos.flush();
        oos.close();
        byte[] data = bos.toByteArray();
        return data;
    }

    private pikater.ontology.messages.Agent getAgentWithFilledObject() throws IOException {
        pikater.ontology.messages.Agent savedAgent = this.current_task.getAgent();
        savedAgent.setObject(this.getAgentObject());
        return savedAgent;
    }

    private String saveAgentToFile() throws IOException, Codec.CodecException, OntologyException, FIPAException {
        SaveAgent saveAgent = new SaveAgent();
        saveAgent.setAgent(this.getAgentWithFilledObject());
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("agentManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(this.codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(this.getAID());
        a.setAction((Concept)saveAgent);
        this.getContentManager().fillContent(request, (ContentElement)a);
        ACLMessage reply = FIPAService.doFipaRequestClient((Agent)this, (ACLMessage)request);
        String objectFilename = reply.getContent();
        return objectFilename;
    }

    private class ProcessAction
    extends FSMBehaviour {
        private static final long serialVersionUID = 7417933314402310322L;
        private static final String INIT_STATE = "Init";
        private static final String GETTRAINDATA_STATE = "GetTrainingData";
        private static final String GETTESTDATA_STATE = "GetTestData";
        private static final String GETLABELDATA_STATE = "GetLabelData";
        private static final String TRAINTEST_STATE = "TrainTest";
        private static final String SENDRESULTS_STATE = "SendResults";
        private static final int NEXT_JMP = 0;
        private static final int LAST_JMP = 1;
        ACLMessage incoming_request;
        ACLMessage result_msg;
        Execute execute_action;
        boolean success;
        Evaluation eval;
        String train_fn;
        String test_fn;
        String label_fn;
        String output;
        String mode;

        void failureMsg(String desc) {
            this.result_msg = this.incoming_request.createReply();
            this.result_msg.setPerformative(6);
            this.result_msg.setContent(desc);
        }

        boolean getRequest() {
            if (Agent_ComputingAgent.this.taskFIFO.size() > 0) {
                this.incoming_request = Agent_ComputingAgent.this.taskFIFO.removeFirst();
                try {
                    ContentElement content = Agent_ComputingAgent.this.getContentManager().extractContent(this.incoming_request);
                    this.execute_action = (Execute)((Action)content).getAction();
                    return true;
                }
                catch (Codec.CodecException ce) {
                    ce.printStackTrace();
                }
                catch (OntologyException oe) {
                    oe.printStackTrace();
                }
            } else {
                this.block();
            }
            return false;
        }

        DataInstances processGetData(ACLMessage inform) {
            try {
                Result result;
                ContentElement content = Agent_ComputingAgent.this.getContentManager().extractContent(inform);
                if (content instanceof Result && (result = (Result)content).getValue() instanceof DataInstances) {
                    return (DataInstances)result.getValue();
                }
            }
            catch (UngroundedException e) {
                e.printStackTrace();
            }
            catch (Codec.CodecException e) {
                e.printStackTrace();
            }
            catch (OntologyException e) {
                e.printStackTrace();
            }
            return null;
        }

        ProcessAction(Agent a) {
            super(a);
            this.eval = new Evaluation();
            this.registerFirstState(new Behaviour(a){
                int next;
                boolean cont;

                public void action() {
                    ProcessAction.this.result_msg = null;
                    ProcessAction.this.execute_action = null;
                    if (!ProcessAction.this.getRequest()) {
                        this.cont = true;
                        return;
                    }
                    this.cont = false;
                    if (!Agent_ComputingAgent.this.resurrected) {
                        Agent_ComputingAgent.this.state = states.NEW;
                    }
                    Agent_ComputingAgent.this.setOptions(ProcessAction.this.execute_action.getTask());
                    ProcessAction.this.eval = new Evaluation();
                    ProcessAction.this.success = true;
                    Data data = ProcessAction.this.execute_action.getTask().getData();
                    ProcessAction.this.output = data.getOutput();
                    ProcessAction.this.mode = data.getMode();
                    ProcessAction.this.train_fn = data.getTrain_file_name();
                    AchieveREInitiator get_train_behaviour = (AchieveREInitiator)((ProcessAction)this.parent).getState(ProcessAction.GETTRAINDATA_STATE);
                    if (!ProcessAction.this.train_fn.equals(Agent_ComputingAgent.this.trainFileName)) {
                        get_train_behaviour.reset(Agent_ComputingAgent.this.sendGetDataReq(ProcessAction.this.train_fn));
                    } else {
                        get_train_behaviour.reset(null);
                    }
                    ProcessAction.this.test_fn = data.getTest_file_name();
                    AchieveREInitiator get_test_behaviour = (AchieveREInitiator)((ProcessAction)this.parent).getState(ProcessAction.GETTESTDATA_STATE);
                    if (!ProcessAction.this.test_fn.equals(Agent_ComputingAgent.this.testFileName)) {
                        get_test_behaviour.reset(Agent_ComputingAgent.this.sendGetDataReq(ProcessAction.this.test_fn));
                    } else {
                        get_test_behaviour.reset(null);
                    }
                    if (data.getLabel_file_name() != null) {
                        ProcessAction.this.label_fn = data.getLabel_file_name();
                        AchieveREInitiator get_label_behaviour = (AchieveREInitiator)((ProcessAction)this.parent).getState(ProcessAction.GETLABELDATA_STATE);
                        if (!ProcessAction.this.label_fn.equals(Agent_ComputingAgent.this.labelFileName)) {
                            get_label_behaviour.reset(Agent_ComputingAgent.this.sendGetDataReq(ProcessAction.this.label_fn));
                        } else {
                            get_label_behaviour.reset(null);
                        }
                    }
                }

                public boolean done() {
                    return !this.cont;
                }
            }, INIT_STATE);
            this.registerState((Behaviour)new AchieveREInitiator(a, null){
                public int next;
                {
                    super(x0, x1);
                    this.next = 0;
                }

                protected void handleInform(ACLMessage inform) {
                    DataInstances _train = ProcessAction.this.processGetData(inform);
                    if (_train != null) {
                        Agent_ComputingAgent.this.trainFileName = ProcessAction.this.train_fn;
                        Agent_ComputingAgent.this.onto_train = _train;
                        Agent_ComputingAgent.this.train = Agent_ComputingAgent.this.onto_train.toWekaInstances();
                        Agent_ComputingAgent.this.train.setClassIndex(Agent_ComputingAgent.this.train.numAttributes() - 1);
                        this.next = 0;
                        return;
                    }
                    this.next = 1;
                    ProcessAction.this.failureMsg("No train data received from the reader agent: Wrong content.");
                }

                protected void handleFailure(ACLMessage failure) {
                    ProcessAction.this.failureMsg("No train data received from the reader agent: Reader Failed.");
                    this.next = 1;
                }

                public int onEnd() {
                    int next_val = this.next;
                    this.next = 0;
                    return this.next;
                }
            }, GETTRAINDATA_STATE);
            this.registerState((Behaviour)new AchieveREInitiator(a, null){
                public int next;
                {
                    super(x0, x1);
                    this.next = 0;
                }

                protected void handleInform(ACLMessage inform) {
                    DataInstances _test = ProcessAction.this.processGetData(inform);
                    if (_test != null) {
                        Agent_ComputingAgent.this.testFileName = ProcessAction.this.test_fn;
                        Agent_ComputingAgent.this.onto_test = _test;
                        Agent_ComputingAgent.this.test = Agent_ComputingAgent.this.onto_test.toWekaInstances();
                        Agent_ComputingAgent.this.test.setClassIndex(Agent_ComputingAgent.this.test.numAttributes() - 1);
                        this.next = 0;
                        return;
                    }
                    this.next = 1;
                    ProcessAction.this.failureMsg("No test data received from the reader agent: Wrong content.");
                }

                protected void handleFailure(ACLMessage failure) {
                    ProcessAction.this.failureMsg("No test data received from the reader agent: Reader Failed.");
                    this.next = 1;
                }

                public int onEnd() {
                    int next_val = this.next;
                    this.next = 0;
                    return this.next;
                }
            }, GETTESTDATA_STATE);
            this.registerState((Behaviour)new AchieveREInitiator(a, null){
                public int next;
                {
                    super(x0, x1);
                    this.next = 0;
                }

                protected void handleInform(ACLMessage inform) {
                    DataInstances _label = ProcessAction.this.processGetData(inform);
                    if (_label != null) {
                        Agent_ComputingAgent.this.labelFileName = ProcessAction.this.label_fn;
                        Agent_ComputingAgent.this.onto_label = _label;
                        Agent_ComputingAgent.this.label = Agent_ComputingAgent.this.onto_label.toWekaInstances();
                        Agent_ComputingAgent.this.label.setClassIndex(Agent_ComputingAgent.this.label.numAttributes() - 1);
                        this.next = 0;
                        return;
                    }
                    this.next = 1;
                    ProcessAction.this.failureMsg("No label data received from the reader agent: Wrong content.");
                }

                protected void handleFailure(ACLMessage failure) {
                    ProcessAction.this.failureMsg("No label data received from the reader agent: Reader Failed.");
                    this.next = 1;
                }

                public int onEnd() {
                    int next_val = this.next;
                    this.next = 0;
                    return this.next;
                }
            }, GETLABELDATA_STATE);
            this.registerState(new Behaviour(a){

                public void action() {
                    try {
                        ArrayList labeledData = new ArrayList();
                        if (Agent_ComputingAgent.this.state != states.TRAINED) {
                            Agent_ComputingAgent.this.train();
                        } else if (!Agent_ComputingAgent.this.resurrected && !ProcessAction.this.mode.equals("test_only")) {
                            Agent_ComputingAgent.this.train();
                        }
                        if (Agent_ComputingAgent.this.state == states.TRAINED) {
                            ProcessAction.this.eval = Agent_ComputingAgent.this.evaluateCA();
                            if (ProcessAction.this.output.equals("predictions")) {
                                DataInstances di = new DataInstances();
                                di.fillWekaInstances(Agent_ComputingAgent.this.test);
                                labeledData.add((Object)Agent_ComputingAgent.this.getPredictions(Agent_ComputingAgent.this.test, di));
                                if (!Agent_ComputingAgent.this.labelFileName.equals("")) {
                                    di = new DataInstances();
                                    di.fillWekaInstances(Agent_ComputingAgent.this.label);
                                    labeledData.add((Object)Agent_ComputingAgent.this.getPredictions(Agent_ComputingAgent.this.label, di));
                                }
                                ProcessAction.this.eval.setLabeled_data((List)labeledData);
                            }
                        }
                    }
                    catch (Exception e) {
                        ProcessAction.this.success = false;
                        Agent_ComputingAgent.this.working = false;
                        ProcessAction.this.failureMsg(e.getMessage());
                        System.out.println("Error: " + e.getMessage() + " ");
                        e.printStackTrace();
                    }
                }

                public boolean done() {
                    return Agent_ComputingAgent.this.state == states.TRAINED || !ProcessAction.this.success;
                }
            }, TRAINTEST_STATE);
            this.registerState((Behaviour)new OneShotBehaviour(a){

                public void action() {
                    Result result;
                    ContentElement content;
                    if (ProcessAction.this.success && ProcessAction.this.result_msg == null) {
                        if (Agent_ComputingAgent.this.current_task.getSave_mode() != null && Agent_ComputingAgent.this.current_task.getSave_mode().equals("file") && !Agent_ComputingAgent.this.resurrected) {
                            try {
                                String objectFilename = Agent_ComputingAgent.this.saveAgentToFile();
                                ProcessAction.this.eval.setObject_filename(objectFilename);
                            }
                            catch (Codec.CodecException e) {
                                e.printStackTrace();
                            }
                            catch (OntologyException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (FIPAException e) {
                                e.printStackTrace();
                            }
                        }
                        if (Agent_ComputingAgent.this.current_task.getSave_mode() != null && Agent_ComputingAgent.this.current_task.getSave_mode().equals("message")) {
                            try {
                                ProcessAction.this.eval.setObject(Agent_ComputingAgent.this.getAgentObject());
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        ProcessAction.this.result_msg = ProcessAction.this.incoming_request.createReply();
                        ProcessAction.this.result_msg.setPerformative(7);
                        try {
                            content = Agent_ComputingAgent.this.getContentManager().extractContent(ProcessAction.this.incoming_request);
                            if (Agent_ComputingAgent.this.resurrected) {
                                ProcessAction.this.eval.setObject(null);
                            }
                            result = new Result((Concept)((Action)content), (Object)ProcessAction.this.eval);
                            Agent_ComputingAgent.this.getContentManager().fillContent(ProcessAction.this.result_msg, (ContentElement)result);
                        }
                        catch (UngroundedException e) {
                            e.printStackTrace();
                        }
                        catch (Codec.CodecException e) {
                            e.printStackTrace();
                        }
                        catch (OntologyException e) {
                            e.printStackTrace();
                        }
                    }
                    Agent_ComputingAgent.this.send(ProcessAction.this.result_msg);
                    if (Agent_ComputingAgent.this.current_task.getGet_results().equals("after_each_task")) {
                        if (ProcessAction.this.result_msg.getPerformative() == 6) {
                            ProcessAction.this.eval.setError_rate(2.1474836E9f);
                            ProcessAction.this.eval.setStatus(ProcessAction.this.result_msg.getContent());
                        }
                        Agent_ComputingAgent.this.current_task.setResult(ProcessAction.this.eval);
                        try {
                            content = Agent_ComputingAgent.this.getContentManager().extractContent(ProcessAction.this.incoming_request);
                            if (Agent_ComputingAgent.this.resurrected) {
                                ProcessAction.this.eval.setObject(null);
                            }
                            result = new Result((Concept)((Action)content), (Object)Agent_ComputingAgent.this.current_task);
                            Agent_ComputingAgent.this.getContentManager().fillContent(ProcessAction.this.result_msg, (ContentElement)result);
                        }
                        catch (UngroundedException e) {
                            e.printStackTrace();
                        }
                        catch (Codec.CodecException e) {
                            e.printStackTrace();
                        }
                        catch (OntologyException e) {
                            e.printStackTrace();
                        }
                        ProcessAction.this.result_msg.clearAllReceiver();
                        ProcessAction.this.result_msg.addReceiver(new AID(Agent_ComputingAgent.this.current_task.getGui_agent(), false));
                        ProcessAction.this.result_msg.setConversationId("result_after_task");
                        Agent_ComputingAgent.this.send(ProcessAction.this.result_msg);
                    }
                }
            }, SENDRESULTS_STATE);
            this.registerDefaultTransition(INIT_STATE, GETTRAINDATA_STATE);
            this.registerTransition(GETTRAINDATA_STATE, GETTESTDATA_STATE, 0);
            this.registerTransition(GETTRAINDATA_STATE, SENDRESULTS_STATE, 1);
            this.registerTransition(GETTESTDATA_STATE, GETLABELDATA_STATE, 0);
            this.registerTransition(GETTESTDATA_STATE, SENDRESULTS_STATE, 1);
            this.registerTransition(GETLABELDATA_STATE, TRAINTEST_STATE, 0);
            this.registerTransition(GETLABELDATA_STATE, SENDRESULTS_STATE, 1);
            this.registerDefaultTransition(TRAINTEST_STATE, SENDRESULTS_STATE);
            this.registerDefaultTransition(SENDRESULTS_STATE, INIT_STATE, new String[]{INIT_STATE, GETTRAINDATA_STATE, GETTESTDATA_STATE, GETLABELDATA_STATE, TRAINTEST_STATE, SENDRESULTS_STATE});
        }
    }

    protected class RequestServer
    extends CyclicBehaviour {
        private static final long serialVersionUID = 1074564968341084444L;
        private MessageTemplate resMsgTemplate;

        public RequestServer(Agent agent) {
            super(agent);
            this.resMsgTemplate = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchProtocol((String)"fipa-request"), (MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchLanguage((String)Agent_ComputingAgent.this.codec.getName()), (MessageTemplate)MessageTemplate.MatchOntology((String)Agent_ComputingAgent.this.ontology.getName()))));
        }

        boolean acceptTask() {
            return true;
        }

        ACLMessage processExecute(ACLMessage req) {
            ACLMessage result_msg = req.createReply();
            if (this.acceptTask()) {
                result_msg.setPerformative(1);
                Agent_ComputingAgent.this.taskFIFO.addLast(req);
                if (!Agent_ComputingAgent.this.execution_behaviour.isRunnable()) {
                    Agent_ComputingAgent.this.execution_behaviour.restart();
                }
            } else {
                result_msg.setPerformative(14);
                result_msg.setContent("(Computing agent overloaded)");
            }
            return result_msg;
        }

        public void action() {
            ACLMessage req = Agent_ComputingAgent.this.receive(this.resMsgTemplate);
            if (req != null) {
                try {
                    ContentElement content = Agent_ComputingAgent.this.getContentManager().extractContent(req);
                    if (((Action)content).getAction() instanceof GetOptions) {
                        ACLMessage result_msg = Agent_ComputingAgent.this.sendOptions(req);
                        Agent_ComputingAgent.this.send(result_msg);
                        return;
                    }
                    if (((Action)content).getAction() instanceof Execute) {
                        Agent_ComputingAgent.this.send(this.processExecute(req));
                        return;
                    }
                }
                catch (Codec.CodecException ce) {
                    ce.printStackTrace();
                }
                catch (OntologyException oe) {
                    oe.printStackTrace();
                }
                ACLMessage result_msg = req.createReply();
                result_msg.setPerformative(10);
                Agent_ComputingAgent.this.send(result_msg);
                return;
            }
            this.block();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum states {
        NEW,
        TRAINED;

    }
}

