/*
 * Decompiled with CFR 0.152.
 */
package pikater.agents.computing;

import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Random;
import pikater.agents.computing.Agent_ComputingAgent;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Attribute;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.Instance;
import pikater.ontology.messages.Interval;
import pikater.ontology.messages.Option;
import weka.core.Instances;

public class Agent_Perceptron
extends Agent_ComputingAgent {
    int NEpochs = 10;
    double LearningRate = 0.3;
    List attributes;
    int class_index;
    int[] attr2neur;
    double[] input_vec;
    double[] output_vec;
    double[] weights;
    Random randgen = new Random();
    double[] attributeRanges;
    double[] attributeBases;
    boolean doNormalization = true;

    protected Evaluation evaluateCA() {
        int withclass = 0;
        int incorrect = 0;
        for (Instance next_instance : this.onto_test.getInstances()) {
            if (((Boolean)next_instance.getMissing().get(this.class_index)).booleanValue()) continue;
            ++withclass;
            int prediction = this.evaluateModelOnce(next_instance);
            int y = (int)Math.round((Double)next_instance.getValues().get(this.class_index));
            if (y == prediction) continue;
            ++incorrect;
        }
        float errorRate = (float)incorrect / (float)withclass;
        Evaluation result = new Evaluation();
        result.setError_rate(errorRate);
        result.setKappa_statistic(-1.0f);
        result.setMean_absolute_error(0.0f);
        result.setRelative_absolute_error(0.0f);
        result.setRoot_mean_squared_error(0.0f);
        result.setRoot_relative_squared_error(0.0f);
        return result;
    }

    public String getAgentType() {
        return new String("Perceptron");
    }

    protected void getParameters() {
        this.agent_options = new Agent();
        this.agent_options.setName(this.getLocalName());
        this.agent_options.setType(this.getAgentType());
        ArrayList _options = new ArrayList();
        Option opt = new Option();
        opt.setName("N");
        opt.setData_type("INT");
        opt.setIs_a_set(false);
        Interval interval = new Interval();
        interval.setMin(Float.valueOf(1.0f));
        interval.setMax(Float.valueOf(1000.0f));
        opt.setRange(interval);
        opt.setMutable(false);
        opt.setDescription("Set the number of epochs to train through. (default 10) ");
        opt.setSynopsis("-N num ");
        opt.setDefault_value("10");
        _options.add((Object)opt);
        opt = new Option();
        opt.setName("L");
        opt.setData_type("FLOAT");
        opt.setIs_a_set(false);
        interval = new Interval();
        interval.setMin(Float.valueOf(0.0f));
        interval.setMax(Float.valueOf(1.0f));
        opt.setRange(interval);
        opt.setMutable(false);
        opt.setDescription("Set the learning rate. (default 0.3) ");
        opt.setSynopsis("-L num ");
        opt.setDefault_value("0.3");
        _options.add((Object)opt);
        opt = new Option();
        opt.setName("S");
        opt.setData_type("INT");
        opt.setIs_a_set(false);
        interval = new Interval();
        interval.setMin(Float.valueOf(0.0f));
        interval.setMax(Float.valueOf(2.1474836E9f));
        opt.setRange(interval);
        opt.setMutable(false);
        opt.setDescription("Seed of the random number generator (Value should be >= 0 and and a long, Default = 0). ");
        opt.setSynopsis("-S num ");
        opt.setDefault_value("0");
        _options.add((Object)opt);
        opt = new Option();
        opt.setName("C");
        opt.setData_type("BOOLEAN");
        opt.setIs_a_set(false);
        opt.setMutable(false);
        opt.setDescription("Normalizing a numeric class will NOT be done.(Set this to not normalize the class if it's numeric).");
        opt.setSynopsis("-C");
        opt.setDefault_value("False");
        _options.add((Object)opt);
        this.agent_options.setOptions((List)_options);
    }

    protected DataInstances getPredictions(Instances test, DataInstances ontoTest) {
        for (Instance next_instance : ontoTest.getInstances()) {
            double prediction = this.evaluateModelOnce(next_instance);
            next_instance.setPrediction(prediction);
        }
        return ontoTest;
    }

    public boolean loadAgent(String agentName) {
        return false;
    }

    public boolean saveAgent() {
        return false;
    }

    protected void train() throws Exception {
        this.working = true;
        System.out.println("Agent " + this.getLocalName() + ": Training...");
        this.NEpochs = 10;
        this.LearningRate = 0.3;
        this.randgen.setSeed(0L);
        this.doNormalization = true;
        if (this.current_task.getAgent().getOptions() != null) {
            for (Option next_opt : this.current_task.getAgent().getOptions()) {
                if (next_opt.getName().compareTo("N") == 0) {
                    this.NEpochs = Integer.parseInt(next_opt.getValue());
                    continue;
                }
                if (next_opt.getName().compareTo("L") == 0) {
                    this.LearningRate = Double.parseDouble(next_opt.getValue());
                    continue;
                }
                if (next_opt.getName().compareTo("S") == 0) {
                    this.randgen.setSeed(Integer.parseInt(next_opt.getValue()));
                    continue;
                }
                if (next_opt.getName().compareTo("C") == 0) {
                    this.doNormalization = false;
                    continue;
                }
                System.out.println("Perceptron: Unknown parameter " + next_opt.getName() + ", value:" + next_opt.getValue());
            }
        }
        if (!this.createNet(this.onto_train)) {
            this.working = false;
            throw new Exception("Wrong training data type");
        }
        int ninst = this.onto_train.getInstances().size();
        for (int epoch = 0; epoch < this.NEpochs; ++epoch) {
            for (int i = 0; i < ninst; ++i) {
                Instance next_inst = (Instance)this.onto_train.getInstances().get(this.randgen.nextInt(ninst));
                if (((Boolean)next_inst.getMissing().get(this.class_index)).booleanValue()) continue;
                this.setInput(next_inst);
                this.computeNet();
                this.adaptWeights(((Double)next_inst.getValues().get(this.class_index)).intValue());
            }
        }
        this.state = Agent_ComputingAgent.states.TRAINED;
        this.working = false;
    }

    private boolean createNet(DataInstances instances) {
        int i;
        this.attributes = instances.getAttributes();
        this.class_index = instances.getClass_index();
        if (this.class_index < 0) {
            this.class_index = this.attributes.size() - 1;
        }
        this.attr2neur = new int[this.attributes.size()];
        this.attributeRanges = new double[this.attributes.size()];
        this.attributeBases = new double[this.attributes.size()];
        int index = 0;
        int cur_neu = 1;
        for (Attribute next_attr : this.attributes) {
            this.attr2neur[index] = cur_neu;
            if (index == this.class_index) {
                if (next_attr.getType().compareToIgnoreCase("NOMINAL") != 0) {
                    return false;
                }
                this.output_vec = new double[next_attr.getValues().size()];
            } else {
                int code_size;
                if (next_attr.getType().compareToIgnoreCase("NOMINAL") == 0) {
                    code_size = next_attr.getValues().size();
                } else if (next_attr.getType().compareToIgnoreCase("NUMERIC") == 0) {
                    code_size = 1;
                } else if (next_attr.getType().compareToIgnoreCase("DATE") == 0) {
                    code_size = 1;
                } else {
                    return false;
                }
                cur_neu += code_size;
            }
            ++index;
        }
        double[] mins = new double[this.attributes.size()];
        double[] maxs = new double[this.attributes.size()];
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            mins[i2] = Double.MAX_VALUE;
            maxs[i2] = Double.MIN_VALUE;
        }
        for (Instance inst : instances.getInstances()) {
            Iterator val_iter = inst.getValues().iterator();
            int aind = 0;
            while (val_iter.hasNext()) {
                Double val = (Double)val_iter.next();
                if (val < mins[aind]) {
                    mins[aind] = val;
                }
                if (val > maxs[aind]) {
                    maxs[aind] = val;
                }
                ++aind;
            }
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            this.attributeRanges[i] = (maxs[i] - mins[i]) / 2.0;
            if (this.attributeRanges[i] == 0.0) {
                this.attributeRanges[i] = 1.0;
            }
            this.attributeBases[i] = (maxs[i] + mins[i]) / 2.0;
        }
        this.input_vec = new double[cur_neu];
        this.weights = new double[this.input_vec.length * this.output_vec.length];
        for (i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.randgen.nextDouble() - 0.5;
        }
        return true;
    }

    private void setInput(Instance inst) {
        this.input_vec[0] = -1.0;
        for (int i = 1; i < this.input_vec.length; ++i) {
            this.input_vec[i] = 0.0;
        }
        Iterator val_iter = inst.getValues().iterator();
        Iterator attr_iter = this.attributes.iterator();
        Iterator mis_iter = inst.getMissing().iterator();
        int index = 0;
        while (attr_iter.hasNext()) {
            Attribute next_attr = (Attribute)attr_iter.next();
            Double next_val = (Double)val_iter.next();
            Boolean next_mis = (Boolean)mis_iter.next();
            if (index != this.class_index && !next_mis.booleanValue()) {
                if (next_attr.getType().compareToIgnoreCase("NOMINAL") == 0) {
                    int neu_ind = this.attr2neur[index] + next_val.intValue();
                    this.input_vec[neu_ind] = 1.0;
                } else if (this.doNormalization) {
                    next_val = next_val - this.attributeBases[index];
                    next_val = next_val / this.attributeRanges[index];
                    this.input_vec[this.attr2neur[index]] = next_val;
                }
            }
            ++index;
        }
    }

    private void computeNet() {
        int i;
        int nin = this.input_vec.length;
        int nout = this.output_vec.length;
        for (i = 0; i < nout; ++i) {
            this.output_vec[i] = 0.0;
        }
        for (i = 0; i < this.weights.length; ++i) {
            int o_ind = i / nin;
            int i_ind = i % nin;
            int n = o_ind;
            this.output_vec[n] = this.output_vec[n] + this.weights[i] * this.input_vec[i_ind];
        }
    }

    private void adaptWeights(int right_class) {
        int i;
        int nin = this.input_vec.length;
        int nout = this.output_vec.length;
        int[] errors = new int[nout];
        for (i = 0; i < this.output_vec.length; ++i) {
            errors[i] = 0;
            if (i == right_class) {
                if (!(this.output_vec[i] <= 0.0)) continue;
                errors[i] = 1;
                continue;
            }
            if (!(this.output_vec[i] > 0.0)) continue;
            errors[i] = -1;
        }
        i = 0;
        while (i < this.weights.length) {
            int o_ind = i / nin;
            int i_ind = i % nin;
            int n = i++;
            this.weights[n] = this.weights[n] + this.LearningRate * (double)errors[o_ind] * this.input_vec[i_ind];
        }
    }

    private int evaluateModelOnce(Instance inst) {
        this.setInput(inst);
        this.computeNet();
        int max_ind = 0;
        double max = this.output_vec[0];
        for (int i = 1; i < this.output_vec.length; ++i) {
            if (!(this.output_vec[i] > max)) continue;
            max = this.output_vec[i];
            max_ind = i;
        }
        return max_ind;
    }
}

